/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBit;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLBitList
extends RAMLSimpleType {
    private static final long serialVersionUID = 217359305778671053L;
    private List<RAMLBit> myBits;
    private List<RAMLSpecialValue<Long>> mySpecialValues;
    private RAMLDefaultValue<Long> myDefaultValue;

    public RAMLBitList(Node simpleTypeNode, String valueValidator, RAMLMetaParameter metaParameter) {
        super(simpleTypeNode, valueValidator, metaParameter);
    }

    @Override
    protected void createDefaultValue(Node defaultValueNode) {
        NamedNodeMap attributes = defaultValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        this.myDefaultValue = new RAMLDefaultValue<Long>(Long.parseLong(value), this.createDescriptionFromParentNode(defaultValueNode));
    }

    @Override
    protected void createSpecialValue(Node specialValueNode) {
        NamedNodeMap attributes = specialValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        Node textNode = attributes.getNamedItem("text");
        this.mySpecialValues.add(new RAMLSpecialValue<Long>(Long.parseLong(value), textNode == null ? "" : textNode.getNodeValue()));
    }

    @Override
    protected void createSpecificChildNode(Node childNode) {
        if (childNode.getNodeName().equals("bit")) {
            this.createBit(childNode);
        }
    }

    private void createBit(Node childNode) {
        NamedNodeMap attributes = childNode.getAttributes();
        String number = attributes.getNamedItem("number").getNodeValue();
        String defaultVal = attributes.getNamedItem("default").getNodeValue();
        String text = attributes.getNamedItem("text").getNodeValue();
        Node fixed = attributes.getNamedItem("fixed");
        boolean isFixed = fixed == null ? false : Boolean.parseBoolean(fixed.getNodeValue());
        this.myBits.add(new RAMLBit(Long.parseLong(number), text, isFixed, "1".equals(defaultVal)));
    }

    public List<RAMLBit> getBits() {
        return this.myBits;
    }

    public long generateBitValue(boolean ... bits) {
        long value = 0L;
        int i = 0;
        boolean[] blArray = bits;
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            boolean bit = blArray[n2];
            if (bit) {
                value += this.myBits.get(i).getOnValue();
            }
            ++i;
            ++n2;
        }
        return value;
    }

    public RAMLDefaultValue<Long> getDefaultValue() {
        return this.myDefaultValue;
    }

    public List<RAMLSpecialValue<Long>> getSpecialValues() {
        return this.mySpecialValues;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.myDefaultValue != null;
    }

    @Override
    protected void init() {
        this.myBits = new ArrayList<RAMLBit>();
        this.mySpecialValues = new ArrayList<RAMLSpecialValue<Long>>();
    }

    @Override
    public String getBaseType() {
        return "bit";
    }

    public int getLongestTextLength() {
        int length = 0;
        for (RAMLBit e : this.myBits) {
            if (length == 0) {
                length = e.getText().length();
                continue;
            }
            if (length >= e.getText().length()) continue;
            length = e.getText().length();
        }
        return length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Bit list bits: ");
        sb.append(this.myBits);
        sb.append(" special values:");
        sb.append(this.mySpecialValues);
        sb.append(" ");
        sb.append(" default value:");
        sb.append(this.myDefaultValue);
        return sb.toString();
    }
}

