/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLBitList;
import java.io.Serializable;

public class RAMLBitValidator
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = -4897865935163515515L;
    private transient ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLParameter param = (RAMLParameter)objectToBeValidated;
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        RAMLBitList bits = (RAMLBitList)metaP.getValueType();
        int size = bits.getBits().size();
        boolean[] values = new boolean[size];
        int i = 0;
        while (i < size) {
            values[i] = true;
            ++i;
        }
        long max = bits.generateBitValue(values);
        long value = param.getValueAsLong();
        if (0L > value || value > max) {
            this.createValidationError(validationContext, param, value, metaP, 0L, max);
        }
    }

    private void createValidationError(RAMLValidationContext validationContext, RAMLParameter param, long value, RAMLMetaParameter metaP, long min, long max) {
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        String errorMsg = RAMLValidationErrorMessageFactory.createOutOfRangeErrorMessage(param, metaP, this.generateRangeText(min, max), String.valueOf(value));
        result.setDetails(errorMsg);
        result.setRangeCheckIssue(true);
        validationContext.addResult(result);
    }

    private String generateRangeText(long min, long max) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.myResourceBundle.getString("RAMLValidation.Min.Value"));
        sb.append(" ");
        sb.append(min);
        sb.append(", ");
        sb.append(this.myResourceBundle.getString("RAMLValidation.Max.Value"));
        sb.append(" ");
        sb.append(max);
        return sb.toString();
    }
}

