/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.AllowedValueType;
import java.io.Serializable;

public class RAMLBooleanValidator
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = -6318472321712374335L;
    private transient ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    private AllowedValueType myAllowedValueType = AllowedValueType.TEXT_AND_NUMBER;

    public RAMLBooleanValidator() {
    }

    public RAMLBooleanValidator(AllowedValueType allowedValueType) {
        this();
        this.myAllowedValueType = allowedValueType;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLParameter param = (RAMLParameter)objectToBeValidated;
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        if (!this.isValueValid(param.getValue())) {
            this.createErrorResult(validationContext, param, metaP);
        }
    }

    private void createErrorResult(RAMLValidationContext validationContext, RAMLParameter param, RAMLMetaParameter metaP) {
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        String errorMsg = RAMLValidationErrorMessageFactory.createOutOfRangeErrorMessage(param, metaP, "true, false", param.getValue());
        result.setDetails(errorMsg);
        result.setRangeCheckIssue(true);
        validationContext.addResult(result);
    }

    private boolean isValueValid(String tmp) {
        boolean valueValid = false;
        if (AllowedValueType.TEXT.equals(this.myAllowedValueType)) {
            return "true".equalsIgnoreCase(tmp) || "false".equalsIgnoreCase(tmp);
        }
        if (AllowedValueType.NUMBER.equals(this.myAllowedValueType)) {
            return "0".equals(tmp) || "1".equals(tmp);
        }
        if (AllowedValueType.TEXT_AND_NUMBER.equals(this.myAllowedValueType)) {
            return "true".equalsIgnoreCase(tmp) || "false".equalsIgnoreCase(tmp) || "0".equals(tmp) || "1".equals(tmp);
        }
        return valueValid;
    }

    public static boolean isValueTrue(String value) {
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value) || "1".equalsIgnoreCase(value);
    }

    public static boolean isValueFalse(String value) {
        return "false".equalsIgnoreCase(value) || "0".equalsIgnoreCase(value);
    }
}

