/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLItem;
import com.nokia.em.poseidon.frameworks.raml.RAMLItemList;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaManagedObject;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import com.nokia.em.poseidon.util.GeneralUtils;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RAMLComplexType
implements RAMLValue,
Serializable {
    private static final String SPACE = " ";
    private static final long serialVersionUID = -6788000719388326704L;
    private List<RAMLMetaParameter> myParameters = new ArrayList<RAMLMetaParameter>();
    private RAMLMetaManagedObject myMetaMO;
    private transient ResourceBundle myResourceBundle;

    public RAMLComplexType(Node complexNode, RAMLMetaManagedObject metaMO) {
        this.myMetaMO = metaMO;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.readComplexType(complexNode);
    }

    private void readComplexType(Node complexNode) {
        NodeList childNodes = complexNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("p")) {
                this.myParameters.add(new RAMLMetaParameter(childNode, this.myMetaMO));
            }
            ++i;
        }
    }

    public List<RAMLMetaParameter> getParameters() {
        return this.myParameters;
    }

    public RAMLMetaParameter getParameter(String pName) {
        for (RAMLMetaParameter p : this.myParameters) {
            if (!p.getName().equals(pName)) continue;
            return p;
        }
        return null;
    }

    @Override
    public RAMLValue.Type getType() {
        return RAMLValue.Type.COMPLEX;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLItemList itemList = (RAMLItemList)objectToBeValidated;
        RAMLMetaParameter meta = (RAMLMetaParameter)metaData;
        List<RAMLItem> items = itemList.getItems();
        if (items.size() > meta.getMaxOccurs() && !meta.isDeleted()) {
            RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
            result.setParameterName(itemList.getName());
            result.setDistName(itemList.getManagedObject().getDistName());
            result.setVersion(itemList.getManagedObject().getVersion());
            result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
            Object[] values = new Object[]{itemList.getName(), items.size(), meta.getMaxOccurs()};
            result.setDetails(MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Too.Many.Parameters"), values));
            validationContext.setValidatedObject(itemList.getManagedObject());
            validationContext.addResult(result);
        }
        for (RAMLMetaParameter metaParameter : this.getParameters()) {
            int i = 0;
            while (i < items.size()) {
                boolean isEmpty;
                RAMLItem tmpItem = items.get(i);
                RAMLParameter parameter = tmpItem.getParameter(metaParameter.getName());
                validationContext.setValidatedObject(tmpItem);
                boolean hasMandatoryCheck = metaParameter.hasMandatoryCheck(tmpItem, itemList.getManagedObject());
                boolean isMandatory = metaParameter.isMandatory() || hasMandatoryCheck;
                boolean notDeletedAndHidden = !metaParameter.isDeleted() && !metaParameter.isHidden();
                boolean bl = isEmpty = parameter == null || parameter.getValue().trim().length() == 0;
                if (isMandatory && notDeletedAndHidden && isEmpty) {
                    this.createMandatoryParameterNotFoundError(validationContext, itemList, metaParameter);
                } else if (parameter != null && !metaParameter.isDeleted() && !metaParameter.isSetByTheSystem()) {
                    if (metaParameter.isSimpleType()) {
                        RAMLSimpleType simple = (RAMLSimpleType)metaParameter.getValueType();
                        String name = String.valueOf(itemList.getName()) + " (" + meta.getFullName() + ")";
                        simple.putProperty("listName", name);
                    }
                    metaParameter.validate(validationContext, parameter);
                }
                ++i;
            }
        }
        validationContext.setValidatedObject(null);
    }

    private void createMandatoryParameterNotFoundError(RAMLValidationContext validationContext, RAMLItemList itemList, RAMLMetaParameter metaParameter) {
        List<SortedSet<String>> reasons = metaParameter.getReasons();
        List<String> relationshipIds = metaParameter.getRelationshipIds();
        if (reasons.isEmpty()) {
            this.createMandatoryErrors(validationContext, itemList, metaParameter, "", null);
        } else {
            int index = 0;
            while (index < reasons.size()) {
                this.createMandatoryErrors(validationContext, itemList, metaParameter, reasons.get(index), relationshipIds.get(index));
                ++index;
            }
        }
    }

    private void createMandatoryErrors(RAMLValidationContext validationContext, RAMLItemList itemList, RAMLMetaParameter metaParameter, SortedSet<String> reasons, String relationshipId) {
        String reason = RAMLValidationErrorMessageFactory.concatenateReasons(reasons);
        this.createMandatoryErrors(validationContext, itemList, metaParameter, reason, relationshipId);
    }

    private void createMandatoryErrors(RAMLValidationContext validationContext, RAMLItemList itemList, RAMLMetaParameter metaParameter, String reason, String relationshipId) {
        boolean hasReason = !GeneralUtils.isEmptyString(reason);
        String details = hasReason ? String.valueOf(this.myResourceBundle.getString("RAMLValidation.Because")) + SPACE + reason : "";
        String itemListFullName = itemList.getMetaData() != null && itemList.getMetaData().getFullName() != null ? itemList.getMetaData().getFullName() : itemList.getName();
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(metaParameter.getName());
        result.setDistName(itemList.getManagedObject().getDistName());
        result.setVersion(itemList.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incomplete.Configuration"));
        Object[] values = new Object[]{metaParameter.getName(), metaParameter.getFullName(), itemList.getName(), itemListFullName, details};
        details = hasReason ? MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Missing.Mandatory.List.Parameter.WithReason"), values) : MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Missing.Mandatory.List.Parameter"), values);
        result.setDetails(details);
        result.setRelationshipId(relationshipId);
        validationContext.addResult(result);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" Complex type, parameters:\n");
        for (RAMLMetaParameter p : this.getParameters()) {
            sb.append(p.toString());
        }
        return sb.toString();
    }
}

