/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLNumber;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLDecimal
extends RAMLNumber {
    private static final long serialVersionUID = -4375246687914481487L;
    private RAMLDefaultValue<Double> myDefaultValue;
    private List<RAMLSpecialValue<Double>> mySpecialValues;
    private DecimalFormat myDecimalFormat;

    public RAMLDecimal(Node decimalNode, String valueValidator, RAMLMetaParameter metaParameter) {
        super(decimalNode, valueValidator, metaParameter);
    }

    @Override
    protected void createDefaultValue(Node defaultValueNode) {
        NamedNodeMap attributes = defaultValueNode.getAttributes();
        Node defaultVal = attributes.getNamedItem("value");
        if (defaultVal == null) {
            return;
        }
        String value = defaultVal.getNodeValue();
        this.myDefaultValue = new RAMLDefaultValue<Double>(Double.parseDouble(value), this.createDescriptionFromParentNode(defaultValueNode));
    }

    public int getDigits() {
        Integer divisor = (Integer)this.getDivisor();
        int maxValue = this.getLongestDigits();
        int divLength = divisor > 1 && divisor < 10 ? 1 : String.valueOf(divisor).length() - 1;
        return divLength > maxValue || maxValue == 1 ? divLength : maxValue;
    }

    private int getLongestDigits() {
        int min = this.getDigitCount((Double)this.getMinValue());
        int max = this.getDigitCount((Double)this.getMaxValue());
        int step = this.getDigitCount((Double)this.getStep());
        int length = 0;
        if (min > length) {
            length = min;
        }
        if (max > length) {
            length = max;
        }
        if (step > length) {
            length = step;
        }
        return length;
    }

    private int getDigitCount(Double value) {
        if (value == null) {
            return 0;
        }
        String valueString = this.myDecimalFormat.format(value);
        if (valueString.indexOf(".") != -1) {
            return valueString.substring(valueString.indexOf(".")).length() - 1;
        }
        return 0;
    }

    @Override
    protected void createSpecialValue(Node specialValueNode) {
        NamedNodeMap attributes = specialValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        Node textNode = attributes.getNamedItem("text");
        this.mySpecialValues.add(new RAMLSpecialValue<Double>(Double.parseDouble(value), textNode == null ? "" : textNode.getNodeValue()));
    }

    public RAMLDefaultValue<Double> getDefaultValue() {
        return this.myDefaultValue;
    }

    public List<RAMLSpecialValue<Double>> getSpecialValues() {
        return this.mySpecialValues;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.myDefaultValue != null;
    }

    @Override
    protected void init() {
        this.myDecimalFormat = new DecimalFormat();
        this.myDecimalFormat.setDecimalSeparatorAlwaysShown(false);
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        this.myDecimalFormat.setDecimalFormatSymbols(symbols);
        this.mySpecialValues = new ArrayList<RAMLSpecialValue<Double>>();
        this.setMultiplier(1);
        this.setDivisor(1);
        this.setShift(new Double(0.0));
    }

    @Override
    protected Number createDividor(Node dividorValue) {
        if (dividorValue == null) {
            return 1;
        }
        return Integer.parseInt(dividorValue.getNodeValue());
    }

    @Override
    protected Number createMaxValue(Node maxValue) {
        if (maxValue == null) {
            return null;
        }
        return Double.parseDouble(maxValue.getNodeValue());
    }

    @Override
    protected Number createMinValue(Node minValue) {
        if (minValue == null) {
            return null;
        }
        return Double.parseDouble(minValue.getNodeValue());
    }

    @Override
    protected Number createMultiplicand(Node multiplicandValue) {
        if (multiplicandValue == null) {
            return 1;
        }
        return Integer.parseInt(multiplicandValue.getNodeValue());
    }

    @Override
    protected Number createShift(Node shift) {
        if (shift == null) {
            return new Double(0.0);
        }
        return Double.parseDouble(shift.getNodeValue());
    }

    @Override
    protected Number createStepValue(Node stepValue) {
        if (stepValue == null) {
            return null;
        }
        return Double.parseDouble(stepValue.getNodeValue());
    }

    @Override
    public String getBaseType() {
        return "decimal";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Decimal min: ");
        sb.append(this.getValueAsString(this.getMinValue()));
        sb.append(" max: ");
        sb.append(this.getValueAsString(this.getMaxValue()));
        sb.append(" step:");
        sb.append(this.getValueAsString(this.getStep()));
        sb.append(" shift:");
        sb.append(this.getValueAsString(this.getShift()));
        sb.append(" multiplier:");
        sb.append(this.getValueAsString(this.getMultiplier()));
        sb.append(" divisor:");
        sb.append(this.getValueAsString(this.getDivisor()));
        sb.append(" special values:");
        sb.append(this.getSpecialValues());
        sb.append(" ");
        sb.append(this.getDefaultValue());
        return sb.toString();
    }

    private String getValueAsString(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }
}

