/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.AllowedNumberType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDecimal;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.util.CoordinatesUtils;
import com.nokia.em.poseidon.util.GPSValue;
import com.nokia.em.poseidon.util.GeneralUtils;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class RAMLDecimalValidator
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = 8159000819827186751L;
    private transient ResourceBundle myResourceBundle;
    public static final int MAXIMUM_FRACTION_DIGITS = 10;
    private AllowedNumberType myAllowedValueType;
    private DecimalFormat myDf = new DecimalFormat();
    private char myDecimalChar = this.myDf.getDecimalFormatSymbols().getDecimalSeparator();

    public RAMLDecimalValidator() {
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myAllowedValueType = AllowedNumberType.DECIMAL;
    }

    public RAMLDecimalValidator(AllowedNumberType allowedNumberType) {
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myAllowedValueType = allowedNumberType;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLParameter param = (RAMLParameter)objectToBeValidated;
        String paramValue = param.getValue();
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        RAMLDecimal decimalMetadata = (RAMLDecimal)((RAMLMetaParameter)metaData).getValueType();
        if (!TextUtils.isNumeric(paramValue)) {
            RAMLLogicalValidatorBase.createInvalidValueError(validationContext, param, paramValue, metaP, decimalMetadata);
            return;
        }
        BigDecimal bigValue = new BigDecimal(paramValue);
        String uiValue = param.getValue();
        Double min = (Double)decimalMetadata.getMinValue();
        Double max = (Double)decimalMetadata.getMaxValue();
        Double step = (Double)decimalMetadata.getStep();
        if (RAMLDecimalValidator.isSpecialValue(bigValue.doubleValue(), decimalMetadata.getSpecialValues())) {
            return;
        }
        Integer multiplier = (Integer)decimalMetadata.getMultiplier();
        Integer divisor = (Integer)decimalMetadata.getDivisor();
        Double shift = (Double)decimalMetadata.getShift();
        BigDecimal bigMultiplier = new BigDecimal(multiplier);
        BigDecimal bigDivisor = new BigDecimal(divisor);
        BigDecimal bigShift = new BigDecimal(shift);
        bigValue = bigValue.multiply(bigMultiplier);
        bigValue = bigValue.divide(bigDivisor);
        bigValue = bigValue.add(bigShift);
        int maxAllowedDecimal = -1;
        if (this.isInteger(bigValue.doubleValue())) {
            uiValue = String.valueOf(bigValue.longValue());
        } else {
            ArrayList<Double> list = new ArrayList<Double>(3);
            list.add(min);
            list.add(max);
            list.add(step);
            maxAllowedDecimal = this.getMaxFractionDigits(list);
            this.myDf.setMaximumFractionDigits(maxAllowedDecimal);
            uiValue = this.myDf.format(bigValue);
        }
        if (step != null && !RAMLDecimalValidator.isValidStep(bigValue.doubleValue(), min, step)) {
            this.createValidationError(validationContext, param, uiValue, metaP, decimalMetadata);
        } else if (min != null && min > bigValue.doubleValue() || max != null && bigValue.doubleValue() > max) {
            this.createValidationError(validationContext, param, uiValue, metaP, decimalMetadata);
        } else if (maxAllowedDecimal > -1 && this.getFractionDigit(bigValue.doubleValue()) > maxAllowedDecimal) {
            this.createValidationError(validationContext, param, bigValue.toPlainString(), metaP, decimalMetadata);
        } else if (AllowedNumberType.INTEGER.equals(this.myAllowedValueType) && Double.parseDouble(paramValue) != Math.floor(Double.parseDouble(paramValue))) {
            RAMLLogicalValidatorBase.createInvalidValueError(validationContext, param, paramValue, metaP, decimalMetadata);
        }
    }

    private int getFractionDigit(Double value) {
        if (value == null || this.isInteger(value)) {
            return 0;
        }
        String minString = RAMLDecimalValidator.formatDouble(value);
        return minString.length() - 1 - minString.lastIndexOf(this.myDecimalChar);
    }

    private int getMaxFractionDigits(List<Double> list) {
        int max = 0;
        for (Double item : list) {
            max = Math.max(max, this.getFractionDigit(item));
        }
        return max;
    }

    public static final boolean isValidStep(double value, double step) {
        return RAMLDecimalValidator.isValidStep(String.valueOf(value), String.valueOf(step));
    }

    public static final boolean isValidStep(double value, double min, double step) {
        return RAMLDecimalValidator.isValidStep(String.valueOf(value), String.valueOf(min), String.valueOf(step));
    }

    public static final boolean isValidStep(String value, String minimum, String step) {
        String val = value;
        String min = minimum;
        try {
            val = RAMLDecimalValidator.formatDouble(Double.valueOf(val));
            min = RAMLDecimalValidator.formatDouble(Double.valueOf(min));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return RAMLDecimalValidator.isValidStep(RAMLDecimalValidator.subtract(val, min), step);
    }

    private static String subtract(String a, String b) {
        String aa = a;
        String bb = b;
        int digits = 0;
        if (aa.indexOf(".") >= 0) {
            digits = Math.max(digits, aa.length() - aa.indexOf(".") - 1);
        }
        if (bb.indexOf(".") >= 0) {
            digits = Math.max(digits, bb.length() - bb.indexOf(".") - 1);
        }
        if (digits > 0) {
            if (aa.indexOf(".") < 0) {
                aa = String.valueOf(aa) + ".";
            }
            if (bb.indexOf(".") < 0) {
                bb = String.valueOf(bb) + ".";
            }
            while (aa.length() - aa.indexOf(".") <= digits) {
                aa = String.valueOf(aa) + "0";
            }
            while (bb.length() - bb.indexOf(".") <= digits) {
                bb = String.valueOf(bb) + "0";
            }
        }
        if (aa.indexOf(".") >= 0) {
            aa = String.valueOf(aa.substring(0, aa.indexOf("."))) + aa.substring(aa.indexOf(".") + 1);
        }
        if (bb.indexOf(".") >= 0) {
            bb = String.valueOf(bb.substring(0, bb.indexOf("."))) + bb.substring(bb.indexOf(".") + 1);
        }
        while (aa.startsWith("0") && aa.length() > 1) {
            aa = aa.substring(1);
        }
        while (bb.startsWith("0") && bb.length() > 1) {
            bb = bb.substring(1);
        }
        return String.valueOf((double)(Long.valueOf(aa) - Long.valueOf(bb)) / Math.pow(10.0, digits));
    }

    public static final boolean isValidStep(String value, String step) {
        String st;
        String val;
        block18: {
            val = value;
            st = step;
            try {
                val = RAMLDecimalValidator.formatDouble(Double.valueOf(val));
                st = RAMLDecimalValidator.formatDouble(Double.valueOf(st));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (val.startsWith("-")) {
                val = val.substring(1);
            }
            if (st.startsWith("-")) {
                st = st.substring(1);
            }
            try {
                int digits = 0;
                if (val.indexOf(".") >= 0) {
                    digits = Math.max(digits, val.length() - val.indexOf(".") - 1);
                }
                if (st.indexOf(".") >= 0) {
                    digits = Math.max(digits, st.length() - st.indexOf(".") - 1);
                }
                if (digits > 0) {
                    if (val.indexOf(".") < 0) {
                        val = String.valueOf(val) + ".";
                    }
                    if (st.indexOf(".") < 0) {
                        st = String.valueOf(st) + ".";
                    }
                    while (val.length() - val.indexOf(".") <= digits) {
                        val = String.valueOf(val) + "0";
                    }
                    while (st.length() - st.indexOf(".") <= digits) {
                        st = String.valueOf(st) + "0";
                    }
                }
                if (val.indexOf(".") >= 0) {
                    val = String.valueOf(val.substring(0, val.indexOf("."))) + val.substring(val.indexOf(".") + 1);
                }
                if (st.indexOf(".") >= 0) {
                    st = String.valueOf(st.substring(0, st.indexOf("."))) + st.substring(st.indexOf(".") + 1);
                }
                while (val.startsWith("0")) {
                    val = val.substring(1);
                }
                while (st.startsWith("0")) {
                    st = st.substring(1);
                }
                if (!"".equalsIgnoreCase(val) && !"".equalsIgnoreCase(st)) break block18;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return Long.valueOf(val) % Long.valueOf(st) == 0L;
    }

    private static String formatDouble(Double doubleValue) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMaximumFractionDigits(10);
        return nf.format(doubleValue);
    }

    private void createValidationError(RAMLValidationContext validationContext, RAMLParameter param, String convertedValue, RAMLMetaParameter metaP, RAMLDecimal decimalMetadata) {
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        String errorMsg = RAMLValidationErrorMessageFactory.createOutOfRangeErrorMessage(param, metaP, this.generateRangeText(decimalMetadata, true, metaP), this.generateParameterValue(convertedValue, metaP));
        result.setDetails(errorMsg);
        result.setRangeCheckIssue(true);
        validationContext.addResult(result);
    }

    private String generateParameterValue(String convertedValue, RAMLMetaParameter metaP) {
        if (metaP.hasDMSProperty("DMS latitude") || metaP.hasDMSProperty("DMS longitude")) {
            GPSValue gpsValue = new GPSValue();
            CoordinatesUtils.convertSCFValueToDMSValue(convertedValue, gpsValue);
            String[] dmsValues = gpsValue.getDMSValues();
            String degrees = dmsValues[0];
            String minutes = dmsValues[1];
            String seconds = dmsValues[2];
            seconds = seconds.substring(0, seconds.indexOf("."));
            return String.valueOf(degrees) + "\u00b0" + minutes + "'" + seconds + "\"";
        }
        return convertedValue;
    }

    private String generateRangeText(RAMLDecimal decimalMetadata, boolean includeStep, RAMLMetaParameter metaP) {
        if (metaP.hasDMSProperty("DMS latitude")) {
            String latitudeRangeText = CoordinatesUtils.getDMSRange("DMS latitude");
            return latitudeRangeText.substring(1, latitudeRangeText.indexOf("]"));
        }
        if (metaP.hasDMSProperty("DMS longitude")) {
            String longituderangeText = CoordinatesUtils.getDMSRange("DMS longitude");
            return longituderangeText.substring(1, longituderangeText.indexOf("]"));
        }
        return this.generateGenericRangeText(decimalMetadata, includeStep);
    }

    private String generateGenericRangeText(RAMLDecimal decimalMetadata, boolean includeStep) {
        Number min = this.getUIValue((Double)decimalMetadata.getMinValue());
        Number max = this.getUIValue((Double)decimalMetadata.getMaxValue());
        Number step = this.getUIValue((Double)decimalMetadata.getStep());
        StringBuilder sb = new StringBuilder();
        sb.append(this.myResourceBundle.getString("RAMLValidation.Min.Value"));
        sb.append(" ");
        sb.append(min == null ? this.myResourceBundle.getString("RAMLValidation.Unspecified") : min);
        sb.append(", ");
        sb.append(this.myResourceBundle.getString("RAMLValidation.Max.Value"));
        sb.append(" ");
        sb.append(max == null ? this.myResourceBundle.getString("RAMLValidation.Unspecified") : max);
        if (includeStep && step != null) {
            sb.append(", ");
            sb.append(this.myResourceBundle.getString("RAMLValidation.Step.Value"));
            sb.append(" ");
            sb.append(step);
        }
        return sb.toString();
    }

    public static boolean isSpecialValue(double value, List<RAMLSpecialValue<Double>> specialValues) {
        for (RAMLSpecialValue<Double> special : specialValues) {
            if (!GeneralUtils.isEqual(special.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    private Number getUIValue(Double value) {
        if (value != null && this.isInteger(value)) {
            return value.longValue();
        }
        return value;
    }

    private boolean isInteger(Double value) {
        return Math.floor(value) == value;
    }
}

