/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLEnum
extends RAMLSimpleType {
    private static final long serialVersionUID = 8461429391431674989L;
    private RAMLDefaultValue<Integer> myDefaultValue;
    private List<RAMLSpecialValue<Integer>> mySpecialValues;
    private List<EnumEntry> myEntries;
    private List<String> myTextValues;

    public RAMLEnum(Node simpleTypeNode, String valueValidator, RAMLMetaParameter metaParameter) {
        super(simpleTypeNode, valueValidator, metaParameter);
    }

    @Override
    protected void createDefaultValue(Node defaultValueNode) {
        NamedNodeMap attributes = defaultValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        this.myDefaultValue = new RAMLDefaultValue<Integer>(Integer.parseInt(value), this.createDescriptionFromParentNode(defaultValueNode));
    }

    @Override
    protected void createSpecialValue(Node specialValueNode) {
        NamedNodeMap attributes = specialValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        Node textNode = attributes.getNamedItem("text");
        this.mySpecialValues.add(new RAMLSpecialValue<Integer>(Integer.parseInt(value), textNode == null ? "" : textNode.getNodeValue()));
    }

    @Override
    protected void createSpecificChildNode(Node childNode) {
        if (childNode.getNodeName().equals("enumeration")) {
            this.createEnum(childNode);
        }
    }

    private void createEnum(Node childNode) {
        NamedNodeMap attributes = childNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        Node text = attributes.getNamedItem("text");
        String textValue = text == null ? "" : text.getNodeValue();
        EnumEntry enumE = new EnumEntry(Integer.parseInt(value), textValue);
        this.myEntries.add(enumE);
        this.myTextValues.add(textValue);
    }

    public RAMLDefaultValue<Integer> getDefaultValue() {
        return this.myDefaultValue;
    }

    public List<RAMLSpecialValue<Integer>> getSpecialValues() {
        return this.mySpecialValues;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.getDefaultValue() != null;
    }

    @Override
    protected void init() {
        this.myEntries = new ArrayList<EnumEntry>();
        this.myTextValues = new ArrayList<String>();
        this.mySpecialValues = new ArrayList<RAMLSpecialValue<Integer>>();
    }

    public int[] getIndexes() {
        int[] indexs = new int[this.myEntries.size()];
        int i = 0;
        while (i < this.myEntries.size()) {
            EnumEntry e = this.myEntries.get(i);
            indexs[i] = e.getIndex();
            ++i;
        }
        return indexs;
    }

    public List<String> getTexts() {
        return this.myTextValues;
    }

    public Map<Integer, String> getTextsAsMap() {
        HashMap<Integer, String> texts = new HashMap<Integer, String>();
        for (EnumEntry e : this.myEntries) {
            texts.put(e.getIndex(), e.getText());
        }
        return texts;
    }

    public int getLongestTextLength() {
        int length = 0;
        for (EnumEntry e : this.myEntries) {
            if (length == 0) {
                length = e.getText().length();
                continue;
            }
            if (length >= e.getText().length()) continue;
            length = e.getText().length();
        }
        return length;
    }

    public String getText(int index) {
        for (EnumEntry e : this.myEntries) {
            if (e.getIndex() != index) continue;
            return e.getText();
        }
        return null;
    }

    public int getIndex(String text) {
        for (EnumEntry e : this.myEntries) {
            if (!text.equals(e.getText())) continue;
            return e.getIndex();
        }
        return -1;
    }

    @Override
    public String getBaseType() {
        return "enumeration";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Enum entries: ");
        sb.append(this.myEntries);
        sb.append(" special values:");
        sb.append(this.getSpecialValues());
        sb.append(" ");
        sb.append(this.getDefaultValue());
        return sb.toString();
    }

    private static final class EnumEntry
    implements Serializable {
        private int myIndex;
        private String myText;

        private EnumEntry(int index, String text) {
            this.myIndex = index;
            this.myText = text;
        }

        public int getIndex() {
            return this.myIndex;
        }

        public String getText() {
            return this.myText;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("key: ");
            sb.append(this.myIndex);
            sb.append(" text: ");
            sb.append(this.myText);
            return sb.toString();
        }
    }
}

