/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.AllowedValueType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLEnum;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import java.io.Serializable;
import java.util.List;

public class RAMLEnumValidator
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = -3962426538223894711L;
    private transient ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    private AllowedValueType myAllowedValueType = AllowedValueType.TEXT_AND_NUMBER;

    public RAMLEnumValidator() {
    }

    public RAMLEnumValidator(AllowedValueType allowedValueType) {
        this();
        this.myAllowedValueType = allowedValueType;
    }

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        int enumIndex;
        RAMLParameter param = (RAMLParameter)objectToBeValidated;
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        String tmp = param.getValue();
        RAMLEnum enumMetadata = (RAMLEnum)metaP.getValueType();
        if (AllowedValueType.TEXT_AND_NUMBER.equals(this.myAllowedValueType) || AllowedValueType.TEXT.equals(this.myAllowedValueType)) {
            for (String s : enumMetadata.getTexts()) {
                if (!tmp.equals(s)) continue;
                return;
            }
        }
        if ((AllowedValueType.TEXT_AND_NUMBER.equals(this.myAllowedValueType) || AllowedValueType.NUMBER.equals(this.myAllowedValueType)) && RAMLEnumValidator.isNumber(tmp) && !this.isSpecialValue(enumIndex = Integer.parseInt(tmp), enumMetadata.getSpecialValues())) {
            int[] nArray = enumMetadata.getIndexes();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i == enumIndex) {
                    return;
                }
                ++n2;
            }
        }
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        String errorMsg = RAMLValidationErrorMessageFactory.createOutOfRangeErrorMessage(param, metaP, this.createRangeText(enumMetadata), param.getValue().toString());
        result.setDetails(errorMsg);
        result.setRangeCheckIssue(true);
        validationContext.addResult(result);
    }

    private String createRangeText(RAMLEnum enumMetadata) {
        StringBuilder sb;
        block5: {
            boolean first;
            block4: {
                sb = new StringBuilder();
                first = true;
                if (!AllowedValueType.NUMBER.equals(this.myAllowedValueType) && !AllowedValueType.TEXT_AND_NUMBER.equals(this.myAllowedValueType)) break block4;
                int[] nArray = enumMetadata.getIndexes();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Integer i = nArray[n2];
                    if (!first) {
                        sb.append(",");
                    }
                    sb.append(i);
                    first = false;
                    ++n2;
                }
                break block5;
            }
            if (!AllowedValueType.TEXT.equals(this.myAllowedValueType) && !AllowedValueType.TEXT_AND_NUMBER.equals(this.myAllowedValueType)) break block5;
            for (String text : enumMetadata.getTexts()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(text);
                first = false;
            }
        }
        return sb.toString();
    }

    public static boolean isNumber(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char[] letters = value.trim().toCharArray();
        boolean startsWithSign = letters[0] == '-' || letters[0] == '+';
        boolean signFound = false;
        boolean pointFound = false;
        char[] cArray = letters;
        int n = letters.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!Character.isDigit(c)) {
                if (!signFound && startsWithSign && (c == '-' || c == '+')) {
                    signFound = true;
                } else if (!(pointFound || c != ',' && c != '.')) {
                    pointFound = true;
                } else {
                    return false;
                }
            }
            ++n2;
        }
        return true;
    }

    public boolean isSpecialValue(int value, List<RAMLSpecialValue<Integer>> specialValues) {
        for (RAMLSpecialValue<Integer> special : specialValues) {
            if (special.getValue() != value) continue;
            return true;
        }
        return false;
    }
}

