/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLNumber;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLInteger
extends RAMLNumber {
    private static final long serialVersionUID = -805707043011681672L;
    private RAMLDefaultValue<Integer> myDefaultValue;
    private List<RAMLSpecialValue<Integer>> mySpecialValues;

    public RAMLInteger(Node integerNode, String valueValidator, RAMLMetaParameter metaParameter) {
        super(integerNode, valueValidator, metaParameter);
    }

    @Override
    protected void createDefaultValue(Node defaultValueNode) {
        NamedNodeMap attributes = defaultValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        this.myDefaultValue = new RAMLDefaultValue<Integer>(Integer.parseInt(value), this.createDescriptionFromParentNode(defaultValueNode));
    }

    @Override
    protected void createSpecialValue(Node specialValueNode) {
        NamedNodeMap attributes = specialValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        Node textNode = attributes.getNamedItem("text");
        this.mySpecialValues.add(new RAMLSpecialValue<Integer>(Integer.parseInt(value), textNode == null ? "" : textNode.getNodeValue()));
    }

    public RAMLDefaultValue<Integer> getDefaultValue() {
        return this.myDefaultValue;
    }

    public List<RAMLSpecialValue<Integer>> getSpecialValues() {
        return this.mySpecialValues;
    }

    @Override
    public boolean hasDefaultValue() {
        return this.myDefaultValue != null;
    }

    @Override
    protected void init() {
        this.mySpecialValues = new ArrayList<RAMLSpecialValue<Integer>>();
        this.setMultiplier(1);
        this.setDivisor(1);
        this.setShift(0);
    }

    @Override
    protected Number createDividor(Node dividorValue) {
        if (dividorValue == null) {
            return 1;
        }
        return Integer.parseInt(dividorValue.getNodeValue());
    }

    @Override
    protected Number createMaxValue(Node maxValue) {
        if (maxValue == null) {
            return null;
        }
        return Integer.parseInt(maxValue.getNodeValue());
    }

    @Override
    protected Number createMinValue(Node minValue) {
        if (minValue == null) {
            return null;
        }
        return Integer.parseInt(minValue.getNodeValue());
    }

    @Override
    protected Number createMultiplicand(Node multiplicandValue) {
        if (multiplicandValue == null) {
            return 1;
        }
        return Integer.parseInt(multiplicandValue.getNodeValue());
    }

    @Override
    protected Number createShift(Node shift) {
        if (shift == null) {
            return 0;
        }
        return Integer.parseInt(shift.getNodeValue());
    }

    @Override
    protected Number createStepValue(Node stepValue) {
        if (stepValue == null) {
            return null;
        }
        return Integer.parseInt(stepValue.getNodeValue());
    }

    @Override
    public String getBaseType() {
        return "integer";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Integer min: ");
        sb.append(this.getMinValue().toString());
        sb.append(" max: ");
        sb.append(this.getMaxValue().toString());
        sb.append(" step:");
        sb.append(this.getStep().toString());
        sb.append(" shift:");
        sb.append(this.getShift().toString());
        sb.append(" multiplier:");
        sb.append(this.getMultiplier().toString());
        sb.append(" divisor:");
        sb.append(this.getDivisor().toString());
        sb.append(" special values:");
        sb.append(this.getSpecialValues());
        sb.append(" ");
        sb.append(this.getDefaultValue());
        return sb.toString();
    }
}

