/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.logical.RAMLLogicalValidatorBase;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLInteger;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.util.TextUtils;
import java.io.Serializable;
import java.util.List;

public class RAMLIntegerValidator
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = 6297664969530423288L;
    private transient ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLParameter param = (RAMLParameter)objectToBeValidated;
        String paramValue = param.getValue();
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        RAMLInteger intMetadata = (RAMLInteger)metaP.getValueType();
        if (!TextUtils.isNumeric(paramValue)) {
            RAMLLogicalValidatorBase.createInvalidValueError(validationContext, param, paramValue, metaP, intMetadata);
            return;
        }
        Integer tmp = Integer.parseInt(param.getValue());
        Integer min = (Integer)intMetadata.getMinValue();
        Integer max = (Integer)intMetadata.getMaxValue();
        Integer step = (Integer)intMetadata.getStep();
        if (RAMLIntegerValidator.isSpecialValue(tmp, intMetadata.getSpecialValues())) {
            return;
        }
        Integer multiplier = (Integer)intMetadata.getMultiplier();
        Integer divisor = (Integer)intMetadata.getDivisor();
        Integer shift = (Integer)intMetadata.getShift();
        tmp = tmp * multiplier;
        tmp = tmp / divisor;
        tmp = tmp + shift;
        if (min != null && min > tmp || max != null && tmp > max) {
            this.createValidationError(validationContext, param, metaP, intMetadata, false);
        } else if (step != null && tmp % step != 0) {
            this.createValidationError(validationContext, param, metaP, intMetadata, true);
        }
    }

    private void createValidationError(RAMLValidationContext validationContext, RAMLParameter param, RAMLMetaParameter metaP, RAMLInteger integerMetadata, boolean includeStep) {
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        String errorMsg = RAMLValidationErrorMessageFactory.createOutOfRangeErrorMessage(param, metaP, this.generateRangeText(integerMetadata, includeStep), param.getValue().toString());
        result.setDetails(errorMsg);
        result.setRangeCheckIssue(true);
        validationContext.addResult(result);
    }

    private String generateRangeText(RAMLInteger integerMetadata, boolean includeStep) {
        Integer min = (Integer)integerMetadata.getMinValue();
        Integer max = (Integer)integerMetadata.getMaxValue();
        Integer step = (Integer)integerMetadata.getStep();
        StringBuilder sb = new StringBuilder();
        sb.append(this.myResourceBundle.getString("RAMLValidation.Min.Value"));
        sb.append(" ");
        sb.append(min == null ? this.myResourceBundle.getString("RAMLValidation.Unspecified") : min);
        if (includeStep && min != null && step != null) {
            sb.append(",");
            sb.append(min + step);
            sb.append("...");
            sb.append(",");
        } else {
            sb.append(", ");
        }
        sb.append(this.myResourceBundle.getString("RAMLValidation.Max.Value"));
        sb.append(" ");
        sb.append(max == null ? this.myResourceBundle.getString("RAMLValidation.Unspecified") : max);
        return sb.toString();
    }

    public static boolean isSpecialValue(int value, List<RAMLSpecialValue<Integer>> specialValues) {
        for (RAMLSpecialValue<Integer> special : specialValues) {
            if (special.getValue() != value) continue;
            return true;
        }
        return false;
    }
}

