/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RAMLNumber
extends RAMLSimpleType {
    private static final long serialVersionUID = -1469033703862176624L;
    private Number myMinValue;
    private Number myMaxValue;
    private Number myStep;
    private Number myMultiplier;
    private Number myDivisor;
    private Number myShift;
    private String myUnitType;

    public RAMLNumber(Node numberNode, String valueValidator, RAMLMetaParameter metaParameter) {
        super(numberNode, valueValidator, metaParameter);
    }

    @Override
    protected void createSpecificChildNode(Node childNode) {
        if (childNode.getNodeName().equals("editing")) {
            this.createEditSettings(childNode);
        }
    }

    private void createEditSettings(Node editingNode) {
        NamedNodeMap attributes = editingNode.getAttributes();
        Node type = attributes.getNamedItem("units");
        this.myUnitType = type == null ? "" : type.getNodeValue();
        this.myMultiplier = this.createMultiplicand(attributes.getNamedItem("multiplicand"));
        this.myDivisor = this.createDividor(attributes.getNamedItem("divisor"));
        this.myShift = this.createShift(attributes.getNamedItem("shift"));
        NodeList childNodes = editingNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("range")) {
                this.createRange(childNode);
            } else if (nodeName.equals("default")) {
                this.createDefaultValue(childNode);
            }
            ++i;
        }
    }

    private void createRange(Node rangeNode) {
        NamedNodeMap attributes = rangeNode.getAttributes();
        this.myMinValue = this.createMinValue(attributes.getNamedItem("minIncl"));
        this.myMaxValue = this.createMaxValue(attributes.getNamedItem("maxIncl"));
        this.myStep = this.createStepValue(attributes.getNamedItem("step"));
    }

    protected abstract Number createMinValue(Node var1);

    protected abstract Number createMaxValue(Node var1);

    protected abstract Number createMultiplicand(Node var1);

    protected abstract Number createDividor(Node var1);

    protected abstract Number createShift(Node var1);

    protected abstract Number createStepValue(Node var1);

    public <T> T getMinValue() {
        return (T)this.myMinValue;
    }

    public <T> T getMaxValue() {
        return (T)this.myMaxValue;
    }

    public <T> T getStep() {
        return (T)this.myStep;
    }

    public <T> T getMultiplier() {
        return (T)this.myMultiplier;
    }

    public <T> T getDivisor() {
        return (T)this.myDivisor;
    }

    public <T> T getShift() {
        return (T)this.myShift;
    }

    public String getUnitType() {
        return this.myUnitType;
    }

    public boolean hasRange() {
        return this.getMinValue() != null && this.getMaxValue() != null;
    }

    public boolean hasStep() {
        return this.getStep() != null;
    }

    public void setMultiplier(Number multiplier) {
        this.myMultiplier = multiplier;
    }

    public void setDivisor(Number divisor) {
        this.myDivisor = divisor;
    }

    public void setShift(Number shift) {
        this.myShift = shift;
    }
}

