/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameterList;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLDescription;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class RAMLSimpleType
implements RAMLValue,
Serializable {
    private static final long serialVersionUID = -4144883409477739749L;
    public static final String PROPERTY_LIST_NAME = "listName";
    private RAMLMetaParameter myMetaParameter;
    private Map<String, String> myProperties;
    private String myValidatorType;

    public RAMLSimpleType(Node simpleTypeNode, String valueValidator, RAMLMetaParameter metaParameter) {
        this.myMetaParameter = metaParameter;
        this.myProperties = new HashMap<String, String>();
        this.myValidatorType = valueValidator;
        this.init();
        this.readChildNodes(simpleTypeNode);
    }

    public void putProperty(String propertyName, String propertyValue) {
        this.myProperties.put(propertyName, propertyValue);
    }

    public String getProperty(String propertyName) {
        return this.myProperties.get(propertyName);
    }

    @Override
    public RAMLValue.Type getType() {
        return RAMLValue.Type.SIMPLE;
    }

    private void readChildNodes(Node simpleTypeNode) {
        NodeList childNodes = simpleTypeNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("special")) {
                this.createSpecialValue(childNode);
            } else if (nodeName.equals("default")) {
                if (childNode.hasAttributes()) {
                    this.createDefaultValue(childNode);
                }
            } else {
                this.createSpecificChildNode(childNode);
            }
            ++i;
        }
    }

    protected abstract void init();

    protected RAMLDescription createDescriptionFromParentNode(Node parentNode) {
        RAMLDescription desc = null;
        NodeList childNodes = parentNode.getChildNodes();
        Node childNode = null;
        int i = 0;
        while (i < childNodes.getLength()) {
            childNode = childNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (nodeName.equals("description")) {
                desc = new RAMLDescription(childNode);
            }
            ++i;
        }
        return desc;
    }

    protected abstract void createSpecificChildNode(Node var1);

    protected abstract void createSpecialValue(Node var1);

    protected abstract void createDefaultValue(Node var1);

    public abstract boolean hasDefaultValue();

    public abstract <T> T getDefaultValue();

    public abstract <T> List<RAMLSpecialValue<T>> getSpecialValues();

    public abstract String getBaseType();

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        if (!this.isEmptyOptional(metaData, objectToBeValidated)) {
            RAMLValidator validator = this.myMetaParameter.getMetaManagedObject().getValidator(this.myValidatorType);
            validator.validate(validationContext, metaData, objectToBeValidated);
        }
    }

    public boolean isEmptyOptional(Object metaData, Object objectToBeValidated) {
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        if (objectToBeValidated instanceof RAMLParameter) {
            RAMLParameter param = (RAMLParameter)objectToBeValidated;
            if ("optional".equals(metaP.getCreationType()) && param.getValue() != null && "".equals(param.getValue())) {
                return true;
            }
        } else if (objectToBeValidated instanceof RAMLParameterList) {
            RAMLParameterList list = (RAMLParameterList)objectToBeValidated;
            if ("optional".equals(metaP.getCreationType()) && list.getListObjects() != null && list.getListObjects().size() != 0) {
                return true;
            }
        }
        return false;
    }
}

