/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLDefaultValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSimpleType;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RAMLString
extends RAMLSimpleType {
    private static final long serialVersionUID = 724736550703473054L;
    private int myMinLength;
    private int myMaxLength;
    private int myFixedLength;
    private RAMLDefaultValue<String> myDefaultValue;
    private List<RAMLSpecialValue<String>> mySpecialValues;

    public RAMLString(Node stringNode, String valueValidator, RAMLMetaParameter metaParameter) {
        super(stringNode, valueValidator, metaParameter);
    }

    @Override
    public void init() {
        this.myMinLength = -1;
        this.myMaxLength = -1;
        this.myFixedLength = -1;
        this.mySpecialValues = new ArrayList<RAMLSpecialValue<String>>();
    }

    @Override
    protected void createSpecialValue(Node specialValueNode) {
        NamedNodeMap attributes = specialValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        Node textNode = attributes.getNamedItem("text");
        this.mySpecialValues.add(new RAMLSpecialValue<String>(value, textNode == null ? "" : textNode.getNodeValue()));
    }

    public RAMLDefaultValue<String> getDefaultValue() {
        return this.myDefaultValue;
    }

    public List<RAMLSpecialValue<String>> getSpecialValues() {
        return this.mySpecialValues;
    }

    @Override
    protected void createSpecificChildNode(Node childNode) {
        NamedNodeMap attributes = childNode.getAttributes();
        if ("minLength".equals(childNode.getNodeName())) {
            this.myMinLength = Integer.parseInt(attributes.getNamedItem("value").getNodeValue());
        } else if ("maxLength".equals(childNode.getNodeName())) {
            this.myMaxLength = Integer.parseInt(attributes.getNamedItem("value").getNodeValue());
        } else if ("length".equals(childNode.getNodeName())) {
            this.myFixedLength = Integer.parseInt(attributes.getNamedItem("value").getNodeValue());
        }
    }

    public int getMinLength() {
        return this.myMinLength;
    }

    public int getMaxLength() {
        return this.myMaxLength;
    }

    public int getFixedLength() {
        return this.myFixedLength;
    }

    @Override
    protected void createDefaultValue(Node defaultValueNode) {
        NamedNodeMap attributes = defaultValueNode.getAttributes();
        String value = attributes.getNamedItem("value").getNodeValue();
        this.myDefaultValue = new RAMLDefaultValue<String>(value, this.createDescriptionFromParentNode(defaultValueNode));
    }

    @Override
    public boolean hasDefaultValue() {
        return this.myDefaultValue != null;
    }

    @Override
    public String getBaseType() {
        return "string";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("String fixed length: ");
        sb.append(this.myFixedLength);
        sb.append(" min length:");
        sb.append(this.myMinLength);
        sb.append(" max length ");
        sb.append(this.myMaxLength);
        sb.append(" special values: ");
        sb.append(this.getSpecialValues());
        sb.append(" ");
        sb.append(this.getDefaultValue());
        return sb.toString();
    }
}

