/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.raml.metadata.values;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.raml.RAMLParameter;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationContext;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationErrorMessageFactory;
import com.nokia.em.poseidon.frameworks.raml.RAMLValidationResult;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLMetaParameter;
import com.nokia.em.poseidon.frameworks.raml.metadata.RAMLValidator;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLSpecialValue;
import com.nokia.em.poseidon.frameworks.raml.metadata.values.RAMLString;
import com.nokia.em.poseidon.util.TextUtils;
import com.nokia.widgets.ipfield.rules.IpRule;
import com.nokia.widgets.ipfield.rules.IpRuleFactory;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;

public class RAMLStringValidator
implements RAMLValidator,
Serializable {
    private static final long serialVersionUID = -6294410918787024661L;
    private static final List<IpRule> ipv6PatternList = IpRuleFactory.getIpv6Rules();
    private transient ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());

    @Override
    public void validate(RAMLValidationContext validationContext, Object metaData, Object objectToBeValidated) {
        RAMLString stringMetadata;
        RAMLParameter param = (RAMLParameter)objectToBeValidated;
        RAMLMetaParameter metaP = (RAMLMetaParameter)metaData;
        String tmp = param.getValue();
        if (this.isSpecialValue(tmp, (stringMetadata = (RAMLString)metaP.getValueType()).getSpecialValues())) {
            return;
        }
        if (metaP.isIPv6Address() && metaP.isIPv4Address()) {
            this.validateIPAddress(metaP, validationContext, param);
            return;
        }
        if (metaP.isIPv6Address()) {
            this.validateIPv6Address(metaP, validationContext, param);
            return;
        }
        if (metaP.isIPv4Address()) {
            this.validateIPv4Address(metaP, validationContext, param);
            return;
        }
        if (!this.isWithinRange(tmp, metaP)) {
            this.validateLength(metaP, validationContext, param);
        } else if (metaP.getRegularExpression() != null && !this.isRegularExpressionSkipped(param)) {
            this.validateRegularExpression(metaP, validationContext, param);
        }
    }

    public void createErrorResult(int min, int max, RAMLMetaParameter metaP, RAMLValidationContext validationContext, RAMLParameter param) {
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        String errorMsg = RAMLValidationErrorMessageFactory.createOutOfRangeErrorMessage(param, metaP, this.generateRangeText(min, max), param.getValue().toString());
        result.setDetails(errorMsg);
        result.setRangeCheckIssue(true);
        validationContext.addResult(result);
    }

    private String generateRangeText(int min, int max) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.myResourceBundle.getString("RAMLValidation.Min.Length"));
        sb.append(" ");
        sb.append(min == -1 ? this.myResourceBundle.getString("RAMLValidation.Unspecified") : Integer.valueOf(min));
        sb.append(" ");
        sb.append(this.myResourceBundle.getString("RAMLValidation.And"));
        sb.append(" ");
        sb.append(this.myResourceBundle.getString("RAMLValidation.Max.Length"));
        sb.append(" ");
        sb.append(max == -1 ? this.myResourceBundle.getString("RAMLValidation.Unspecified") : Integer.valueOf(max));
        return sb.toString();
    }

    private void validateRegularExpression(RAMLMetaParameter metaP, RAMLValidationContext validationContext, RAMLParameter param) {
        String regularExpression = param.getValue();
        if (!metaP.isValueValid(regularExpression)) {
            this.generateMetadataRegularExpressionError(metaP, param, regularExpression, validationContext);
        }
    }

    private void validateIPv6Address(RAMLMetaParameter metaP, RAMLValidationContext validationContext, RAMLParameter param) {
        if (!this.isIPv6AddressValid(param.getValue())) {
            validationContext.addResult(this.createInvalidIPResult(metaP, param));
        }
    }

    private void validateIPv4Address(RAMLMetaParameter metaP, RAMLValidationContext validationContext, RAMLParameter param) {
        if (!this.isIPAddressValid(param.getValue())) {
            validationContext.addResult(this.createInvalidIPResult(metaP, param));
        }
    }

    private void validateIPAddress(RAMLMetaParameter metaP, RAMLValidationContext validationContext, RAMLParameter param) {
        String ipAddress = param.getValue();
        if (!this.isIPAddressValid(ipAddress) && !this.isIPv6AddressValid(ipAddress)) {
            validationContext.addResult(this.createInvalidIPResult(metaP, param));
        }
    }

    private boolean isIPAddressValid(String ipAddress) {
        if ("".equals(ipAddress.trim())) {
            return false;
        }
        if (".".equals(ipAddress.substring(ipAddress.length() - 1))) {
            return false;
        }
        String[] numbers = ipAddress.split("\\.");
        if (numbers.length != 4) {
            return false;
        }
        String[] stringArray = numbers;
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            int num;
            String number;
            block11: {
                block10: {
                    number = stringArray[n2];
                    if (number.length() > 3) {
                        return false;
                    }
                    try {
                        num = Integer.parseInt(number);
                        if (String.valueOf(num).length() == number.length()) break block10;
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                if (num >= 0 && num <= 255) break block11;
                return false;
            }
            if (num == 0 && number.length() > 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean isIPv6AddressValid(String ipAddress) {
        for (IpRule ipv6Pattern : ipv6PatternList) {
            if (!ipv6Pattern.matches(ipAddress)) continue;
            return true;
        }
        return false;
    }

    private RAMLValidationResult createInvalidIPResult(RAMLMetaParameter metaP, RAMLParameter param) {
        String detailsString = RAMLValidationErrorMessageFactory.createInvalidValueErrorMessage(metaP, param);
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        result.setDetails(detailsString);
        return result;
    }

    public boolean isSpecialValue(String value, List<RAMLSpecialValue<String>> specialValues) {
        for (RAMLSpecialValue<String> special : specialValues) {
            if (!special.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    private boolean isRegularExpressionSkipped(RAMLParameter param) {
        Object managedObjectProperty = param.getManagedObject().getProperty("Skip regular expression validation");
        if (managedObjectProperty == null) {
            return false;
        }
        return (Boolean)managedObjectProperty;
    }

    private void validateLength(RAMLMetaParameter metadata, RAMLValidationContext validationContext, RAMLParameter param) {
        int[] minMaxLength = this.determineMinMaxLength(metadata);
        this.createErrorResult(minMaxLength[0], minMaxLength[1], metadata, validationContext, param);
    }

    private int[] determineMinMaxLength(RAMLMetaParameter metadata) {
        RAMLString stringMetadata = (RAMLString)metadata.getValueType();
        int minLength = stringMetadata.getMinLength();
        int maxLength = stringMetadata.getMaxLength();
        int fixedLength = stringMetadata.getFixedLength();
        if (fixedLength > -1) {
            minLength = fixedLength;
            maxLength = fixedLength;
        }
        return new int[]{minLength, maxLength};
    }

    private boolean isWithinRange(String paramValue, RAMLMetaParameter metadata) {
        int[] minMaxLength;
        int paramValueLength = TextUtils.getCharacterNumber(metadata, paramValue);
        return paramValueLength >= (minMaxLength = this.determineMinMaxLength(metadata))[0] && paramValueLength <= minMaxLength[1];
    }

    private void generateMetadataRegularExpressionError(RAMLMetaParameter metaP, RAMLParameter param, String value, RAMLValidationContext validationContext) {
        Object[] texts = new Object[]{param.getName(), metaP.getFullName(), value, metaP.getRegularExpression()};
        String msg = MessageFormat.format(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter.Value"), texts);
        RAMLValidationResult result = new RAMLValidationResult(RAMLValidationResult.State.ERROR);
        result.setParameterName(param.getName());
        result.setDistName(param.getManagedObject().getDistName());
        result.setVersion(param.getManagedObject().getVersion());
        result.setText(this.myResourceBundle.getString("RAMLValidation.Incorrect.Parameter"));
        result.setDetails(msg);
        validationContext.addResult(result);
    }
}

