/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.tree;

import com.nokia.em.poseidon.frameworks.tree.BranchNode;
import com.nokia.em.poseidon.frameworks.tree.BranchNodeImpl;
import com.nokia.em.poseidon.frameworks.tree.Node;
import com.nokia.em.poseidon.frameworks.tree.RootNode;
import com.nokia.em.poseidon.frameworks.tree.TreeHelper;

abstract class AbstractNode
implements Node,
Comparable<AbstractNode> {
    private String myId;
    private BranchNodeImpl myParent;
    private int myWeight;

    public AbstractNode() {
    }

    public AbstractNode(BranchNode parent, int weight) {
        this.myWeight = weight;
        this.setParent(parent);
    }

    @Override
    public int compareTo(AbstractNode other) {
        return this.myWeight - other.myWeight;
    }

    @Override
    public Node findNode(String id) {
        RootNode root = this.getRoot();
        return root == null ? (id.equals(this.myId) ? this : null) : root.findNode(this, id);
    }

    @Override
    public String getId() {
        RootNode root = this.getRoot();
        return root == null ? this.myId : root.getIdOf(this);
    }

    @Override
    public BranchNode getParent() {
        RootNode root = this.getRoot();
        return root == null ? this.myParent : root.getParentOf(this);
    }

    @Override
    public Node[] getPath() {
        RootNode root = this.getRoot();
        return root == null ? TreeHelper.getPath(this) : root.getPathTo(this);
    }

    @Override
    public RootNode getRoot() {
        return this.myParent == null ? null : this.myParent.getRoot();
    }

    @Override
    public int getWeight() {
        RootNode root = this.getRoot();
        return root == null ? this.myWeight : root.getWeightOf(this);
    }

    @Override
    public void setId(String id) {
        RootNode root = this.getRoot();
        if (root == null) {
            this.myId = id;
        } else {
            root.setIdFor(this, id);
        }
    }

    @Override
    public void setParent(BranchNode parent) {
        if (parent == null) {
            throw new NullPointerException("setParent(): parent can not be null");
        }
        RootNode root = parent.getRoot();
        if (root == null) {
            TreeHelper.setParent(this, (BranchNodeImpl)parent);
        } else {
            root.setParentFor(this, parent);
        }
    }

    @Override
    public void setWeight(int weight) {
        RootNode root = this.getRoot();
        if (root == null) {
            this.myWeight = weight;
        } else {
            root.setWeightFor(this, weight);
        }
    }

    String getIdImpl() {
        return this.myId;
    }

    BranchNodeImpl getParentImpl() {
        return this.myParent;
    }

    int getWeightImpl() {
        return this.myWeight;
    }

    void setIdImpl(String id) {
        this.myId = id;
    }

    void setParentImpl(BranchNodeImpl parent) {
        this.myParent = parent;
    }

    boolean setWeightImpl(int weight) {
        int oldWeight = this.myWeight;
        this.myWeight = weight;
        return oldWeight != weight;
    }
}

