/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.tree;

import com.nokia.em.poseidon.frameworks.tree.AbstractNode;
import com.nokia.em.poseidon.frameworks.tree.BranchNode;
import com.nokia.em.poseidon.frameworks.tree.Node;
import com.nokia.em.poseidon.frameworks.tree.RootNode;
import com.nokia.em.poseidon.frameworks.tree.TreeFactory;
import com.nokia.em.poseidon.frameworks.tree.TreeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class BranchNodeImpl
extends AbstractNode
implements BranchNode {
    private final List<AbstractNode> myImmediateChildren = new ArrayList<AbstractNode>(10);

    public BranchNodeImpl() {
    }

    public BranchNodeImpl(BranchNodeImpl parent, int weight) {
        super(parent, weight);
    }

    @Override
    public void add(Node child) {
        RootNode root = this.getRoot();
        if (root == null) {
            TreeHelper.addChild(this, (AbstractNode)child);
        } else {
            root.add(this, child);
        }
    }

    @Override
    public BranchNode createBranch() {
        return TreeFactory.createBranch(this);
    }

    @Override
    public BranchNode createBranch(int weight) {
        return TreeFactory.createBranch(this, weight);
    }

    @Override
    public Object find(Object target) {
        RootNode root = this.getRoot();
        return root == null ? this.findImpl(target) : root.find(this, target);
    }

    @Override
    public Node findNode(String id) {
        RootNode root = this.getRoot();
        return root == null ? this.findNodeImpl(id) : root.findNode(this, id);
    }

    @Override
    public List<Node> getChildren() {
        RootNode root = this.getRoot();
        return root == null ? new ArrayList<AbstractNode>(this.myImmediateChildren) : root.getChildrenOf(this);
    }

    @Override
    public void remove(Node child) {
        RootNode root = this.getRoot();
        if (root == null) {
            TreeHelper.removeChild(this, (AbstractNode)child);
        } else {
            root.remove(this, child);
        }
    }

    Object findImpl(Object target) {
        int i = this.myImmediateChildren.size();
        while (--i >= 0) {
            Object object;
            AbstractNode child = this.myImmediateChildren.get(i);
            Object object2 = object = child instanceof BranchNodeImpl ? ((BranchNodeImpl)child).findImpl(target) : child.find(target);
            if (object == null) continue;
            return object;
        }
        return null;
    }

    Node findNodeImpl(String id) {
        if (id.equals(this.getIdImpl())) {
            return this;
        }
        ArrayList<BranchNodeImpl> branches = new ArrayList<BranchNodeImpl>(this.myImmediateChildren.size());
        int i = this.myImmediateChildren.size();
        while (--i >= 0) {
            AbstractNode child = this.myImmediateChildren.get(i);
            if (id.equals(child.getId())) {
                return child;
            }
            if (!(child instanceof BranchNodeImpl)) continue;
            branches.add((BranchNodeImpl)child);
        }
        for (BranchNodeImpl branch : branches) {
            Node node = branch.findNodeImpl(id);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    List<AbstractNode> getChildrenImpl() {
        return this.myImmediateChildren;
    }

    void sortChildren() {
        Collections.sort(this.myImmediateChildren);
    }
}

