/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.tree;

import com.nokia.em.poseidon.frameworks.tree.BranchNode;
import com.nokia.em.poseidon.frameworks.tree.BranchNodeImpl;
import com.nokia.em.poseidon.frameworks.tree.Node;
import com.nokia.em.poseidon.frameworks.tree.RootNode;
import com.nokia.em.poseidon.frameworks.tree.RootNodeImpl;
import com.nokia.em.poseidon.frameworks.tree.SynchronisedRootNodeImpl;
import java.util.List;

public final class TreeFactory {
    public static BranchNode createBranch(BranchNode parent) {
        return TreeFactory.createBranch(parent, 0);
    }

    public static BranchNode createBranch(BranchNode parent, int weight) {
        return new BranchNodeImpl((BranchNodeImpl)parent, weight);
    }

    public static RootNode createRoot() {
        return new RootNodeImpl();
    }

    public static RootNode createSynchronisedRoot() {
        return new SynchronisedRootNodeImpl();
    }

    public static String debug(RootNode root) {
        return TreeFactory.debug(new StringBuilder(), root, 0).toString();
    }

    private static StringBuilder debug(StringBuilder builder, Node node, int indent) {
        TreeFactory.indent(builder, indent);
        builder.append('(').append(node.getWeight()).append(") ");
        builder.append(node.getClass().getName()).append('\n');
        if (node instanceof BranchNode) {
            List<Node> children = ((BranchNode)node).getChildren();
            int i = children.size();
            while (--i >= 0) {
                TreeFactory.debug(builder, children.get(i), indent + 2);
            }
        }
        return builder;
    }

    private static void indent(StringBuilder builder, int indent) {
        int i = indent;
        while (--i >= 0) {
            builder.append(' ');
        }
    }

    private TreeFactory() {
    }
}

