/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.tree;

import com.nokia.em.poseidon.frameworks.tree.AbstractNode;
import com.nokia.em.poseidon.frameworks.tree.BranchNodeImpl;
import com.nokia.em.poseidon.frameworks.tree.Node;
import java.util.ArrayList;

final class TreeHelper {
    public static void addChild(BranchNodeImpl parent, AbstractNode child) {
        if (parent == child) {
            throw new IllegalArgumentException("child can not be parent to itself");
        }
        BranchNodeImpl oldParent = child.getParentImpl();
        if (oldParent != parent) {
            if (TreeHelper.isAncestorOf(child, parent)) {
                throw new IllegalArgumentException("parent cannot be child to one of its children");
            }
            if (oldParent != null) {
                TreeHelper.removeChild(oldParent, child);
            }
            child.setParentImpl(parent);
            parent.getChildrenImpl().add(child);
            parent.sortChildren();
        }
    }

    public static Node[] getPath(Node node) {
        ArrayList<AbstractNode> reversePath = new ArrayList<AbstractNode>(10);
        AbstractNode tmp = (AbstractNode)node;
        do {
            reversePath.add(tmp);
        } while ((tmp = tmp.getParentImpl()) != null);
        Node[] path = new Node[reversePath.size()];
        int i = path.length;
        while (--i >= 0) {
            path[i] = (Node)reversePath.remove(0);
        }
        return path;
    }

    public static void removeChild(BranchNodeImpl parent, AbstractNode child) {
        if (child.getParentImpl() == parent) {
            child.setParentImpl(null);
        }
        parent.getChildrenImpl().remove(child);
    }

    public static void setParent(AbstractNode node, BranchNodeImpl parent) {
        TreeHelper.addChild(parent, node);
    }

    private static boolean isAncestorOf(AbstractNode ancestor, AbstractNode child) {
        BranchNodeImpl tmp = child.getParentImpl();
        return tmp == ancestor || tmp != null && TreeHelper.isAncestorOf(ancestor, tmp);
    }

    private TreeHelper() {
    }
}

