/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.wizard;

import com.nokia.em.poseidon.frameworks.wizard.PWizardModeling;
import com.nokia.em.poseidon.frameworks.wizard.PWizardPage;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PWizardGroup {
    private List myPages = new LinkedList();
    private final String myName;
    private PWizardModeling myModel;

    public PWizardGroup(String name) {
        this.myName = name;
    }

    public PWizardGroup() {
        this("");
    }

    public PWizardModeling getModel() {
        return this.myModel;
    }

    public void addPage(PWizardPage page) {
        if (page != null) {
            this.myPages.add(page);
            PWizardModeling model = this.getModel();
            if (model != null) {
                page.setGroup(this);
                model.fireModelUpdated();
            }
        }
    }

    public boolean removePage(Class pageClass) {
        PWizardPage page = null;
        PWizardModeling model = null;
        Iterator iterator = this.myPages.iterator();
        while (iterator.hasNext()) {
            page = (PWizardPage)iterator.next();
            if (!page.getClass().equals(pageClass)) continue;
            page.setGroup(null);
            iterator.remove();
            model = this.getModel();
            if (model != null) {
                model.fireModelUpdated();
            }
            return true;
        }
        return false;
    }

    public boolean removePage(String pageId) {
        PWizardPage page = null;
        PWizardModeling model = null;
        Iterator iterator = this.myPages.iterator();
        while (iterator.hasNext()) {
            page = (PWizardPage)iterator.next();
            if (!page.getId().equals(pageId)) continue;
            page.setGroup(null);
            iterator.remove();
            model = this.getModel();
            if (model != null) {
                model.fireModelUpdated();
            }
            return true;
        }
        return false;
    }

    public List getPages() {
        return this.myPages;
    }

    public PWizardPage getFirstPage() {
        if (this.myPages.size() > 0) {
            return (PWizardPage)this.myPages.get(0);
        }
        return null;
    }

    public PWizardPage getPage(Class clazz) {
        PWizardPage page2 = null;
        for (PWizardPage page2 : this.myPages) {
            if (!page2.getClass().equals(clazz)) continue;
            return page2;
        }
        return null;
    }

    public PWizardPage getPage(String pageId) {
        PWizardPage page2 = null;
        for (PWizardPage page2 : this.myPages) {
            if (!page2.getId().equals(pageId)) continue;
            return page2;
        }
        return null;
    }

    public String getName() {
        return this.myName;
    }

    public int getSize() {
        return this.myPages.size();
    }

    public void setEnabled(boolean enabled) {
        PWizardPage page2 = null;
        for (PWizardPage page2 : this.myPages) {
            page2.setEnabled(enabled);
        }
    }

    public PWizardPage getNextPage(PWizardPage page) {
        int index = this.myPages.indexOf(page);
        if (index >= this.myPages.size() - 1) {
            return null;
        }
        return (PWizardPage)this.myPages.get(index + 1);
    }

    public PWizardPage getPreviousPage(PWizardPage page) {
        int index = this.myPages.indexOf(page);
        if (index == 0) {
            return null;
        }
        return (PWizardPage)this.myPages.get(index - 1);
    }

    public void insertPage(PWizardPage page, PWizardPage pointToInsert) {
        int index = this.myPages.indexOf(pointToInsert);
        this.myPages.add(index, page);
        page.setGroup(this);
    }

    public boolean insertPage(PWizardPage page, String pageId) {
        int index = this.myPages.indexOf(this.getPage(pageId));
        if (index < 0) {
            return false;
        }
        this.myPages.add(index, page);
        page.setGroup(this);
        if (this.getModel() != null) {
            this.getModel().fireModelUpdated();
        }
        return true;
    }

    public void resetToDefaults() {
        PWizardPage page2 = null;
        for (PWizardPage page2 : this.myPages) {
            page2.resetToDefaults();
        }
    }

    public void setInitialized(boolean initialized) {
        PWizardPage page2 = null;
        for (PWizardPage page2 : this.myPages) {
            page2.setInitialized(initialized);
        }
    }

    void setModel(PWizardModeling model) {
        this.myModel = model;
        PWizardPage page2 = null;
        for (PWizardPage page2 : this.myPages) {
            page2.setGroup(this);
        }
    }
}

