/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.frameworks.wizard;

import com.nokia.em.poseidon.frameworks.wizard.PWizardEvent;
import com.nokia.em.poseidon.frameworks.wizard.PWizardGroup;
import com.nokia.em.poseidon.frameworks.wizard.PWizardListener;
import com.nokia.em.poseidon.frameworks.wizard.PWizardModeling;
import com.nokia.em.poseidon.frameworks.wizard.PWizardPage;
import com.nokia.em.poseidon.frameworks.wizard.WizardModelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.event.SwingPropertyChangeSupport;

public class PWizardModel
implements PWizardModeling {
    private List myGroups = new LinkedList();
    private SwingPropertyChangeSupport mySupport;
    private List myModelListeners;
    private HashSet myWizardListeners = new HashSet();
    private PWizardPage myCurrentPage;
    private String myStatus;
    private String myStepListTitle;
    private List<String> myBTSSCFNames;
    private boolean diableSCFNameButton;

    public PWizardModel() {
        this.mySupport = new SwingPropertyChangeSupport(this);
        this.myModelListeners = new ArrayList();
    }

    @Override
    public List getGroups() {
        return this.myGroups;
    }

    public void addGroup(PWizardGroup group) {
        this.addGroup(group, -1);
    }

    public void addGroup(PWizardGroup group, int index) {
        if (group != null) {
            if (index > -1) {
                this.myGroups.add(index, group);
            } else {
                this.myGroups.add(group);
            }
            group.setModel(this);
            this.fireModelUpdated();
        }
    }

    public void removeAll() {
        for (PWizardGroup group : this.myGroups) {
            group.setModel(null);
        }
        this.myGroups.clear();
    }

    public void removeGroup(String groupName) {
        PWizardGroup group = this.getGroup(groupName);
        if (group != null) {
            this.myGroups.remove(group);
            group.setModel(null);
            this.fireModelUpdated();
        }
    }

    public void insertGroup(String pointToInsert, PWizardGroup group) {
        PWizardGroup insertBefore = this.getGroup(pointToInsert);
        if (insertBefore != null) {
            group.setModel(this);
            this.myGroups.add(this.myGroups.indexOf(insertBefore), group);
        }
    }

    @Override
    public PWizardPage getFirstPage() {
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            PWizardPage page = group2.getFirstPage();
            if (page == null) continue;
            return page;
        }
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.mySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.mySupport.removePropertyChangeListener(listener);
    }

    public PWizardPage getPage(Class clazz) {
        List pages = this.getPages();
        for (PWizardPage page : pages) {
            if (!page.getClass().equals(clazz)) continue;
            return page;
        }
        return null;
    }

    public PWizardPage getPage(String pageId) {
        List pages = this.getPages();
        for (PWizardPage page : pages) {
            if (!page.getId().equals(pageId)) continue;
            return page;
        }
        return null;
    }

    public PWizardPage getNextPage(PWizardPage page) {
        List pages = this.getPages();
        int index = pages.indexOf(page);
        if (index >= pages.size() - 1) {
            return null;
        }
        return (PWizardPage)pages.get(index + 1);
    }

    @Override
    public PWizardPage getNextEnabledPage(PWizardPage page) {
        List pages = this.getPages();
        int index = pages.indexOf(page);
        if (index >= pages.size() - 1) {
            return null;
        }
        int ind = index + 1;
        while (ind < pages.size()) {
            PWizardPage nextPage = (PWizardPage)pages.get(ind);
            if (nextPage.isEnabled()) {
                return nextPage;
            }
            ++ind;
        }
        return null;
    }

    @Override
    public PWizardPage getPreviousEnabledPage(PWizardPage page) {
        List pages = this.getPages();
        int index = pages.indexOf(page);
        if (index == 0) {
            return null;
        }
        int ind = index - 1;
        while (ind >= 0) {
            PWizardPage nextPage = (PWizardPage)pages.get(ind);
            if (nextPage.isEnabled()) {
                return nextPage;
            }
            --ind;
        }
        return null;
    }

    public PWizardPage getPreviousPage(PWizardPage page) {
        List pages = this.getPages();
        int index = pages.indexOf(page);
        if (index == 0) {
            return null;
        }
        return (PWizardPage)pages.get(index - 1);
    }

    public List getPages() {
        ArrayList result = new ArrayList();
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            result.addAll(group2.getPages());
        }
        return result;
    }

    public List getPages(Class clazz) {
        ArrayList<PWizardPage> result = new ArrayList<PWizardPage>();
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            List groupPages = group2.getPages();
            for (PWizardPage page : groupPages) {
                if (!clazz.isAssignableFrom(page.getClass())) continue;
                result.add(page);
            }
        }
        return result;
    }

    public boolean removePage(String pageId) {
        for (PWizardGroup group : this.myGroups) {
            if (!group.removePage(pageId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getPageCount() {
        int result = 0;
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            result += group2.getPages().size();
        }
        return result;
    }

    @Override
    public int indexOf(PWizardPage page) {
        return this.getPages().indexOf(page) + 1;
    }

    public PWizardGroup getGroup(String groupName) {
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            if (!group2.getName().equals(groupName)) continue;
            return group2;
        }
        return null;
    }

    @Override
    public void resetToDefaults() {
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            group2.resetToDefaults();
        }
    }

    @Override
    public void addWizardModelListener(WizardModelListener listener) {
        if (listener != null) {
            this.myModelListeners.add(listener);
        }
    }

    @Override
    public void removeWizardModelListener(WizardModelListener listener) {
        this.myModelListeners.remove(listener);
    }

    @Override
    public PWizardPage getCurrentPage() {
        return this.myCurrentPage;
    }

    @Override
    public void setCurrentPage(PWizardPage page) {
        if (page == null || !page.isEnabled()) {
            return;
        }
        PWizardPage oldPage = this.myCurrentPage;
        this.myCurrentPage = page;
        this.firePropertyChange(new PropertyChangeEvent(this, "currentPage", oldPage, this.myCurrentPage));
    }

    @Override
    public void refreshCurrentPage() {
        this.firePropertyChange(new PropertyChangeEvent(this, "refreshPage", false, true));
    }

    public boolean addPageToGroup(PWizardPage page, String groupName) {
        PWizardGroup group = this.getGroup(groupName);
        if (group != null) {
            group.addPage(page);
            return true;
        }
        return false;
    }

    public boolean addPage(PWizardPage page, String pageId) {
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            if (!group2.insertPage(page, pageId)) continue;
            return true;
        }
        return false;
    }

    public void setInitialized(boolean initialized) {
        PWizardGroup group2 = null;
        for (PWizardGroup group2 : this.myGroups) {
            group2.setInitialized(initialized);
        }
    }

    public void firePropertyChange(PropertyChangeEvent event) {
        this.mySupport.firePropertyChange(event);
    }

    @Override
    public void firePropertyChange(Object src, String propertyName, Object newValue) {
        boolean newValueBoolean;
        PropertyChangeEvent event = null;
        event = newValue instanceof Boolean ? new PropertyChangeEvent(src, propertyName, !(newValueBoolean = Boolean.TRUE.equals(newValue)), newValueBoolean) : new PropertyChangeEvent(src, propertyName, "", newValue);
        this.mySupport.firePropertyChange(event);
    }

    @Override
    public void fireModelUpdated() {
        this.fireModelUpdated(this);
    }

    public void fireModelUpdated(PWizardModeling src) {
        for (WizardModelListener listener : this.myModelListeners) {
            listener.modelUpdated(src);
        }
    }

    @Override
    public void fireNextNotify() {
        PWizardEvent event = new PWizardEvent(this.getCurrentPage());
        PWizardListener listener2 = null;
        for (PWizardListener listener2 : this.myWizardListeners) {
            listener2.nextNotify(event);
        }
    }

    @Override
    public void fireActivateNotify() {
        PWizardEvent event = new PWizardEvent(this.getCurrentPage());
        PWizardListener listener2 = null;
        for (PWizardListener listener2 : this.myWizardListeners) {
            listener2.activateNotify(event);
        }
    }

    @Override
    public void firePreviousNotify() {
        PWizardEvent event = new PWizardEvent(this.getCurrentPage());
        PWizardListener listener2 = null;
        for (PWizardListener listener2 : this.myWizardListeners) {
            listener2.previousNotify(event);
        }
    }

    @Override
    public void fireCancelNotify() {
        PWizardListener listener2 = null;
        Set set = (Set)this.myWizardListeners.clone();
        for (PWizardListener listener2 : set) {
            listener2.cancelNotify();
        }
    }

    @Override
    public void fireFinishNotify() {
        PWizardListener listener2 = null;
        Set set = (Set)this.myWizardListeners.clone();
        for (PWizardListener listener2 : set) {
            listener2.finishNotify();
        }
    }

    @Override
    public void addWizardListener(PWizardListener listener) {
        if (listener != null) {
            this.myWizardListeners.add(listener);
        }
    }

    @Override
    public void removeWizardListener(PWizardListener listener) {
        this.myWizardListeners.remove(listener);
    }

    @Override
    public void destroyModel() {
        this.myGroups.clear();
        this.myModelListeners.clear();
        this.myWizardListeners.clear();
    }

    @Override
    public void setStatus(String status) {
        this.myStatus = status;
        this.fireModelUpdated();
    }

    @Override
    public String getStatus() {
        return this.myStatus;
    }

    @Override
    public void setStepListTitle(String title) {
        this.myStepListTitle = title;
    }

    @Override
    public String getStepListTitle() {
        return this.myStepListTitle;
    }

    public List<String> getBTSSCFNames() {
        return this.myBTSSCFNames;
    }

    public void setBTSSCFNames(List<String> myBTSSCFNames) {
        this.myBTSSCFNames = myBTSSCFNames;
    }

    public boolean isSCFNameDisabled() {
        return this.diableSCFNameButton;
    }

    public void diableSCFName(boolean diableSCFName) {
        this.diableSCFNameButton = diableSCFName;
    }
}

