/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.certificate;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.util.file.IOUtils;
import com.nokia.em.poseidon.util.security.Base64;
import com.nokia.widgets.text.TimestampFormatter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.Rdn;
import org.apache.log4j.Logger;

public final class CertificateUtils {
    public static final String COMMON_NAME = "CN";
    public static final String ORGANIZATIONAL_UNIT_NAME = "OU";
    public static final String EQUAL = "=";
    public static final String FINGERPRINT_ALGORITHM = "SHA1";
    public static final String PRIVATE_KEY_ALGORITHM = "RSA";
    public static final String PROVIDER_FOR_RSA = "SunRsaSign";
    public static final String PKCS12_CERTIFICATE_TYPE = "pkcs12";
    public static final String PEM_FILE_STARTING_TAG = "-----";
    public static final String PEM_KEY_BEGIN_TAG = "-----BEGIN PRIVATE KEY-----";
    public static final String PEM_RSA_KEY_BEGIN_TAG = "-----BEGIN RSA PRIVATE KEY-----";
    public static final String PEM_KEY_ENDING_TAG = "-----END PRIVATE KEY-----";
    public static final String PEM_RSA_KEY_ENDING_TAG = "-----END RSA PRIVATE KEY-----";
    public static final String DATA_FOR_SIGNATURE = "Data for signature";
    public static final String CERTIFICATE_TYPE = "X509";
    private static final Map<String, String> OIDMAP = new HashMap<String, String>();
    private static final String EMAILADDR = "emailAddress";
    public static final String ALL_NAMES = "CN,OU,O,L,ST,C,STREET,DC,UID,emailAddress";
    private static Logger myLogger;
    private static ResourceBundle myResourceBundle;

    static {
        OIDMAP.put("1.2.840.113549.1.9.1", EMAILADDR);
        myLogger = Logger.getLogger(CertificateUtils.class);
        myResourceBundle = I18n.getI18n().getBundle(CertificateUtils.class);
    }

    private CertificateUtils() {
    }

    public static List<X509Certificate> parseCertificates(File file) {
        ArrayList<X509Certificate> certificates;
        block9: {
            ByteArrayInputStream inStream;
            FileInputStream ksfis;
            block8: {
                ksfis = null;
                inStream = null;
                certificates = new ArrayList<X509Certificate>();
                try {
                    try {
                        ksfis = new FileInputStream(file);
                        for (Certificate certificate : CertificateFactory.getInstance(CERTIFICATE_TYPE).generateCertificates(ksfis)) {
                            if (!(certificate instanceof X509Certificate)) continue;
                            certificates.add((X509Certificate)certificate);
                        }
                        break block8;
                    }
                    catch (Exception exception) {
                        myLogger.trace("parse cert normal procedual failed with exception: " + exception);
                        try {
                            inStream = CertificateUtils.trimSpace(file);
                            for (Certificate certificate : CertificateFactory.getInstance(CERTIFICATE_TYPE).generateCertificates(inStream)) {
                                if (!(certificate instanceof X509Certificate)) continue;
                                certificates.add((X509Certificate)certificate);
                            }
                        }
                        catch (Exception exception2) {
                            myLogger.trace("parse cert after trime space failed with exception: " + exception2);
                        }
                    }
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(ksfis);
                    IOUtils.closeQuietly(inStream);
                    throw throwable;
                }
                IOUtils.closeQuietly(ksfis);
                IOUtils.closeQuietly(inStream);
                break block9;
            }
            IOUtils.closeQuietly(ksfis);
            IOUtils.closeQuietly(inStream);
        }
        return certificates;
    }

    public static X509Certificate parseCertificate(File file) {
        Certificate certificate;
        block13: {
            FileInputStream ksfis = null;
            certificate = null;
            try {
                try {
                    ksfis = new FileInputStream(file);
                    certificate = CertificateFactory.getInstance(CERTIFICATE_TYPE).generateCertificate(ksfis);
                }
                catch (Exception ex) {
                    try {
                        ByteArrayInputStream inStream = CertificateUtils.trimSpace(file);
                        certificate = CertificateFactory.getInstance(CERTIFICATE_TYPE).generateCertificate(inStream);
                        inStream.close();
                    }
                    catch (Exception e) {
                        myLogger.trace("parse cert failed with exception: " + e);
                    }
                    try {
                        ksfis.close();
                    }
                    catch (Exception e) {
                        myLogger.trace("Certificate file inputstream closing failed. " + e);
                    }
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    ksfis.close();
                }
                catch (Exception e) {
                    myLogger.trace("Certificate file inputstream closing failed. " + e);
                }
                throw throwable;
            }
            try {
                ksfis.close();
            }
            catch (Exception e) {
                myLogger.trace("Certificate file inputstream closing failed. " + e);
            }
        }
        return (X509Certificate)certificate;
    }

    private static ByteArrayInputStream trimSpace(File file) {
        ByteArrayOutputStream bytestream = null;
        FileInputStream ksfis = null;
        try {
            int ch;
            ksfis = new FileInputStream(file);
            bytestream = new ByteArrayOutputStream();
            while ((ch = ksfis.read()) != -1) {
                bytestream.write(ch);
            }
            byte[] contents = bytestream.toByteArray();
            int st = 0;
            int len = contents.length;
            while (st < len && Character.isSpaceChar(contents[st])) {
                ++st;
            }
            while (st < len && Character.isSpaceChar(contents[st])) {
                --len;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(Arrays.copyOfRange(contents, st, len));
            return byteArrayInputStream;
        }
        catch (Exception ex) {
            myLogger.trace("trim failed with exception: " + ex);
        }
        finally {
            try {
                ksfis.close();
                bytestream.close();
            }
            catch (Exception e) {
                myLogger.trace("Certificate file inputstream closing failed. " + e);
            }
        }
        return null;
    }

    public static List<X509Certificate> parseCertificates(File file, String pass) {
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        String password = "";
        if (pass != null) {
            password = pass;
        }
        if (file == null) {
            return certificates;
        }
        if (file.getName().endsWith("pem") || file.getName().endsWith("cer")) {
            X509Certificate cert = CertificateUtils.parseCertificate(file);
            if (cert != null) {
                certificates.add(cert);
            }
        } else {
            FileInputStream fis = null;
            try {
                try {
                    KeyStore ks = KeyStore.getInstance(PKCS12_CERTIFICATE_TYPE);
                    fis = new FileInputStream(file);
                    ks.load(fis, password.toCharArray());
                    Enumeration<String> enume = ks.aliases();
                    while (enume.hasMoreElements()) {
                        String alias = enume.nextElement();
                        Certificate[] chain = ks.getCertificateChain(alias);
                        int i = 0;
                        while (i < chain.length) {
                            if (chain[i] instanceof X509Certificate) {
                                certificates.add((X509Certificate)chain[i]);
                            }
                            ++i;
                        }
                    }
                }
                catch (Exception e) {
                    myLogger.trace("Certificate file parsing failed. File was not certificate or no file selected." + e);
                    try {
                        fis.close();
                    }
                    catch (Exception e2) {
                        myLogger.trace("Certificate file stream closing failed. " + e2);
                    }
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (Exception e) {
                    myLogger.trace("Certificate file stream closing failed. " + e);
                }
            }
        }
        return certificates;
    }

    public static List<Key> parsePrivateKey(File file, String password) {
        ArrayList<Key> keys = new ArrayList<Key>();
        if (file == null) {
            return keys;
        }
        FileInputStream fis = null;
        try {
            try {
                KeyStore ks = KeyStore.getInstance(PKCS12_CERTIFICATE_TYPE);
                fis = new FileInputStream(file);
                ks.load(fis, password.toCharArray());
                Enumeration<String> enume = ks.aliases();
                while (enume.hasMoreElements()) {
                    String cert = enume.nextElement();
                    keys.add(ks.getKey(cert, password.toCharArray()));
                }
            }
            catch (Exception e) {
                myLogger.trace("Certificate file private key parsing failed. File was not PKCS#12 file or password was wrong." + e);
                try {
                    fis.close();
                }
                catch (Exception e2) {
                    myLogger.trace("Certificate private key file stream closing failed. " + e2);
                }
            }
        }
        finally {
            try {
                fis.close();
            }
            catch (Exception e) {
                myLogger.trace("Certificate private key file stream closing failed. " + e);
            }
        }
        return keys;
    }

    @Deprecated
    public static String parseCommonName(String distinguishName) {
        if (distinguishName == null) {
            return null;
        }
        String CN = CertificateUtils.getCertNameValue(distinguishName, COMMON_NAME);
        if (CN != null) {
            return CN;
        }
        return distinguishName;
    }

    private static String getCommonName(String escapedDN) {
        if (escapedDN == null) {
            return "";
        }
        String CN = CertificateUtils.getCertNameValue(escapedDN, COMMON_NAME);
        if (CN != null) {
            return CN;
        }
        return Rdn.unescapeValue(escapedDN).toString();
    }

    public static String getCertNameValue(String escapedDN, String key) {
        if (escapedDN == null || key == null) {
            return null;
        }
        String[] stringArray = CertificateUtils.splitName(escapedDN);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] split;
            String value = stringArray[n2];
            String prefix = String.valueOf(key) + EQUAL;
            if (value != null && value.startsWith(prefix) && (split = value.split(prefix)).length > 1) {
                return Rdn.unescapeValue(split[1]).toString();
            }
            ++n2;
        }
        return null;
    }

    public static String[] splitName(String escapedDN) {
        if (escapedDN == null || escapedDN.isEmpty()) {
            return new String[]{""};
        }
        String[] values = escapedDN.split(",");
        int i = 0;
        while (i < values.length - 1) {
            if (values[i] != null && values[i].endsWith("\\")) {
                values[i] = String.valueOf(values[i]) + "," + values[i + 1];
                values[i + 1] = null;
            }
            ++i;
        }
        return values;
    }

    public static String getSubjectDN(X509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        String subjectName = certificate.getSubjectX500Principal().getName("RFC2253", OIDMAP);
        return Rdn.unescapeValue(subjectName).toString();
    }

    public static String getIssuerDN(X509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        String issuerName = certificate.getIssuerX500Principal().getName("RFC2253", OIDMAP);
        return Rdn.unescapeValue(issuerName).toString();
    }

    public static String getSubjectDNOrig(X509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        String subjectName = certificate.getSubjectX500Principal().getName("RFC2253", OIDMAP);
        return subjectName;
    }

    public static String getIssuerDNOrig(X509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        String issuerName = certificate.getIssuerX500Principal().getName("RFC2253", OIDMAP);
        return issuerName;
    }

    public static String getSubjectCN(X509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        String subjectName = certificate.getSubjectX500Principal().getName("RFC2253", OIDMAP);
        return CertificateUtils.getCommonName(subjectName);
    }

    public static String getIssuerCN(X509Certificate certificate) {
        if (certificate == null) {
            return "";
        }
        String issuerName = certificate.getIssuerX500Principal().getName("RFC2253", OIDMAP);
        return CertificateUtils.getCommonName(issuerName);
    }

    public static String parseSerialNumber(X509Certificate certificate) {
        byte[] b = certificate.getSerialNumber().toByteArray();
        StringBuilder hexSerialNumber = new StringBuilder();
        int i = 0;
        while (i < b.length) {
            hexSerialNumber.append(String.valueOf(Integer.toHexString(b[i] & 0xFF | 0x100).substring(1, 3)) + " ");
            ++i;
        }
        return hexSerialNumber.toString();
    }

    public static byte[] getFileContent(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream ksfis = null;
        FilterInputStream dis = null;
        try {
            ksfis = new FileInputStream(file);
            dis = new DataInputStream(ksfis);
            byte[] plainBytes = new byte[dis.available()];
            ((DataInputStream)dis).readFully(plainBytes);
            byte[] byArray = plainBytes;
            return byArray;
        }
        catch (IOException e) {
            myLogger.trace("Private key file parsing failed." + e);
            return null;
        }
        finally {
            try {
                ksfis.close();
                dis.close();
            }
            catch (Exception e) {
                myLogger.trace("Private key file stream closing failed." + e);
            }
        }
    }

    public static String parseFingerprint(X509Certificate certificate) {
        try {
            MessageDigest.getInstance(FINGERPRINT_ALGORITHM);
            byte[] data = certificate.getEncoded();
            return CertificateUtils.parseByteArray(data, FINGERPRINT_ALGORITHM);
        }
        catch (Exception e) {
            myLogger.trace("Certificate fingerprint parsing failed. " + e);
            return "-";
        }
    }

    public static String parseByteArray(byte[] data, String algorithm) {
        try {
            MessageDigest x = MessageDigest.getInstance(algorithm);
            byte[] digest = x.digest(data);
            StringBuilder stringBuilder = new StringBuilder();
            int i = 0;
            while (i < digest.length) {
                int b;
                String hex;
                if (i != 0) {
                    stringBuilder.append(" ");
                }
                if ((hex = Integer.toHexString(b = digest[i] & 0xFF)).length() == 1) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(hex);
                ++i;
            }
            return stringBuilder.toString();
        }
        catch (Exception e) {
            myLogger.trace("Certificate parseByteArray parsing failed. " + e);
            return "-";
        }
    }

    public static PrivateKey parsePrivateKey(File file) {
        if (file == null) {
            return null;
        }
        FileInputStream ksfis = null;
        FilterInputStream dis = null;
        try {
            ksfis = new FileInputStream(file);
            dis = new DataInputStream(ksfis);
            byte[] plainBytes = new byte[dis.available()];
            ((DataInputStream)dis).readFully(plainBytes);
            String keyString = new String(plainBytes);
            byte[] decodedBytes = null;
            if (keyString.contains(PEM_FILE_STARTING_TAG)) {
                int first = keyString.indexOf(10) + 1;
                int last = keyString.lastIndexOf(PEM_FILE_STARTING_TAG) - 1;
                int last2 = keyString.lastIndexOf(PEM_FILE_STARTING_TAG, last) - 1;
                String subString = keyString.substring(first, last2);
                decodedBytes = Base64.decodeToBytes(subString);
            } else {
                decodedBytes = plainBytes;
            }
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedBytes);
            KeyFactory pk = KeyFactory.getInstance(PRIVATE_KEY_ALGORITHM, PROVIDER_FOR_RSA);
            PrivateKey key = null;
            try {
                key = pk.generatePrivate(keySpec);
            }
            catch (Exception e) {
                RSAPrivateCrtKeySpec ks = CertificateUtils.decodePkcs1PrivateKey(decodedBytes);
                if (ks != null) {
                    key = pk.generatePrivate(ks);
                }
                throw new Exception("Parsing PKCS#1 private key failed.");
            }
            PrivateKey privateKey = key;
            return privateKey;
        }
        catch (Exception e) {
            myLogger.trace("Private key file parsing failed." + e);
            return null;
        }
        finally {
            try {
                ksfis.close();
                dis.close();
            }
            catch (Exception e) {
                myLogger.trace("Private key file stream closing failed. " + e);
            }
        }
    }

    public static Object[] parseCertificateContent(X509Certificate certificate) {
        DateFormat dateFormat = TimestampFormatter.getShortFormatter();
        Object[] certData = new Object[7];
        certData[0] = String.valueOf(myResourceBundle.getString("CertificateManagement.IssuedTo_Text")) + "  " + CertificateUtils.getSubjectCN(certificate);
        certData[1] = String.valueOf(myResourceBundle.getString("CertificateManagement.IssuedBy_Text")) + "  " + CertificateUtils.getIssuerCN(certificate);
        Date startTime = certificate.getNotBefore();
        certData[2] = String.valueOf(myResourceBundle.getString("CertificateManagement.ValidFrom_Text")) + "  " + dateFormat.format(startTime.getTime());
        Date endTime = certificate.getNotAfter();
        certData[3] = String.valueOf(myResourceBundle.getString("CertificateManagement.ValidTo_Text")) + "  " + dateFormat.format(endTime.getTime());
        certData[4] = String.valueOf(myResourceBundle.getString("CertificateManagement.SerialNumber_Text")) + "  " + CertificateUtils.parseSerialNumber(certificate);
        certData[5] = String.valueOf(myResourceBundle.getString("CertificateManagement.Fingerprint_Text")) + "  " + CertificateUtils.parseFingerprint(certificate);
        return certData;
    }

    public static boolean isCACertificate(Object certificate) {
        if (CertificateUtils.isX509V3Certificate(certificate)) {
            return ((X509Certificate)certificate).getBasicConstraints() != -1;
        }
        return false;
    }

    public static boolean checkKeyUsage(X509Certificate certificate, int usage) {
        boolean[] keyUsage;
        if (certificate != null && (keyUsage = certificate.getKeyUsage()) != null && keyUsage.length > usage) {
            return keyUsage[usage];
        }
        return false;
    }

    public static boolean checkIssuer(X509Certificate cert, X509Certificate issuer) {
        try {
            cert.verify(issuer.getPublicKey());
        }
        catch (InvalidKeyException e) {
            return false;
        }
        catch (CertificateException e) {
            return false;
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (NoSuchProviderException e) {
            return false;
        }
        catch (SignatureException e) {
            return false;
        }
        return true;
    }

    public static boolean isCertificate(Object certificate) {
        return certificate != null && certificate instanceof X509Certificate;
    }

    public static boolean isX509V3Certificate(Object certificate) {
        return certificate instanceof X509Certificate && ((X509Certificate)certificate).getVersion() == 3;
    }

    public static boolean isX509V3Certificates(List<X509Certificate> certificates) {
        if (certificates == null || certificates.isEmpty()) {
            return false;
        }
        for (X509Certificate cert : certificates) {
            if (CertificateUtils.isX509V3Certificate(cert)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameCertificate(X509Certificate cert1, X509Certificate cert2) {
        BigInteger sn2;
        String subject1 = CertificateUtils.getIssuerDN(cert1);
        String subject2 = CertificateUtils.getIssuerDN(cert2);
        BigInteger sn1 = cert1.getSerialNumber();
        return sn1.equals(sn2 = cert2.getSerialNumber()) && subject1.equals(subject2);
    }

    public static byte[] encodeKeyToPemFormat(byte[] key) {
        if (key == null) {
            return null;
        }
        String keyString = new String(key);
        if (keyString.startsWith(PEM_KEY_BEGIN_TAG) || keyString.startsWith(PEM_RSA_KEY_BEGIN_TAG)) {
            return key;
        }
        StringBuffer buffer = new StringBuffer();
        byte[] b64 = new byte[]{};
        try {
            b64 = Base64.encodeToBytes(key, true);
        }
        catch (Exception ex) {
            myLogger.debug("Error when encoding private key to pem format.");
        }
        buffer.append(PEM_RSA_KEY_BEGIN_TAG);
        buffer.append('\n');
        buffer.append(new String(b64));
        if (b64[b64.length - 1] != 10) {
            buffer.append('\n');
        }
        buffer.append(PEM_RSA_KEY_ENDING_TAG);
        return buffer.toString().getBytes();
    }

    public static byte[] encodeKeyToPemFormat(Key key) {
        StringBuffer buffer = new StringBuffer();
        byte[] b64 = new byte[]{};
        try {
            b64 = Base64.encodeToBytes(key.getEncoded(), true);
        }
        catch (Exception ex) {
            myLogger.debug("Error when encoding private key to pem format.");
        }
        buffer.append(PEM_KEY_BEGIN_TAG);
        buffer.append('\n');
        buffer.append(new String(b64));
        if (b64[b64.length - 1] != 10) {
            buffer.append('\n');
        }
        buffer.append(PEM_KEY_ENDING_TAG);
        return buffer.toString().getBytes();
    }

    public static RSAPrivateCrtKeySpec decodePkcs1PrivateKey(byte[] privateKeyData) {
        if (privateKeyData == null) {
            return null;
        }
        try {
            ByteBuffer bb = ByteBuffer.wrap(privateKeyData);
            if (bb.get() != 48) {
            }
            CertificateUtils.parseAsn1Length(bb);
            BigInteger[] values = new BigInteger[9];
            int i = 0;
            while (i < 9) {
                values[i] = CertificateUtils.parseAsn1Integer(bb);
                ++i;
            }
            return new RSAPrivateCrtKeySpec(values[1], values[2], values[3], values[4], values[5], values[6], values[7], values[8]);
        }
        finally {
            return null;
        }
    }

    public static boolean validateKeys(X509Certificate certificate, PrivateKey privateKey) {
        block3: {
            try {
                if (privateKey != null && certificate != null) break block3;
                return false;
            }
            catch (Exception ex) {
                myLogger.error(ex);
                return false;
            }
        }
        Signature dsa = Signature.getInstance(certificate.getSigAlgName());
        dsa.initSign(privateKey);
        dsa.update(DATA_FOR_SIGNATURE.getBytes());
        byte[] sig = dsa.sign();
        dsa.initVerify(certificate.getPublicKey());
        dsa.update(DATA_FOR_SIGNATURE.getBytes());
        return dsa.verify(sig);
    }

    public static boolean validateKeys(File certificateFile, File privateKeyFile) {
        if (certificateFile == null || privateKeyFile == null) {
            return false;
        }
        try {
            X509Certificate certificate = CertificateUtils.parseCertificate(certificateFile);
            PrivateKey privateKey = CertificateUtils.parsePrivateKey(privateKeyFile);
            return CertificateUtils.validateKeys(certificate, privateKey);
        }
        catch (Exception ex) {
            myLogger.error(ex);
            return false;
        }
    }

    private static int parseAsn1Length(ByteBuffer bb) throws Exception {
        int dataLength = 0;
        try {
            int lengthBytes = bb.get();
            if ((lengthBytes & 0x80) == 128) {
                int length = lengthBytes & 0x7F;
                int i = 0;
                while (i < length) {
                    dataLength = dataLength << 8 | bb.get() & 0xFF;
                    ++i;
                }
            } else {
                dataLength = lengthBytes;
            }
        }
        catch (Throwable e) {
            throw new Exception("Parsing ASN.1 parameter length failed.");
        }
        return dataLength;
    }

    private static BigInteger parseAsn1Integer(ByteBuffer bb) throws Exception {
        if (bb.get() != 2) {
            throw new Exception("Not ASN.1 integer type.");
        }
        int dataLength = CertificateUtils.parseAsn1Length(bb);
        byte[] data = new byte[dataLength];
        bb.get(data);
        return new BigInteger(data);
    }

    public static enum EXTENSION {
        SubjectDirectoryAttributes("2.5.29.9"),
        SubjectKeyIdentifier("2.5.29.14"),
        KeyUsage("2.5.29.15"),
        PrivateKeyUsagePeriod("2.5.29.16"),
        SubjectAltName("2.5.29.17"),
        IssuerAltName("2.5.29.18"),
        BasicConstraints("2.5.29.19"),
        NameConstraints("2.5.29.30"),
        CRLDistributionPoints("2.5.29.31"),
        CertificatePolicies("2.5.29.32"),
        PolicyMappings("2.5.29.33"),
        AuthorityKeyIdentifier("2.5.29.35"),
        PolicyConstraints("2.5.29.36"),
        ExtendedKeyUsage("2.5.29.37"),
        FreshestCRL("2.5.29.46"),
        InhibitAnyPolicy("2.5.29.54"),
        AuthorityInformationAccess("1.3.6.1.5.5.7.1.1"),
        SubjectInformationAccess("1.3.6.1.5.5.7.1.11"),
        UNKNOWN("-");

        private String myOID;

        private EXTENSION(String oid) {
            this.myOID = oid;
        }

        public String getOID() {
            return this.myOID;
        }

        public static EXTENSION value(String oid) {
            EXTENSION[] eXTENSIONArray = EXTENSION.values();
            int n = eXTENSIONArray.length;
            int n2 = 0;
            while (n2 < n) {
                EXTENSION extension = eXTENSIONArray[n2];
                if (extension.getOID().equals(oid)) {
                    return extension;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }
}

