/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.plugin.application.AppDescription;
import com.nokia.em.poseidon.plugin.application.ApplicationRegistry;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.PCmdLineParams;
import com.nokia.widgets.about.AboutBoxController;
import com.nokia.widgets.about.AboutBoxModel;
import com.nokia.widgets.about.AboutBoxView;
import com.nokia.widgets.about.AboutSplashScreenView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.JFrame;

public final class AboutBoxFactory {
    private static AboutBoxFactory theInstance;

    public static synchronized AboutBoxFactory getInstance() {
        if (theInstance == null) {
            theInstance = new AboutBoxFactory();
        }
        return theInstance;
    }

    private AboutBoxFactory() {
    }

    public AboutBoxController createAboutBox() {
        return this.createAbout(this.initModel());
    }

    public AboutBoxController createAboutBox(AboutBoxModel model) {
        return this.createAbout(model);
    }

    public AboutBoxController createAboutSplashScreen() {
        JFrame mainFrame = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        AboutBoxController controller = new AboutBoxController(mainFrame);
        controller.setModel(this.initModel());
        AboutSplashScreenView view = new AboutSplashScreenView(controller);
        controller.setView(view);
        return controller;
    }

    public AboutBoxController createAboutSplashScreen(AboutBoxModel model) {
        JFrame mainFrame = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        AboutBoxController controller = new AboutBoxController(mainFrame);
        controller.setModel(model);
        AboutSplashScreenView view = new AboutSplashScreenView(controller);
        controller.setView(view);
        return controller;
    }

    public AboutBoxModel initModel() {
        String devMode;
        PoseidonRuntime runtime = PoseidonRuntime.getRuntime();
        AboutBoxModel model = new AboutBoxModel();
        model.setProperty("AboutBox_ApplicationIcon", runtime.getRuntimeProperty("aboutIcon"));
        model.setProperty("AboutBox_ApplicationName", runtime.getRuntimeProperty("shortPublicName"));
        model.setProperty("AboutBox_Version", runtime.getRuntimeProperty("version"));
        model.setProperty("AboutBox_BuildNumber", runtime.getRuntimeProperty("build"));
        model.setProperty("AboutBox_CopyrightText", runtime.getRuntimeProperty("copyrightRights"));
        model.setProperty("AboutBox_CopyrightYear", runtime.getRuntimeProperty("copyrightYear"));
        model.setProperty("AboutBox_CopyrightCompany", runtime.getRuntimeProperty("copyrightCompany"));
        model.setProperty("AboutBox_ProductCode", runtime.getRuntimeProperty("productCode"));
        model.setProperty("AboutBox_ProductFamily", " ");
        model.setProperty("AboutBox_Show_System_Info", true);
        PCmdLineParams cmdLineParameters = PoseidonRuntime.getRuntime().getParameters();
        if (cmdLineParameters != null && (devMode = cmdLineParameters.getFirstValue("devmode")) != null && "on".equals(devMode)) {
            ArrayList plugins = new ArrayList();
            ArrayList<String> internalNames = new ArrayList<String>();
            Collection<AppDescription> myPApplications = PoseidonRuntime.getRuntime().getRegistry(ApplicationRegistry.class).getAppDescriptions();
            for (AppDescription appD : myPApplications) {
                String tempInternalName = appD.getStringProperty("internalName");
                HashMap<String, String> pluginDescription = new HashMap<String, String>();
                pluginDescription.put("AboutBox_ApplicationName", tempInternalName);
                pluginDescription.put("AboutBox_Version", appD.getStringProperty("version"));
                pluginDescription.put("AboutBox_ReleaseDate", appD.getStringProperty("timeStampInformation"));
                if (internalNames.contains(tempInternalName)) continue;
                plugins.add(pluginDescription);
                internalNames.add(tempInternalName);
            }
            model.setProperty("AboutBox_Plugins", plugins);
        }
        return model;
    }

    private AboutBoxController createAbout(AboutBoxModel model) {
        JFrame mainFrame = PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame();
        AboutBoxController controller = new AboutBoxController(mainFrame);
        controller.setModel(model);
        AboutBoxView view = new AboutBoxView(mainFrame, controller);
        controller.setView(view);
        return controller;
    }
}

