/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.labels.PStaticLabel;
import com.nokia.widgets.layout.PMatrixLayout;
import java.awt.Color;
import java.util.Collection;

public class PDetailsView
extends PPanel {
    public PDetailsView() {
        PMatrixLayout layout = new PMatrixLayout(2);
        layout.setVgap(0);
        this.setLayout(layout);
        this.setBackground(Color.WHITE);
        this.clear();
    }

    public void addData(String key, String value) {
        this.addRow(key, value);
    }

    public void addData(String key, Collection values) {
        if (values == null || values.isEmpty()) {
            this.addRow(key, this.createStringValue(null));
            return;
        }
        boolean firstRow = true;
        for (Object value : values) {
            if (firstRow) {
                this.addRow(key, this.createStringValue(value));
                firstRow = false;
                continue;
            }
            this.add(PLabel.createValueText(this.createStringValue(value)));
        }
    }

    public void clear() {
        this.removeAll();
        this.revalidate();
        this.repaint();
    }

    private void addRow(String name, String value) {
        PLabel nameLabel = new PLabel(name);
        nameLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.add(nameLabel);
        this.add(new PStaticLabel(this.createStringValue(value)));
    }

    protected String createStringValue(Object value) {
        return value == null || "".equals(value) ? "-" : value.toString();
    }
}

