/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.services.state.PState;
import com.nokia.em.poseidon.services.ui.notification.PAppMessage;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public final class PStaticDialogs {
    private static final ResourceBundle theBundle = I18n.getI18n().getBundle(PStaticDialogs.class);
    public static final int DEFAULT_BUTTON_NONE = -1;
    public static final Map<PAppMessage, JDialog> myOpenDialogs = new HashMap<PAppMessage, JDialog>();

    private PStaticDialogs() {
    }

    public static void showErrorDialog(Component parent, String title, String headline, Object message, Icon icon) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, null, 0);
    }

    public static void showErrorDialog(Component parent, String title, String headline, Object message, Icon icon, Action[] actions) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, actions, 0);
    }

    public static void showWarningDialog(Component parent, String title, String headline, Object message, Icon icon) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, null, 2);
    }

    public static void showWarningDialog(Component parent, String title, String headline, Object message, Icon icon, Action[] actions) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, actions, 2);
    }

    public static void showInformationDialog(Component parent, String title, String headline, Object message, Icon icon) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, null, 1);
    }

    public static void showInformationDialog(Component parent, String title, String headline, Object message, Icon icon, Action[] actions) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, actions, 1);
    }

    public static void showQuestionMessage(Component parent, String title, String headline, Object message, Icon icon, Action[] actions) {
        PStaticDialogs.showDialog(parent, title, headline, message, icon, actions, 3);
    }

    public static void showMessage(Component parent, PAppMessage message) {
        if (PAppMessage.MessageLevel.ERROR.equals((Object)message.getMessageLevel())) {
            PStaticDialogs.showDialog(parent, message, 0);
        } else if (PAppMessage.MessageLevel.WARNING.equals((Object)message.getMessageLevel())) {
            PStaticDialogs.showDialog(parent, message, 2);
        } else if (PAppMessage.MessageLevel.QUESTION.equals((Object)message.getMessageLevel())) {
            PStaticDialogs.showDialog(parent, message, 3);
        } else {
            PStaticDialogs.showDialog(parent, message, 1);
        }
    }

    public static Action getEmptyAction(String text) {
        return new EmptyAction(text);
    }

    public static Action getEmptyAction(String text, char mnemonic) {
        return new EmptyAction(text, mnemonic);
    }

    private static void showDialog(Component parent, String title, String headline, Object message, Icon icon, Action[] actions, int msgType) {
        PAppMessage appMessage = new PAppMessage(title, headline, message, null, actions);
        appMessage.setIcon(icon);
        PStaticDialogs.showDialog(parent, appMessage, msgType);
    }

    private static void showDialog(Component parent, PAppMessage appMessage, int msgType) {
        Object message = appMessage.getMessage();
        String headline = appMessage.getHeadline();
        Action[] actions = appMessage.getActions();
        String title = appMessage.getTitle();
        Icon icon = appMessage.getIcon();
        Object[] detailedMessage = null;
        if (message.getClass().isArray()) {
            Object[] msgs = (Object[])message;
            detailedMessage = new Object[msgs.length + 1];
            detailedMessage[0] = headline;
            System.arraycopy(msgs, 0, detailedMessage, 1, msgs.length);
        } else {
            detailedMessage = new Object[]{headline, message};
        }
        if (actions == null) {
            JOptionPane.showOptionDialog(parent, detailedMessage, title, -1, msgType, icon, new String[]{theBundle.getString("CloseAction_Text")}, null);
        } else {
            Object[] actionWrappers = new Action[actions.length];
            int defaultAction = 0;
            boolean hasDefaultAction = false;
            int i = 0;
            while (i < actionWrappers.length) {
                Object defaultValue = actions[i].getValue("Default");
                if (defaultValue != null && ((Boolean)defaultValue).booleanValue()) {
                    defaultAction = i;
                    hasDefaultAction = true;
                    break;
                }
                if (defaultValue == null) {
                    defaultAction = i;
                    hasDefaultAction = true;
                }
                ++i;
            }
            final boolean hasDefaultButton = hasDefaultAction;
            JOptionPane errorOptionPane = new JOptionPane((Object)detailedMessage, msgType, -1, icon){

                @Override
                public void selectInitialValue() {
                    if (hasDefaultButton) {
                        super.selectInitialValue();
                    } else {
                        this.requestFocus();
                    }
                }
            };
            JDialog dialog = errorOptionPane.createDialog(parent, title);
            int i2 = 0;
            while (i2 < actionWrappers.length) {
                actionWrappers[i2] = new ActionWrapper(actions[i2], dialog);
                ++i2;
            }
            errorOptionPane.setOptions(actionWrappers);
            if (hasDefaultButton) {
                errorOptionPane.setInitialValue(actionWrappers[defaultAction]);
            }
            dialog.pack();
            int screenWidth = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth();
            int screenHeight = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight();
            if (dialog.getWidth() > screenWidth) {
                dialog.setSize(new Dimension(screenWidth - 10, dialog.getHeight()));
                dialog.invalidate();
            }
            if (dialog.getHeight() > screenHeight) {
                dialog.setSize(new Dimension(dialog.getWidth(), screenHeight - 30));
                dialog.invalidate();
            }
            if (title == null) {
                dialog.setName("StaticDialog");
            } else {
                dialog.setName(title);
            }
            dialog.addWindowListener(appMessage.getWindowListener());
            myOpenDialogs.put(appMessage, dialog);
            dialog.setVisible(true);
            dialog.dispose();
            myOpenDialogs.remove(appMessage);
        }
    }

    public static void closeOpenDialogs() {
        for (JDialog dialog : myOpenDialogs.values()) {
            dialog.dispose();
        }
        myOpenDialogs.clear();
    }

    public static void closeOpenMessageDialog(int messageId) {
        PAppMessage removedMessage = null;
        for (PAppMessage message : myOpenDialogs.keySet()) {
            if (messageId != message.getID()) continue;
            myOpenDialogs.get(message).dispose();
            removedMessage = message;
            break;
        }
        if (removedMessage != null) {
            myOpenDialogs.remove(removedMessage);
        }
    }

    public static void closeOpenMessageDialog(PState stateChange) {
        ArrayList<PAppMessage> disposedMessages = new ArrayList<PAppMessage>();
        for (PAppMessage message : myOpenDialogs.keySet()) {
            for (PState state : message.getCloseDialogInStateChanges()) {
                if (!state.getClass().equals(stateChange.getClass())) continue;
                myOpenDialogs.get(message).dispose();
                disposedMessages.add(message);
            }
        }
        for (PAppMessage message : disposedMessages) {
            myOpenDialogs.remove(message);
        }
    }

    protected static class ActionWrapper
    implements Action,
    PropertyChangeListener {
        private Action myAction;
        private JDialog myDialog;

        public ActionWrapper(Action action, JDialog dialog) {
            this.myAction = action;
            this.myDialog = dialog;
            this.myAction.addPropertyChangeListener(this);
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.myAction.addPropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.myAction.getValue(key);
        }

        @Override
        public boolean isEnabled() {
            return this.myAction.isEnabled();
        }

        @Override
        public void putValue(String key, Object value) {
            this.myAction.putValue(key, value);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.myAction.removePropertyChangeListener(listener);
        }

        @Override
        public void setEnabled(boolean b) {
            this.myAction.setEnabled(b);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.myAction.actionPerformed(e);
            this.myDialog.setVisible(false);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("actionPerformed".equals(evt.getPropertyName())) {
                this.myDialog.setVisible(false);
            }
        }
    }

    protected static class EmptyAction
    extends AbstractAction {
        public EmptyAction(String shortDescription) {
            this.putValue("Name", shortDescription);
        }

        public EmptyAction(String shortDescription, char mnemonic) {
            this.putValue("Name", shortDescription);
            this.putValue("MnemonicKey", mnemonic);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
        }
    }
}

