/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.icons.PEmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeDetailsView
extends PPanel {
    private JTree myTree;
    private DefaultMutableTreeNode myRootNode;
    private DefaultTreeModel myModel;

    public TreeDetailsView() {
        this.setPanelType(ClientProperties.PANEL_USER_FOREGROUND);
        this.setLayout(new BorderLayout());
        this.myRootNode = new DefaultMutableTreeNode();
        this.myModel = new DefaultTreeModel(this.myRootNode);
        this.myTree = new JTree(this.myModel);
        this.myTree.setRootVisible(false);
        this.myTree.setCellRenderer(new TreeDetailsRenderer());
        this.add((Component)this.myTree, "Center");
    }

    public void expandAll() {
        this.expandAll(new TreePath(this.myRootNode), true);
    }

    public void collapseAll() {
        this.expandAll(new TreePath(this.myRootNode), false);
    }

    public void addBranch(String branchName, LinkedHashMap<String, String> leaves) {
        DefaultMutableTreeNode branch = new DefaultMutableTreeNode(branchName);
        this.myModel.insertNodeInto(branch, this.myRootNode, this.myRootNode.getChildCount());
        Set<Map.Entry<String, String>> leafEntries = leaves.entrySet();
        Iterator<Map.Entry<String, String>> leafIterator = leafEntries.iterator();
        int i = 0;
        while (leafIterator.hasNext()) {
            this.myModel.insertNodeInto(new DefaultMutableTreeNode(leafIterator.next()), branch, i++);
        }
        this.myTree.expandPath(new TreePath(this.myRootNode));
    }

    public void clear() {
        this.myRootNode.removeAllChildren();
        this.myModel.reload(this.myRootNode);
    }

    public void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.myTree.expandPath(parent);
        } else {
            this.myTree.collapsePath(parent);
        }
    }

    private static class TreeDetailsRenderer
    extends DefaultTreeCellRenderer {
        private TreeDetailsRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            DefaultMutableTreeNode node;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            this.setIcon(new PEmptyIcon(1, 1));
            if (value instanceof DefaultMutableTreeNode && (node = (DefaultMutableTreeNode)value).getUserObject() instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)node.getUserObject();
                int length = this.getLongestKeyLength(node.getParent());
                JPanel panel = new JPanel(new GridBagLayout());
                panel.setOpaque(false);
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.anchor = 23;
                gbc.gridx = 0;
                gbc.gridy = 0;
                panel.add((Component)new JLabel(entry.getKey().toString()), gbc);
                panel.add(Box.createHorizontalStrut(length + 20), gbc);
                ++gbc.gridy;
                panel.add(new JLabel(entry.getValue().toString()));
                return panel;
            }
            return this;
        }

        private int getLongestKeyLength(TreeNode parent) {
            int length = 0;
            int i = 0;
            while (parent != null && i < parent.getChildCount()) {
                DefaultMutableTreeNode mutableChild;
                TreeNode child = parent.getChildAt(i);
                if (child instanceof DefaultMutableTreeNode && (mutableChild = (DefaultMutableTreeNode)child).getUserObject() instanceof Map.Entry) {
                    Map.Entry entry = (Map.Entry)mutableChild.getUserObject();
                    FontMetrics fm = this.getFontMetrics(this.getFont());
                    int keyWidth = (int)fm.getStringBounds(entry.getKey().toString(), this.getGraphics()).getWidth();
                    if (length < keyWidth) {
                        length = keyWidth;
                    }
                }
                ++i;
            }
            return length;
        }
    }
}

