/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common;

import com.nokia.widgets.util.FocusUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class ViewFocusHandler
implements KeyEventDispatcher,
PropertyChangeListener {
    public static final String SHALL_HANDLE_VIEW_FOCUS = "shall_handle_view_focus";
    protected static ViewFocusHandler theInstance;
    protected List myComps = new ArrayList();
    protected List myIllegalComps = new ArrayList();
    protected boolean myForwardTransfer;
    protected int myIndex;

    protected ViewFocusHandler() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
    }

    public static synchronized ViewFocusHandler getHandler() {
        if (theInstance == null) {
            theInstance = new ViewFocusHandler();
        }
        return theInstance;
    }

    public void stop() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
        this.myComps.clear();
        this.myIllegalComps.clear();
        theInstance = null;
    }

    public boolean addComponent(Component comp) {
        return this.myComps.add(comp);
    }

    public boolean removeComponent(Component comp) {
        return this.myComps.remove(comp);
    }

    public void removeAll() {
        this.myComps.clear();
    }

    public void setComponents(Component ... comps) {
        this.removeAll();
        this.myComps.addAll(Arrays.asList(comps));
    }

    protected int getCurrentIndex() {
        Component focusCandicate = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (focusCandicate != null) {
            if (this.myComps.contains(focusCandicate)) {
                return this.myComps.indexOf(focusCandicate);
            }
            focusCandicate = focusCandicate.getParent();
        }
        return -1;
    }

    protected Component getNext() {
        this.myIndex = this.myIndex == this.myComps.size() - 1 ? 0 : ++this.myIndex;
        return (Component)this.myComps.get(this.myIndex);
    }

    protected Component getPrevious() {
        this.myIndex = this.myIndex <= 0 ? this.myComps.size() - 1 : --this.myIndex;
        return (Component)this.myComps.get(this.myIndex);
    }

    protected boolean shouldHandleFocusItself(Object obj) {
        if (obj instanceof JComponent) {
            Object value = ((JComponent)obj).getClientProperty(SHALL_HANDLE_VIEW_FOCUS);
            if (value != null && value instanceof Boolean) {
                return (Boolean)value;
            }
            return obj instanceof JTextArea || obj instanceof JTable;
        }
        return false;
    }

    protected void moveViewFocusForward() {
        this.myIndex = this.getCurrentIndex();
        int counter = 0;
        while (!FocusUtils.requestFocusFor(this.getNext()) && counter < this.myComps.size()) {
            ++counter;
        }
    }

    protected void moveViewFocusBackward() {
        this.myIndex = this.getCurrentIndex();
        int counter = 0;
        while (!FocusUtils.requestFocusFor(this.getPrevious()) && counter < this.myComps.size()) {
            ++counter;
        }
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && !this.shouldHandleFocusItself(keyEvent.getSource()) && keyEvent.getKeyCode() == 9) {
            if (keyEvent.isControlDown()) {
                if (keyEvent.isShiftDown()) {
                    this.moveViewFocusBackward();
                } else {
                    this.moveViewFocusForward();
                }
                return true;
            }
            this.myForwardTransfer = !keyEvent.isShiftDown();
        }
        return false;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("focusOwner".equals(evt.getPropertyName())) {
            Object owner = evt.getNewValue();
            this.resetToDefaultFocusTraversalPolicy(owner);
            if (owner instanceof JComponent && !((JComponent)owner).isShowing()) {
                if (!this.myIllegalComps.contains(owner)) {
                    JComponent ownerComp = (JComponent)owner;
                    this.myIllegalComps.add(ownerComp);
                    if (this.myForwardTransfer) {
                        ownerComp.transferFocus();
                    } else {
                        ownerComp.transferFocusBackward();
                    }
                } else {
                    this.myIllegalComps.clear();
                    if (this.myForwardTransfer) {
                        this.moveViewFocusForward();
                    } else {
                        this.moveViewFocusBackward();
                    }
                }
            } else if (owner != null) {
                this.myIllegalComps.clear();
            }
        }
    }

    private void resetToDefaultFocusTraversalPolicy(Object owner) {
        FocusTraversalPolicy defaultFocusTraversalPolicy;
        FocusTraversalPolicy ftp;
        Container focusCycleRootAncestor;
        if (owner instanceof JTable && (focusCycleRootAncestor = ((Component)owner).getFocusCycleRootAncestor()) instanceof JTable && !(ftp = focusCycleRootAncestor.getFocusTraversalPolicy()).equals(defaultFocusTraversalPolicy = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalPolicy())) {
            focusCycleRootAncestor.setFocusTraversalPolicy(defaultFocusTraversalPolicy);
        }
    }
}

