/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable;

import com.nokia.em.poseidon.gui.common.edittable.PEditorListenerTableModel;
import javax.swing.JTable;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public final class EditorListenerFactory {
    private static JTable theTable;
    private static int theRow;
    private static int theColumn;
    private static EditorListenerFactory theEditorListenerFactory;
    private static MyDocumentListener theDocumentListener;

    static {
        EditorListenerFactory editorListenerFactory = theEditorListenerFactory = new EditorListenerFactory();
        editorListenerFactory.getClass();
        theDocumentListener = editorListenerFactory.new MyDocumentListener();
    }

    private EditorListenerFactory() {
    }

    public static void createEditorListener(Object editor, JTable table, int row, int col) {
        theTable = table;
        theRow = row;
        theColumn = col;
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).getDocument().addDocumentListener(theDocumentListener);
            TableModel model = theTable.getModel();
            ((PEditorListenerTableModel)model).editorUpdated(((JTextComponent)editor).getText(), theRow, theColumn);
        }
    }

    public static void removeEditorListener(JTable table, Object editor) {
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).getDocument().removeDocumentListener(theDocumentListener);
            TableModel model = table.getModel();
            ((PEditorListenerTableModel)model).editorStopped(((JTextComponent)editor).getText(), table.getEditingRow(), table.getEditingColumn());
        }
    }

    private class MyDocumentListener
    implements DocumentListener {
        private MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TableModel model = theTable.getModel();
            ((PEditorListenerTableModel)model).editorUpdated(this.getStringFromDoc(e.getDocument()), theRow, theColumn);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TableModel model = theTable.getModel();
            ((PEditorListenerTableModel)model).editorUpdated(this.getStringFromDoc(e.getDocument()), theRow, theColumn);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TableModel model = theTable.getModel();
            ((PEditorListenerTableModel)model).editorUpdated(this.getStringFromDoc(e.getDocument()), theRow, theColumn);
        }

        private String getStringFromDoc(Document doc) {
            String text = "";
            try {
                text = doc.getText(0, doc.getLength());
            }
            catch (BadLocationException e1) {
                e1.printStackTrace();
            }
            return text;
        }
    }
}

