/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable;

import com.nokia.em.poseidon.gui.common.edittable.EditorListenerFactory;
import com.nokia.em.poseidon.gui.common.edittable.PComboValue;
import com.nokia.em.poseidon.gui.common.edittable.PEditTableModel;
import com.nokia.em.poseidon.gui.common.edittable.PEditTableUI;
import com.nokia.em.poseidon.gui.common.edittable.PEditableComboValue;
import com.nokia.em.poseidon.gui.common.edittable.PEditorListenerTableModel;
import com.nokia.em.poseidon.gui.common.edittable.PSingleSelectionBoolean;
import com.nokia.em.poseidon.gui.common.edittable.PTextIconValue;
import com.nokia.em.poseidon.gui.common.edittable.editors.PComboValueEditor;
import com.nokia.em.poseidon.gui.common.edittable.editors.PEditTableEditor;
import com.nokia.em.poseidon.gui.common.edittable.renderers.PComboValueCellRenderer;
import com.nokia.em.poseidon.gui.common.edittable.renderers.PTextIconTableCellRenderer;
import com.nokia.em.poseidon.gui.common.edittable.renderers.PToggleCellRenderer;
import com.nokia.widgets.icons.CommonIcons;
import com.nokia.widgets.table.PDefaultCellEditor;
import com.nokia.widgets.table.PTable;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class PEditTable
extends PTable {
    private KeyStroke[] myIgnoredKeyStrokes = null;

    public PEditTable() {
        super(null);
        this.init();
    }

    public PEditTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public PEditTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public PEditTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public PEditTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public PEditTable(Vector rowData, Vector columnNames) {
        super((Vector<?>)rowData, (Vector<?>)columnNames);
        this.init();
    }

    public PEditTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setUI(PEditTableUI.createUI(this));
    }

    public void setIgnoredKeyStrokes(KeyStroke[] keyStrokes) {
        this.myIgnoredKeyStrokes = new KeyStroke[keyStrokes.length + 1];
        System.arraycopy(keyStrokes, 0, this.myIgnoredKeyStrokes, 0, keyStrokes.length);
        this.myIgnoredKeyStrokes[keyStrokes.length] = KeyStroke.getKeyStroke(9, 128);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Class cellClass = null;
        if (this.dataModel instanceof PEditTableModel) {
            cellClass = ((PEditTableModel)this.dataModel).getCellClass(row, column);
        }
        return cellClass != null ? this.getDefaultRenderer(cellClass) : super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Class cellClass = null;
        if (this.dataModel instanceof PEditTableModel) {
            cellClass = ((PEditTableModel)this.dataModel).getCellClass(row, column);
        }
        return cellClass != null ? this.getDefaultEditor(cellClass) : super.getCellEditor(row, column);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point loc = event.getPoint();
        int row = this.rowAtPoint(loc);
        int col = this.columnAtPoint(loc);
        String toolTip = null;
        if (row < 0 || col < 0) {
            toolTip = super.getToolTipText(event);
        } else if (this.dataModel instanceof PEditTableModel) {
            toolTip = ((PEditTableModel)this.dataModel).getCellToolTipText(row, col);
        }
        return toolTip != null ? toolTip : super.getToolTipText(event);
    }

    protected void init() {
        this.setSelectionMode(2);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setDefaultEditor(PSingleSelectionBoolean.class, new PDefaultCellEditor(new JRadioButton()));
        this.setDefaultEditor(PComboValue.class, new PComboValueEditor());
        this.setDefaultRenderer(PTextIconValue.class, new PTextIconTableCellRenderer(CommonIcons.getEditIcon(), "West", 0));
        this.setDefaultRenderer(Boolean.class, new PToggleCellRenderer(1));
        this.setDefaultRenderer(PSingleSelectionBoolean.class, new PToggleCellRenderer(2));
        this.setDefaultRenderer(PComboValue.class, new PComboValueCellRenderer(false));
        this.setDefaultRenderer(PEditableComboValue.class, new PComboValueCellRenderer(true));
    }

    @Override
    protected void processMouseEvent(MouseEvent me) {
        if (SwingUtilities.isRightMouseButton(me)) {
            boolean extend;
            int row = this.rowAtPoint(me.getPoint());
            int column = this.columnAtPoint(me.getPoint());
            boolean toggle = (me.getModifiers() & 2) == 2;
            boolean bl = extend = (me.getModifiers() & 1) == 1;
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            this.changeSelection(row, column, toggle, extend);
        }
        super.processMouseEvent(me);
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (!this.shouldProcessKeyEvent(ks)) {
            return false;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    @Override
    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (!this.getSelectionModel().isSelectedIndex(rowIndex) || !this.isCellEditable(rowIndex, columnIndex) || toggle || extend) {
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        } else if (columnIndex >= 0) {
            this.handleInplaceSelection(rowIndex, columnIndex, toggle, extend);
        }
    }

    protected void handleInplaceSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        this.setColumnSelectionInterval(columnIndex, columnIndex);
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        if (super.editCellAt(row, column, e)) {
            if (this.editorComp instanceof PEditTableEditor) {
                ((PEditTableEditor)((Object)this.editorComp)).doEditCell(this);
            }
            if (this.editorComp != null && this.getModel() instanceof PEditorListenerTableModel) {
                EditorListenerFactory.createEditorListener(this.editorComp, this, row, column);
            }
            return true;
        }
        return false;
    }

    @Override
    public void removeEditor() {
        if (this.getModel() instanceof PEditorListenerTableModel) {
            EditorListenerFactory.removeEditorListener(this, this.editorComp);
        }
        super.removeEditor();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        int[] rows = this.getSelectedRows();
        int i = 0;
        while (i < rows.length) {
            if (value instanceof PComboValue) {
                PComboValue comboValue;
                Object obj = this.getValueAt(rows[i], column);
                if (obj instanceof PComboValue && (comboValue = (PComboValue)obj).isAvailableValue(((PComboValue)value).getCurrentValue())) {
                    super.setValueAt(value, rows[i], column);
                }
            } else {
                super.setValueAt(value, rows[i], column);
            }
            ++i;
        }
        this.repaint();
    }

    private boolean shouldProcessKeyEvent(KeyStroke ks) {
        if (this.myIgnoredKeyStrokes != null) {
            int i = 0;
            while (i < this.myIgnoredKeyStrokes.length) {
                if (ks.equals(this.myIgnoredKeyStrokes[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }
}

