/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable.editors;

import com.nokia.em.poseidon.gui.common.edittable.PComboValue;
import com.nokia.em.poseidon.gui.common.edittable.PEditTable;
import com.nokia.em.poseidon.gui.common.edittable.editors.PEditTableEditor;
import com.nokia.widgets.PComboBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class PComboValueEditor
extends PComboBox
implements TableCellEditor,
PEditTableEditor {
    private PComboValue myCurrentValue;

    public PComboValueEditor() {
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.putClientProperty("JComponent.sizeVariant", "small");
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PComboValueEditor.this.stopCellEditing();
            }
        });
    }

    @Override
    public void doEditCell(PEditTable table) {
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof PComboValue) {
            this.myCurrentValue = (PComboValue)value;
            DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>(this.myCurrentValue.getAvailableValues().toArray());
            this.setModel(comboModel);
            comboModel.setSelectedItem(null);
            comboModel.setSelectedItem(this.myCurrentValue.getCurrentValue());
        }
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        this.myCurrentValue.setCurrentValue(this.getSelectedItem());
        return this.myCurrentValue;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return anEvent instanceof MouseEvent ? ((MouseEvent)anEvent).getClickCount() >= 1 : true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        return anEvent instanceof MouseEvent ? ((MouseEvent)anEvent).getID() != 506 : false;
    }

    @Override
    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener listener) {
        this.listenerList.add(CellEditorListener.class, listener);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener listener) {
        this.listenerList.remove(CellEditorListener.class, listener);
    }

    private void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                ((CellEditorListener)listeners[i + 1]).editingStopped(event);
            }
            i -= 2;
        }
    }

    private void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        ChangeEvent event = new ChangeEvent(this);
        int i = listeners.length - 2;
        while (i >= 0) {
            if (listeners[i] == CellEditorListener.class) {
                ((CellEditorListener)listeners[i + 1]).editingCanceled(event);
            }
            i -= 2;
        }
    }
}

