/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable.renderers;

import com.nokia.em.poseidon.gui.common.edittable.PEditTableModel;
import com.nokia.em.poseidon.gui.common.edittable.renderers.PLookNFeelHelper;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class PDefaultTableCellRenderer
extends DefaultTableCellRenderer {
    protected boolean myIsDeleted;
    protected boolean myIsDisabled = false;

    public PDefaultTableCellRenderer() {
        this(10);
    }

    public PDefaultTableCellRenderer(int horizAlignment) {
        this.setHorizontalAlignment(horizAlignment);
        this.putClientProperty("JComponent.sizeVariant", "small");
    }

    @Override
    public void paintComponent(Graphics grfx) {
        super.paintComponent(grfx);
        if (this.myIsDeleted) {
            PLookNFeelHelper.paintDeletedCell(grfx, this, this.myIsDisabled);
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.putClientProperty("OrangeTouch.automaticTooltipEnabled", ComponentUtils.isRolloveredCell(table, row, column));
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TableModel model = table.getModel();
        if (model instanceof PEditTableModel) {
            this.myIsDeleted = ((PEditTableModel)model).isCellDeleted(row, column);
            this.myIsDisabled = ((PEditTableModel)model).isCellDisabled(row, column);
        }
        PLookNFeelHelper.paintCellState(this, !this.myIsDisabled);
        return this;
    }
}

