/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable.renderers;

import com.nokia.em.poseidon.gui.common.edittable.PTextIconValue;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.table.PTableHeaderRenderer;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;

public class PIconHeaderRenderer
extends PTableHeaderRenderer {
    private static PEmptyIcon EMPTY_ICON = new PEmptyIcon();

    public PIconHeaderRenderer() {
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (table != null) {
            JTableHeader header;
            this.myTableHeader = header = table.getTableHeader();
            if (header != null) {
                Object autoTooltip = table.getClientProperty("OrangeTouch.automaticTooltipEnabled");
                if (autoTooltip == null || Boolean.TRUE.equals(autoTooltip)) {
                    boolean rollovered = ComponentUtils.isRolloveredColumn(header, column);
                    this.putClientProperty("OrangeTouch.automaticTooltipEnabled", rollovered);
                }
                this.setForeground(table.isEnabled() ? header.getForeground() : UIManager.getColor("Label.disabledForeground"));
                this.setBackground(header.getBackground());
                this.setFont(header.getFont());
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        if (value instanceof PTextIconValue) {
            this.setText(((PTextIconValue)value).getText());
            this.setIcon(((PTextIconValue)value).getIcon());
        } else if (value instanceof Icon) {
            this.setIcon((Icon)value);
        } else if (value instanceof ImageIcon) {
            this.setIcon((ImageIcon)value);
        } else {
            this.setText(value.toString());
            this.setIcon(EMPTY_ICON);
        }
        this.setMargin(ComponentUtils.isSmall(table) ? DEFAULT_MARGIN_SMALL : DEFAULT_MARGIN);
        return this;
    }
}

