/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable.renderers;

import com.nokia.em.poseidon.gui.common.edittable.PComboValue;
import com.nokia.em.poseidon.gui.common.edittable.PEditTableModel;
import com.nokia.em.poseidon.gui.common.edittable.PTextIconValue;
import com.nokia.em.poseidon.gui.common.edittable.renderers.PLookNFeelHelper;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PTextIconTableCellRenderer
extends JPanel
implements TableCellRenderer {
    protected static Border noFocusBorder = UIManager.getBorder("Table.noFocusCellBorder");
    protected JLabel myTextLabel;
    protected JLabel myIconLabel;
    protected boolean myIsDeleted;
    protected boolean myIsDisabled;
    protected boolean myIsModified;
    protected TableModel myModel;
    protected PTextIconValue myTextIconValue;
    private Icon myModifyIcon;

    public PTextIconTableCellRenderer(Icon icon, String iconAlignment, int textAlignment) {
        this.checkAlignment(iconAlignment);
        this.setLayout(new BorderLayout());
        this.myModifyIcon = icon;
        this.init(iconAlignment, textAlignment);
    }

    public void setModifyIcon(Icon icon) {
        this.myModifyIcon = icon;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.myIsDeleted) {
            PLookNFeelHelper.paintDeletedCell(g, this, this.myIsDisabled);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.myTextLabel != null) {
            this.myTextLabel.setForeground(fg);
        }
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myIsModified = false;
        this.myIsDisabled = false;
        this.myIsDeleted = false;
        this.myModel = table.getModel();
        if (this.myModel instanceof PEditTableModel) {
            this.myIsDeleted = ((PEditTableModel)this.myModel).isCellDeleted(row, column);
            this.myIsDisabled = ((PEditTableModel)this.myModel).isCellDisabled(row, column);
            this.myIsModified = ((PEditTableModel)this.myModel).isCellModified(row, column);
        }
        if (!table.isEnabled()) {
            this.myIsDisabled = true;
        }
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    this.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.setBackground(col);
                }
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        PLookNFeelHelper.paintCellState(this, !this.myIsDisabled);
        this.updateComponent(value);
        this.myTextLabel.putClientProperty("OrangeTouch.automaticTooltipEnabled", ComponentUtils.isRolloveredCell(table, row, column));
        return this;
    }

    @Override
    public String getToolTipText() {
        return this.myTextLabel.getToolTipText();
    }

    protected void updateComponent(Object value) {
        if (value instanceof PTextIconValue) {
            this.myTextIconValue = (PTextIconValue)value;
            this.myTextLabel.setText(this.myTextIconValue.getText());
            this.myIconLabel.setIcon(this.myTextIconValue.isRowModifyStatusCell() && this.myIsModified ? this.myModifyIcon : this.myTextIconValue.getIcon());
        } else if (value instanceof PComboValue) {
            this.myTextLabel.setText(value.toString());
            this.myIconLabel.setIcon(this.myModifyIcon);
        }
    }

    protected String checkAlignment(String alignment) {
        if (alignment.equals("East") || alignment.equals("West")) {
            return alignment;
        }
        throw new IllegalArgumentException("Invalid alignment");
    }

    private void init(String iconAlignment, int textAlignment) {
        this.myTextLabel = new JLabel(){

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }

            @Override
            protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
                if ("text".equals(propertyName)) {
                    super.firePropertyChange(propertyName, oldValue, newValue);
                }
            }
        };
        this.myTextLabel.setHorizontalAlignment(textAlignment);
        this.myIconLabel = new JLabel(){

            @Override
            public void validate() {
            }

            @Override
            public void revalidate() {
            }

            @Override
            public void repaint(long tm, int x, int y, int width, int height) {
            }

            @Override
            public void repaint(Rectangle r) {
            }

            @Override
            public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
            }
        };
        this.add((Component)this.myTextLabel, "Center");
        this.add((Component)this.myIconLabel, iconAlignment);
    }
}

