/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.edittable.renderers;

import com.nokia.em.poseidon.gui.common.edittable.PEditTableModel;
import com.nokia.em.poseidon.gui.common.edittable.PSingleSelectionBoolean;
import com.nokia.em.poseidon.gui.common.edittable.renderers.PLookNFeelHelper;
import com.nokia.widgets.util.ComponentUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class PToggleCellRenderer
implements TableCellRenderer {
    protected static Border noFocusBorder = new EmptyBorder(1, 4, 1, 4);
    public static final int CHECK = 1;
    public static final int RADIO = 2;
    protected JToggleButton myRenderingDelegate;
    private boolean myIsDeleted;
    private boolean myIsDisabled;
    private TableModel myModel;

    public PToggleCellRenderer(int type) {
        switch (type) {
            case 1: {
                this.myRenderingDelegate = new JCheckBox(){

                    @Override
                    public void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        PToggleCellRenderer.this.paintDelete(g);
                    }

                    @Override
                    public void validate() {
                    }

                    @Override
                    public void revalidate() {
                    }

                    @Override
                    public void repaint(long tm, int x, int y, int width, int height) {
                    }

                    @Override
                    public void repaint(Rectangle r) {
                    }

                    @Override
                    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
                    }
                };
                this.myRenderingDelegate.setName("PToggleCellRenderer.RenderingDelegateCheckBox");
                this.myRenderingDelegate.putClientProperty("JComponent.sizeVariant", "small");
                break;
            }
            case 2: {
                this.myRenderingDelegate = new JRadioButton(){

                    @Override
                    public void paintComponent(Graphics g) {
                        super.paintComponent(g);
                        PToggleCellRenderer.this.paintDelete(g);
                    }

                    @Override
                    public void validate() {
                    }

                    @Override
                    public void revalidate() {
                    }

                    @Override
                    public void repaint(long tm, int x, int y, int width, int height) {
                    }

                    @Override
                    public void repaint(Rectangle r) {
                    }

                    @Override
                    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
                    }
                };
                this.myRenderingDelegate.setName("PToggleCellRenderer.RenderingDelegateRadioButton");
                this.myRenderingDelegate.putClientProperty("JComponent.sizeVariant", "small");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.myRenderingDelegate.setOpaque(true);
        this.myRenderingDelegate.setBorderPainted(true);
        this.myRenderingDelegate.setHorizontalAlignment(0);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.myIsDisabled = false;
        this.myIsDeleted = false;
        this.myModel = table.getModel();
        if (this.myModel instanceof PEditTableModel) {
            this.myIsDeleted = ((PEditTableModel)this.myModel).isCellDeleted(row, column);
            this.myIsDisabled = ((PEditTableModel)this.myModel).isCellDisabled(row, column);
            this.myRenderingDelegate.getModel().setEnabled(!this.myIsDisabled);
        }
        this.myRenderingDelegate.getModel().setRollover(ComponentUtils.isRolloveredCell(table, row, column));
        if (hasFocus) {
            this.myRenderingDelegate.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    this.myRenderingDelegate.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    this.myRenderingDelegate.setBackground(col);
                }
            }
        } else {
            this.myRenderingDelegate.setBorder(noFocusBorder);
        }
        this.updateComponent(value);
        PLookNFeelHelper.paintCellState(this.myRenderingDelegate, !this.myIsDisabled);
        return this.myRenderingDelegate;
    }

    protected void paintDelete(Graphics g) {
        if (this.myIsDeleted) {
            PLookNFeelHelper.paintDeletedCell(g, this.myRenderingDelegate, this.myIsDisabled);
        }
    }

    protected void updateComponent(Object value) {
        if (value instanceof Boolean) {
            this.myRenderingDelegate.setSelected((Boolean)value);
        } else if (value instanceof PSingleSelectionBoolean) {
            this.myRenderingDelegate.setSelected(((PSingleSelectionBoolean)value).getValue());
        }
    }
}

