/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.file;

import java.io.File;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class CustomFileNameFilter
extends FileFilter {
    private FileFilter myPreviousFileFilter;
    private String mySearchedText = "";
    private final Logger myLogger;
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");

    public CustomFileNameFilter(FileFilter prev) {
        this.myPreviousFileFilter = prev;
        this.myLogger = Logger.getLogger(this.getClass());
    }

    @Override
    public boolean accept(File f) {
        if (this.myPreviousFileFilter != null) {
            if (this.myPreviousFileFilter.accept(f)) {
                File typedFile = new File(this.mySearchedText);
                if (this.mySearchedText.length() != 0 && typedFile.exists() && typedFile.isDirectory()) {
                    return true;
                }
                File parentFile = new File(String.valueOf(f.getParent()) + this.mySearchedText);
                if (this.mySearchedText.length() != 0 && parentFile.exists() && parentFile.isDirectory()) {
                    return true;
                }
                if (this.mySearchedText.length() != 0 && f.getParentFile() != null) {
                    parentFile = f.getParentFile();
                    typedFile = this.mySearchedText.startsWith(FILE_SEPARATOR) ? new File(String.valueOf(parentFile.getParent()) + this.mySearchedText) : new File(String.valueOf(parentFile.getParent()) + FILE_SEPARATOR + this.mySearchedText);
                    if (typedFile.exists() && typedFile.isDirectory()) {
                        return true;
                    }
                }
                if (this.mySearchedText.startsWith(String.valueOf(f.getParent()) + FILE_SEPARATOR)) {
                    try {
                        this.mySearchedText = this.mySearchedText.substring(f.getParent().length() + 1, this.mySearchedText.length());
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        this.myLogger.error("String index out of bounds, String :" + this.mySearchedText + " subString index:[" + (f.getParent().length() + 1) + ", " + this.mySearchedText.length() + "] " + e.getMessage());
                        this.mySearchedText = typedFile.getName();
                        this.myLogger.debug("adjust search text :" + this.mySearchedText);
                    }
                }
                if (f.getName().contains(this.mySearchedText)) {
                    return true;
                }
            }
        } else if (f.getName().contains(this.mySearchedText)) {
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.myPreviousFileFilter.getDescription();
    }

    public void setPreviousFilter(FileFilter filter) {
        this.myPreviousFileFilter = filter;
    }

    public void setSearchedText(String txt) {
        this.mySearchedText = txt;
    }
}

