/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.file;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.gui.common.file.CustomFileNameFilter;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.ViewUtils;
import com.nokia.widgets.balloon.Balloon;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class FileChooserBase
extends JFileChooser
implements PropertyChangeListener {
    private static final int DELAY_TIME = 10;
    private static Object lock = new Object();
    public static final String LAST_SELECTED_FILE_POSTFIX = "_LastSelection";
    public static final String LIST_VIEW_ON_POSTFIX = "_ListView";
    protected String mySettingsKey;
    protected transient ComponentFilter DETAILSVIEW_FILTER = new DetailsViewFilter();
    protected transient ComponentFilter LISTVIEW_FILTER = new ListViewFilter();
    protected transient ComponentFilter APPROVEBUTTON_FILTER = new ApproveButtonFilter();
    protected transient ComponentFilter REJECTBUTTON_FILTER = new RejectButtonFilter();
    protected transient ComponentFilter FILENAME_FIELD_FILTER = new FileNameFieldFilter();
    protected JComponent myApproveButton;
    protected JComponent myRejectButton;
    protected JTextField myFilenameField;
    protected AbstractButton myDetailsViewButton;
    protected AbstractButton myListViewButton;
    protected Balloon myBalloon;
    protected PSettings mySettings;
    protected int myX;
    protected int myY;
    protected int myWidth;
    protected int myHeight;
    private int myDefaultXCoordinate;
    private int myDefaultYCoordinate;
    private int myDefaultHeight;
    private int myDefaultWidth;
    private boolean myUseQuickSelection = true;
    private KeyAdapter myQuickSelectionKeyAdapter;

    public FileChooserBase() {
        this.init();
    }

    public FileChooserBase(String currentDirectoryPath) {
        super(currentDirectoryPath);
        this.init();
    }

    public FileChooserBase(File currentDirectory) {
        super(currentDirectory);
        this.init();
    }

    public FileChooserBase(FileSystemView fsv) {
        super(fsv);
        this.init();
    }

    public FileChooserBase(File currentDirectory, FileSystemView fsv) {
        this(currentDirectory, fsv, null);
    }

    public FileChooserBase(String currentDirectoryPath, FileSystemView fsv) {
        this(currentDirectoryPath, fsv, null);
    }

    public FileChooserBase(String currentDirectoryPath, FileSystemView fsv, String settingsKey) {
        super(currentDirectoryPath, fsv);
        this.setSettingsKey(settingsKey);
        this.init();
    }

    public FileChooserBase(FileSystemView fsv, String settingsKey) {
        super(fsv);
        this.setSettingsKey(settingsKey);
        this.init();
    }

    public FileChooserBase(File currentDirectory, FileSystemView fsv, String settingsKey) {
        super(currentDirectory, fsv);
        this.setSettingsKey(settingsKey);
        this.init();
    }

    public FileChooserBase(File currentDirectory, String settingsKey) {
        super(currentDirectory);
        this.setSettingsKey(settingsKey);
        this.init();
    }

    protected void init() {
        this.mySettings = PSettings.getInstance();
        this.myApproveButton = (JComponent)this.searchComponents(this.APPROVEBUTTON_FILTER);
        this.myRejectButton = (JComponent)this.searchComponents(this.REJECTBUTTON_FILTER);
        this.myFilenameField = (JTextField)this.searchComponents(this.FILENAME_FIELD_FILTER);
        this.myDetailsViewButton = (AbstractButton)this.searchComponents(this.DETAILSVIEW_FILTER);
        this.myListViewButton = (AbstractButton)this.searchComponents(this.LISTVIEW_FILTER);
        this.myFilenameField.getDocument().addDocumentListener(new BalloonCloser());
        this.addPropertyChangeListener(this);
        this.removeTooltipText();
    }

    public void setSettingsKey(String str) {
        this.mySettingsKey = str;
    }

    public void removeSettingsKey() {
        this.mySettingsKey = null;
    }

    public void setApproveButtonEnabled(boolean enabled) {
        if (this.myApproveButton != null) {
            this.myApproveButton.setEnabled(enabled);
        }
    }

    public void setUseQuickSelection(boolean b) {
        this.myUseQuickSelection = b;
    }

    public boolean getUseQuickSelection() {
        return this.myUseQuickSelection;
    }

    @Override
    public void approveSelection() {
        if (this.getDialogType() == 0) {
            if (this.checkOpenFile(this.getSelectedFile())) {
                this.saveSettings();
                if (this.myQuickSelectionKeyAdapter != null) {
                    this.myFilenameField.removeKeyListener(this.myQuickSelectionKeyAdapter);
                }
                super.approveSelection();
            } else {
                this.showInvalidOpenFileMessage();
            }
        } else {
            if (this.myQuickSelectionKeyAdapter != null) {
                this.myFilenameField.removeKeyListener(this.myQuickSelectionKeyAdapter);
            }
            super.approveSelection();
        }
    }

    @Override
    public void cancelSelection() {
        if (this.myQuickSelectionKeyAdapter != null) {
            this.myFilenameField.removeKeyListener(this.myQuickSelectionKeyAdapter);
        }
        super.cancelSelection();
    }

    public void loadDefaultsFromSettingsToDialog(JDialog dialog) {
        if (this.mySettingsKey != null && this.mySettingsKey.length() > 0) {
            String p = this.mySettings.get(String.valueOf(this.mySettingsKey) + LAST_SELECTED_FILE_POSTFIX, "");
            boolean listViewOn = this.mySettings.get(String.valueOf(this.mySettingsKey) + LIST_VIEW_ON_POSTFIX, true);
            this.restoreLocationBounds(dialog);
            if (listViewOn) {
                this.myListViewButton.doClick();
            } else {
                this.myDetailsViewButton.doClick();
            }
            this.setSelectedFile(new File(p));
        }
    }

    public void saveSettings() {
        if (this.mySettingsKey != null && this.mySettingsKey.length() > 0) {
            ViewUtils.storeSettings(this.mySettingsKey, new Rectangle(this.myX, this.myY, this.myWidth, this.myHeight));
            if (this.getSelectedFile() != null) {
                this.mySettings.set(String.valueOf(this.mySettingsKey) + LAST_SELECTED_FILE_POSTFIX, this.getSelectedFile().getPath());
            }
            this.mySettings.set(String.valueOf(this.mySettingsKey) + LIST_VIEW_ON_POSTFIX, this.myListViewButton.isSelected());
        }
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        final JDialog dialog = super.createDialog(parent);
        dialog.setMinimumSize(new Dimension(600, 400));
        this.loadDefaultsFromSettingsToDialog(dialog);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                FileChooserBase.this.myHeight = dialog.getHeight();
                FileChooserBase.this.myWidth = dialog.getWidth();
                FileChooserBase.this.myX = dialog.getX();
                FileChooserBase.this.myY = dialog.getY();
                FileChooserBase.this.saveSettings();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                this.windowActivated(e);
            }
        });
        if (this.myUseQuickSelection) {
            FileFilter[] allFilters = this.getChoosableFileFilters();
            int x = 0;
            while (x < allFilters.length) {
                if (allFilters[x] instanceof CustomFileNameFilter) {
                    ((CustomFileNameFilter)allFilters[x]).setSearchedText("");
                } else {
                    FileFilter fileFilter = allFilters[x];
                    this.removeChoosableFileFilter(fileFilter);
                    allFilters[x] = new CustomFileNameFilter(fileFilter);
                    this.addChoosableFileFilter(allFilters[x]);
                    this.setFileFilter(allFilters[x]);
                }
                ++x;
            }
            final long currentTime = System.currentTimeMillis();
            if (this.myQuickSelectionKeyAdapter == null) {
                this.myQuickSelectionKeyAdapter = new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        long diff = e.getWhen() - currentTime;
                        if (FileChooserBase.this.getFileFilter() instanceof CustomFileNameFilter && diff > 10L) {
                            ((CustomFileNameFilter)FileChooserBase.this.getFileFilter()).setSearchedText(FileChooserBase.this.myFilenameField.getText());
                        }
                        FileChooserBase.this.rescanCurrentDirectory();
                    }
                };
            }
            this.myFilenameField.addKeyListener(this.myQuickSelectionKeyAdapter);
            this.rescanCurrentDirectory();
        }
        return dialog;
    }

    protected boolean checkOpenFile(File file) {
        return file != null && file.exists();
    }

    protected void showInvalidOpenFileMessage() {
        this.closeBalloon();
        this.myBalloon = new Balloon(this.myFilenameField, SwingUtilities.getWindowAncestor(this), I18n.getI18n().getBundle(this.getClass()).getString("FileChooserBase.FileNotValid_Text"), I18n.getI18n().getBundle(this.getClass()).getString("FileChooserBase.FileNotValid_Title"), 0, 0);
        this.myBalloon.showBalloon();
    }

    protected void removeTooltipText() {
        this.myApproveButton.setToolTipText(null);
        this.myRejectButton.setToolTipText(null);
        this.myApproveButton.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("ToolTipText".equals(evt.getPropertyName()) && FileChooserBase.this.myApproveButton != null) {
                    FileChooserBase.this.myApproveButton.setToolTipText(null);
                }
            }
        });
    }

    protected void closeBalloon() {
        if (this.myBalloon != null) {
            this.myBalloon.dispose();
            this.myBalloon = null;
        }
    }

    private void restoreLocationBounds(JDialog dialog) {
        this.initializeDefaultDialogProperties(dialog);
        Rectangle bounds = ViewUtils.restoreSettings(this.mySettingsKey, new Rectangle(this.myDefaultXCoordinate, this.myDefaultYCoordinate, this.myDefaultWidth, this.myDefaultHeight));
        dialog.setBounds(bounds);
    }

    private void initializeDefaultDialogProperties(JDialog dialog) {
        GraphicsConfiguration graphConfig = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        Rectangle screenBounds = graphConfig.getBounds();
        this.myDefaultXCoordinate = (int)((double)(screenBounds.width / 2) - dialog.getSize().getWidth() / 2.0);
        this.myDefaultYCoordinate = (int)((double)(screenBounds.height / 2) - dialog.getSize().getHeight() / 2.0);
        this.myDefaultWidth = (int)dialog.getSize().getWidth();
        this.myDefaultHeight = (int)dialog.getSize().getHeight();
    }

    private Component searchComponents(ComponentFilter filter) {
        Component component = null;
        int i = 0;
        while (i < this.getComponents().length) {
            Component comp = this.getComponents()[i];
            component = this.searchComponent(comp, filter);
            if (component != null) {
                return component;
            }
            ++i;
        }
        return component;
    }

    private Component searchComponent(Component component, ComponentFilter filter) {
        Component result = null;
        if (filter.accept(component)) {
            result = component;
        } else if (component instanceof Container) {
            int i = 0;
            while (i < ((Container)component).getComponents().length) {
                Component comp = ((Container)component).getComponents()[i];
                result = this.searchComponent(comp, filter);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFileFilter(FileFilter filter) {
        Object object = lock;
        synchronized (object) {
            super.setFileFilter(filter);
        }
    }

    public int getDefaultXCoordinate() {
        return this.myDefaultXCoordinate;
    }

    public int getDefaultYCoordinate() {
        return this.myDefaultYCoordinate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accept(File f) {
        Object object = lock;
        synchronized (object) {
            return super.accept(f);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        if ("ApproveButtonTextChangedProperty".equals(evt.getPropertyName())) {
            this.myApproveButton = (JComponent)this.searchComponents(this.APPROVEBUTTON_FILTER);
        }
    }

    protected static class ApproveButtonFilter
    implements ComponentFilter {
        protected ApproveButtonFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            if (comp instanceof AbstractButton) {
                String buttonText = ((AbstractButton)comp).getText();
                return buttonText != null && buttonText.equals(UIManager.getString((Object)"FileChooser.openButtonText", null));
            }
            return false;
        }
    }

    protected class BalloonCloser
    implements DocumentListener {
        protected BalloonCloser() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            FileChooserBase.this.closeBalloon();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FileChooserBase.this.closeBalloon();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            FileChooserBase.this.closeBalloon();
        }
    }

    protected static interface ComponentFilter {
        public boolean accept(Component var1);
    }

    protected static class DetailsViewFilter
    implements ComponentFilter {
        protected DetailsViewFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            if (comp instanceof AbstractButton) {
                Icon i = UIManager.getIcon("FileChooser.detailsViewIcon");
                return i != null && i.equals(((AbstractButton)comp).getIcon());
            }
            return false;
        }
    }

    protected static class FileNameFieldFilter
    implements ComponentFilter {
        protected FileNameFieldFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            return comp instanceof JTextField;
        }
    }

    protected static class ListViewFilter
    implements ComponentFilter {
        protected ListViewFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            if (comp instanceof AbstractButton) {
                Icon i = UIManager.getIcon("FileChooser.listViewIcon");
                return i != null && i.equals(((AbstractButton)comp).getIcon());
            }
            return false;
        }
    }

    protected static class RejectButtonFilter
    implements ComponentFilter {
        protected RejectButtonFilter() {
        }

        @Override
        public boolean accept(Component comp) {
            if (comp instanceof AbstractButton) {
                String buttonText = ((AbstractButton)comp).getText();
                return buttonText != null && buttonText.equals(UIManager.getString((Object)"FileChooser.cancelButtonText", null));
            }
            return false;
        }
    }
}

