/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.file;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.gui.common.file.FileChooserBase;
import com.nokia.em.poseidon.gui.common.file.FileComboBoxModel;
import com.nokia.em.poseidon.gui.common.file.FileComboBoxRenderer;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.folderbrowser.FolderBrowser;
import java.awt.FontMetrics;
import java.awt.event.ItemEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class FileComboBox
extends PComboBox {
    public static final String DEFAULT_SETTINGS_KEY = "_DefaultSettingsKey";
    public static final String DEFAULT_DIR_POSTFIX = "_DefaultDirectory";
    protected SELECTION_TYPE mySelectionType;
    protected JFileChooser myChooser;
    protected FolderBrowser myFolderChooser;
    protected Object myPreviousItemListenerItem;
    protected Object myPreviousActionListenerItem;
    protected String myInitialText;
    protected String myDefaultDirKey;
    protected String myDefaultDir;
    protected PSettings mySettings;

    public FileComboBox() {
        this(DEFAULT_SETTINGS_KEY);
    }

    public FileComboBox(String settingsKey) {
        this(settingsKey, null);
    }

    public FileComboBox(String settingsKey, String defaultDirectory) {
        this(settingsKey, defaultDirectory, PSettings.getInstance());
    }

    public FileComboBox(String settingsKey, String defaultDirectory, PSettings settings) {
        this(settingsKey, defaultDirectory, PSettings.getInstance(), SELECTION_TYPE.FILE_SELECTION);
    }

    public FileComboBox(String settingsKey, String defaultDirectory, PSettings settings, SELECTION_TYPE selectionType) {
        super(new FileComboBoxModel(settings, settingsKey, 5), (Object)" ");
        this.myDefaultDirKey = String.valueOf(settingsKey) + DEFAULT_DIR_POSTFIX;
        this.mySettings = settings;
        this.myDefaultDir = defaultDirectory;
        this.mySelectionType = selectionType;
        this.myInitialText = I18n.getI18n().getBundle(this.getClass()).getString("File.Browse_Select_Text");
        this.getModel().setSelectedItem(this.myInitialText);
        FileComboBoxRenderer comboRenderer = new FileComboBoxRenderer();
        comboRenderer.setSelectionType(selectionType);
        this.setRenderer(comboRenderer);
        this.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
        this.putClientProperty("JComboBox.isFileChooserCombo", Boolean.TRUE);
    }

    public void setFileChooser(JFileChooser chooser) {
        this.myChooser = chooser;
    }

    public void setFolderBrowser(FolderBrowser browser) {
        this.myFolderChooser = browser;
    }

    public FolderBrowser getFolderBrowser() {
        if (this.myFolderChooser == null) {
            this.myFolderChooser = new FolderBrowser(null);
            if (this.myDefaultDir != null) {
                try {
                    File dir = new File(this.myDefaultDir);
                    if (dir.exists() && dir.isDirectory()) {
                        this.myFolderChooser.setSelectedDirectory(dir);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.myFolderChooser.getHelpButton().setVisible(false);
        }
        return this.myFolderChooser;
    }

    public JFileChooser getFileChooser() {
        if (this.myChooser == null) {
            this.myChooser = new FileChooserBase(this.getFileDirectory());
        }
        return this.myChooser;
    }

    public void setSelectionType(SELECTION_TYPE selection) {
        this.mySelectionType = selection;
        if (this.getRenderer() instanceof FileComboBoxRenderer) {
            ((FileComboBoxRenderer)this.getRenderer()).setSelectionType(selection);
        }
    }

    public void setDefaultFolderKey(String newKey) {
        this.myDefaultDirKey = newKey;
    }

    public boolean isProperItemSelected() {
        return !this.isInitialItemSelected() && !this.isMissing();
    }

    public int calculatePopUpWidth() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int width = this.getSize().width;
        if (width == 0) {
            width = this.getPreferredSize().width;
        }
        int i = 0;
        while (i < this.getItemCount()) {
            Object value = this.getItemAt(i);
            if (value instanceof File) {
                width = Math.max(width, fm.stringWidth(((File)value).getName()) + 20);
            } else if (value instanceof ImageIcon) {
                ImageIcon icon = (ImageIcon)value;
                width = Math.max(width, icon.getIconWidth() + fm.stringWidth(icon.getDescription()) + 20);
            } else {
                width = Math.max(width, fm.stringWidth(value.toString()));
            }
            ++i;
        }
        width = this.adjustWidth(width);
        return width;
    }

    private int adjustWidth(int width) {
        int tempWidth = width;
        if (this.getItemCount() > 8) {
            tempWidth = width + 14;
        }
        return tempWidth;
    }

    protected void handleSelection(boolean approved, File selectedFile) {
        if (approved) {
            this.addItem(selectedFile);
            this.setSelectedItem(selectedFile);
            this.mySettings.set(this.myDefaultDirKey, selectedFile.getAbsolutePath());
        } else {
            this.getModel().setSelectedItem(this.myPreviousItemListenerItem);
        }
    }

    private boolean isInitialItemSelected() {
        if (this.getSelectedItem() != null) {
            return this.getSelectedItem().equals(this.myInitialText);
        }
        return false;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setPopupWidth(this.calculatePopUpWidth());
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setPopupWidth(this.calculatePopUpWidth());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ComboBoxModel model;
        super.propertyChange(evt);
        String propertyName = evt.getPropertyName();
        if ("mandatoryEntry".equals(propertyName) && (model = this.getModel()) instanceof FileComboBoxModel) {
            Object empty = this.getEmptyItem();
            if (this.isMandatoryEntry() && empty != null && empty.equals(this.getSelectedItem())) {
                this.getModel().setSelectedItem(this.myInitialText);
            }
            ((FileComboBoxModel)model).setShowEmptyItem(!this.isMandatoryEntry());
        }
    }

    @Override
    protected void fireItemStateChanged(ItemEvent event) {
        if (1 == event.getStateChange()) {
            if ("Browse...".equals(event.getItem())) {
                this.setPopupVisible(false);
                if (this.mySelectionType.equals((Object)SELECTION_TYPE.FILE_SELECTION)) {
                    this.setSelectedFile();
                    int selection = this.myChooser.showOpenDialog(this);
                    this.handleSelection(selection == 0, this.myChooser.getSelectedFile());
                } else {
                    this.getFolderBrowser().setVisible(true);
                    this.handleSelection(this.myFolderChooser.isOKClicked(), this.myFolderChooser.getSelectedDirectory());
                }
            }
        } else {
            this.myPreviousItemListenerItem = event.getItem();
        }
        if ("Browse...".equals(event.getItem()) || this.myInitialText.equals(event.getItem())) {
            return;
        }
        super.fireItemStateChanged(event);
    }

    @Override
    protected void fireActionEvent() {
        Object selection = this.getSelectedItem();
        if ("Browse...".equals(selection) || this.myInitialText.equals(selection) || this.myPreviousActionListenerItem != null && this.myPreviousActionListenerItem.equals(selection)) {
            return;
        }
        if (selection == null) {
            this.getModel().setSelectedItem(this.myInitialText);
            return;
        }
        this.myPreviousActionListenerItem = selection;
        super.fireActionEvent();
    }

    private void setSelectedFile() {
        String fileDir = this.getFileDirectory();
        File file = null;
        if (this.myChooser == null) {
            this.myChooser = new FileChooserBase(fileDir);
        } else {
            this.myChooser.setSelectedFile(null);
        }
        if (fileDir != null) {
            file = new File(fileDir);
        }
        this.myChooser.setSelectedFile(file);
    }

    private String getFileDirectory() {
        String fileDir = this.mySettings.get(this.myDefaultDirKey, this.myDefaultDir);
        if ("null".equals(fileDir)) {
            fileDir = null;
        }
        return fileDir;
    }

    public static enum SELECTION_TYPE {
        FILE_SELECTION,
        FOLDER_SELECTION;

    }
}

