/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.file;

import com.nokia.em.poseidon.util.PSettings;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;

public class FileComboBoxModel
extends DefaultComboBoxModel {
    public static final String THE_BROWSE_ITEM = "Browse...";
    public static final String THE_EMPTY_ITEM = " ";
    protected PSettings mySettings;
    protected int myMaxItems;
    protected String mySettingsKey;
    protected boolean myShowEmptyItem;

    public FileComboBoxModel(PSettings settings, String settingsKey, int maxItems) {
        String[] valuesFromSettings;
        this.mySettings = settings;
        this.mySettingsKey = settingsKey;
        this.myMaxItems = maxItems;
        super.insertElementAt(THE_BROWSE_ITEM, 0);
        ++this.myMaxItems;
        this.setShowEmptyItem(true);
        String[] stringArray = valuesFromSettings = this.mySettings.getSequence(this.mySettingsKey, new String[0]);
        int n = valuesFromSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File file = new File(path);
            if (file.exists()) {
                super.addElement(file);
            }
            ++n2;
        }
    }

    public void setShowEmptyItem(boolean show) {
        if (show != this.myShowEmptyItem) {
            if (show) {
                super.insertElementAt(THE_EMPTY_ITEM, 0);
                ++this.myMaxItems;
            } else {
                super.removeElementAt(0);
                --this.myMaxItems;
            }
            this.myShowEmptyItem = show;
        }
    }

    protected String[] getValuesToStore() {
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < this.getSize()) {
            Object element = this.getElementAt(i);
            if (element instanceof File) {
                values.add(((File)element).getAbsolutePath());
            }
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public void setSelectedItem(Object anObject) {
        int alreadyPresentIndex = this.getIndexOf(anObject);
        if (this.myShowEmptyItem && alreadyPresentIndex > 1 || !this.myShowEmptyItem && alreadyPresentIndex > 0) {
            super.removeElementAt(alreadyPresentIndex);
            this.addElement(anObject);
        }
        super.setSelectedItem(anObject);
    }

    @Override
    public void addElement(Object anObject) {
        if (this.myShowEmptyItem) {
            this.insertElementAt(anObject, 2);
        } else {
            this.insertElementAt(anObject, 1);
        }
    }

    @Override
    public void insertElementAt(Object anObject, int index) {
        if (!(anObject instanceof File)) {
            throw new IllegalArgumentException("This ComboBox accepts only Files.");
        }
        boolean selectionRemoved = false;
        int alreadyPresentIndex = this.getIndexOf(anObject);
        if (alreadyPresentIndex != -1) {
            if (anObject.equals(this.getSelectedItem())) {
                selectionRemoved = true;
            }
            super.removeElementAt(alreadyPresentIndex);
        }
        super.insertElementAt(anObject, index);
        if (this.getSize() > this.myMaxItems) {
            if (this.getElementAt(this.getSize() - 1).equals(this.getSelectedItem())) {
                selectionRemoved = true;
            }
            super.removeElementAt(this.getSize() - 1);
        }
        if (selectionRemoved) {
            this.setSelectedItem(anObject);
        }
        this.mySettings.setSequence(this.mySettingsKey, this.getValuesToStore());
    }

    @Override
    public void removeElementAt(int index) {
        if (this.myShowEmptyItem && index > 1 || !this.myShowEmptyItem && index > 0) {
            super.removeElementAt(index);
            this.mySettings.setSequence(this.mySettingsKey, this.getValuesToStore());
        }
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.mySettings.removeSequence(this.mySettingsKey);
        super.insertElementAt(THE_BROWSE_ITEM, 0);
        if (this.myShowEmptyItem) {
            super.insertElementAt(THE_EMPTY_ITEM, 0);
        }
    }
}

