/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.file;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.gui.common.file.FileComboBox;
import com.nokia.widgets.icons.CommonIcons;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;

public class FileComboBoxRenderer
extends DefaultListCellRenderer {
    private static final Border RENDERER_BORDER = BorderFactory.createEmptyBorder(4, 6, 4, 8);
    private static final ImageIcon theBrowseIcon = CommonIcons.getFolderOpenIcon();
    private static final String theBrowseText = I18n.getI18n().getBundle(FileComboBoxRenderer.class).getString("Common.Browse_Text");
    private static final String theBrowseTooltipText = I18n.getI18n().getBundle(FileComboBoxRenderer.class).getString("File.Browse_ToolTip_Text");
    private static final String theBrowseFolderTooltipText = I18n.getI18n().getBundle(FileComboBoxRenderer.class).getString("File.BrowseFolder_ToolTip_Text");
    protected FileComboBox.SELECTION_TYPE mySelectionType = FileComboBox.SELECTION_TYPE.FILE_SELECTION;

    public void setSelectionType(FileComboBox.SELECTION_TYPE selectionType) {
        this.mySelectionType = selectionType;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component renderedComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (renderedComponent instanceof JLabel) {
            JLabel renderedLabel = (JLabel)renderedComponent;
            renderedLabel.setBorder(RENDERER_BORDER);
            if (value instanceof File) {
                File file = (File)value;
                String name = file.getName();
                if (file.isDirectory() && (name == null || name.isEmpty())) {
                    name = file.toString();
                }
                renderedLabel.setText(name);
                renderedLabel.setToolTipText(file.getAbsolutePath());
            } else if ("Browse...".equals(value)) {
                renderedLabel.setIcon(theBrowseIcon);
                renderedLabel.setText(theBrowseText);
                if (this.mySelectionType.equals((Object)FileComboBox.SELECTION_TYPE.FILE_SELECTION)) {
                    renderedLabel.setToolTipText(theBrowseTooltipText);
                } else {
                    renderedLabel.setToolTipText(theBrowseFolderTooltipText);
                }
            } else {
                renderedLabel.setToolTipText(null);
            }
        }
        return renderedComponent;
    }
}

