/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.rules;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.common.actions.ContextSensitiveHelpAction;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.services.ui.action.ActionRule;
import com.nokia.em.poseidon.services.ui.action.PoseidonAction;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class ContextSensitiveHelpRule
extends ActionRule
implements PopupMenuListener {
    private final ResourceBundle myBundle = I18n.getI18n().getBaseBundle();
    private Action myCurrentHelpAction = null;
    private boolean myListenerAdded = false;

    public ContextSensitiveHelpRule() {
        PoseidonRuntime.getRuntime().getService(UserInterface.class).addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JMenuItem csHelp;
                if (!ContextSensitiveHelpRule.this.myListenerAdded && "ui_conf_loaded".equals(evt.getPropertyName()) && (csHelp = (JMenuItem)PoseidonRuntime.getRuntime().getService(UserInterface.class).getMenu().get(ContextSensitiveHelpAction.class.getSimpleName())) != null) {
                    ((JPopupMenu)csHelp.getParent()).addPopupMenuListener(ContextSensitiveHelpRule.this);
                    ContextSensitiveHelpRule.this.myListenerAdded = true;
                }
            }
        });
    }

    @Override
    public void updateAction(PoseidonAction action) {
        Object helpContextName = null;
        Object mnemonic = this.myBundle.getMnemonic("ContextSensitiveHelp_Mnemonic");
        Object tooltip = this.myBundle.getString("ContextSensitiveHelp_Tooltip");
        if (this.myCurrentHelpAction != null) {
            Object menuItemText = this.myCurrentHelpAction.getValue("Name");
            if (menuItemText == null || menuItemText.toString().length() == 0) {
                helpContextName = this.myBundle.getString("ContextSensitiveHelpDefault_Text");
            } else {
                helpContextName = menuItemText;
                if (this.myCurrentHelpAction.getValue("MnemonicKey") != null) {
                    mnemonic = this.myCurrentHelpAction.getValue("MnemonicKey");
                }
                if (this.myCurrentHelpAction.getValue("ShortDescription") != null) {
                    tooltip = this.myCurrentHelpAction.getValue("ShortDescription");
                }
            }
            action.putValue("Name", MessageFormat.format(this.myBundle.getString("ContextSensitiveHelp_Text"), helpContextName));
            action.putValue("MnemonicKey", mnemonic);
            action.putValue("ShortDescription", tooltip);
        }
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
        this.setVisible(true);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        this.setVisible(true);
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        PHelp help = PoseidonRuntime.getRuntime().getService(PHelp.class);
        this.myCurrentHelpAction = help.getCurrentContextSensitiveHelpAction();
        this.setVisible(this.myCurrentHelpAction != null);
    }
}

