/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.taskview;

import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PBorderFactory;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.layout.RowAlignLayout;
import java.awt.Component;
import java.lang.reflect.Method;
import javax.swing.AbstractButton;
import javax.swing.Icon;

public class PTaskViewButtonBar
extends PPanel {
    public PTaskViewButtonBar() {
        this(new AbstractButton[0]);
    }

    public PTaskViewButtonBar(AbstractButton[] buttons) {
        this.buildUI(buttons);
    }

    public void addButtons(AbstractButton[] buttons) {
        int i = 0;
        while (i < buttons.length) {
            this.add(buttons[i]);
            ++i;
        }
    }

    public void addButton(AbstractButton button) {
        this.add(button);
    }

    public void addButton(AbstractButton button, int index) {
        this.add((Component)button, index);
    }

    public void addFunctionButton(AbstractButton button) {
        this.add((Component)button, "West");
    }

    public void addFunctionButton(AbstractButton button, int index) {
        this.add(button, "West", index);
    }

    public void removeButton(int index) {
        this.remove(index);
    }

    public void removeButton(String text) {
        Component[] buttons = this.getComponents();
        int i = 0;
        while (i < buttons.length) {
            if (((AbstractButton)buttons[i]).getText().equals(text)) {
                this.remove(buttons[i]);
                return;
            }
            ++i;
        }
    }

    public void removeButton(AbstractButton button) {
        this.remove(button);
    }

    public void removeAllButtons() {
        this.removeAll();
    }

    public AbstractButton getButtonAt(int index) {
        Component[] buttons = this.getComponents();
        if (index < 0 || index > buttons.length - 1) {
            return null;
        }
        return (AbstractButton)buttons[index];
    }

    public AbstractButton getButtonByText(String text) {
        return this.getButtonByProperty("getText", text);
    }

    public AbstractButton getButtonByCommand(String command) {
        return this.getButtonByProperty("getActionCommand", command);
    }

    public AbstractButton getButtonByIcon(Icon icon) {
        return this.getButtonByProperty("getIcon", icon);
    }

    private AbstractButton getButtonByProperty(String getMethod, Object criteria) {
        Component[] buttons = this.getComponents();
        int i = 0;
        while (i < buttons.length) {
            try {
                AbstractButton button = (AbstractButton)buttons[i];
                Method getter = button.getClass().getMethod(getMethod, null);
                Object value = getter.invoke((Object)button, new Object[1]);
                if (criteria.equals(value)) {
                    return button;
                }
            }
            catch (Exception e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    private void buildUI(AbstractButton[] buttons) {
        RowAlignLayout layout = new RowAlignLayout();
        this.setLayout(layout);
        this.setBorder(PBorderFactory.getButtonBarBorder());
        this.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        int i = 0;
        while (i < buttons.length) {
            this.add(buttons[i]);
            ++i;
        }
    }
}

