/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.taskview;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PToggleToolButton;
import com.nokia.widgets.buttons.PToolButton;
import com.nokia.widgets.icons.PEmptyIcon;
import com.nokia.widgets.labels.PLabel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

public class PTaskViewHeadingBar
extends PPanel {
    private static final char END_OF_LINE_CHAR = '\n';
    private static final Insets HEADING_TEXT_LABEL_INSETS = new Insets(0, 12, 0, 0);
    private static final Insets ADDITIONAL_INFO_BUTTON_PANEL_INSETS = new Insets(0, 32, 0, 0);
    private static final int EMPTY_ICON_WIDTH = PEmptyIcon.ICON_20.getIconWidth();
    private static final int COMPONET_HGAP = 12;
    private PPanel myHeadingTextPanel;
    private PLabel myStatusTextLabel;
    private PLabel myAdditionInformationLabel;
    private boolean myAdditionalInfoAdded;
    private PPanel myComponentPanel = new PPanel();
    private boolean myComponentsAdded;
    private JProgressBar myProgressBar;
    private boolean myProgressBarAdded;
    private GridBagConstraints myConstraint = new GridBagConstraints();

    public PTaskViewHeadingBar(Icon headingIcon, String headingText, Action helpButtonAction) {
        this.buildUI(headingIcon, headingText, helpButtonAction);
    }

    public PTaskViewHeadingBar(Icon headingIcon, String headingText, final ActionListener helpButtonAction) {
        this(headingIcon, headingText, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                helpButtonAction.actionPerformed(e);
            }
        });
    }

    public void setAdditionalInfo(String additionalInfo) throws IllegalArgumentException {
        if (additionalInfo.indexOf(10) != additionalInfo.lastIndexOf(10)) {
            throw new IllegalArgumentException("Too many info lines. Max. 2 allowed.");
        }
        if (this.myAdditionalInfoAdded) {
            this.myAdditionInformationLabel.setText(additionalInfo);
            this.myAdditionInformationLabel.setToolTipText(additionalInfo);
            return;
        }
        this.remove(this.myHeadingTextPanel);
        this.addComponent(this.myHeadingTextPanel, 1, 0.0, HEADING_TEXT_LABEL_INSETS);
        this.myAdditionInformationLabel = new PLabel(additionalInfo);
        this.myAdditionInformationLabel.setToolTipText(additionalInfo);
        this.myAdditionInformationLabel.setAutoTooltipEnabled(true);
        if (this.myComponentsAdded) {
            this.addComponent(this.myAdditionInformationLabel, 2, 0.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        } else {
            this.addComponent(this.myAdditionInformationLabel, 2, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        }
        this.myAdditionalInfoAdded = true;
        if (this.myComponentsAdded) {
            this.remove(this.myComponentPanel);
            this.addComponent(this.myComponentPanel, 3, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        }
        if (this.myProgressBarAdded) {
            this.remove(this.myProgressBar);
            this.myProgressBarAdded = false;
            this.setProgressBar(this.myProgressBar);
        }
    }

    public void setStatusText(String text) {
        this.myStatusTextLabel.setText(text);
    }

    public void removeAdditionalInfo() {
        if (!this.myAdditionalInfoAdded) {
            return;
        }
        this.remove(this.myAdditionInformationLabel);
        this.myAdditionalInfoAdded = false;
        if (this.myComponentsAdded) {
            this.remove(this.myComponentPanel);
            this.addComponent(this.myComponentPanel, 2, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        } else {
            this.remove(this.myHeadingTextPanel);
            this.addComponent(this.myHeadingTextPanel, 1, 1.0, HEADING_TEXT_LABEL_INSETS);
        }
    }

    public void addComponentGroup(Component[] components) {
        int groupCount = this.myComponentPanel.getComponentCount();
        PPanel componentPanel = new PPanel();
        componentPanel.setLayout(new BoxLayout(componentPanel, 0));
        if (groupCount != 0) {
            this.myComponentPanel.add(Box.createHorizontalStrut(EMPTY_ICON_WIDTH));
        }
        int i = 0;
        while (i < components.length) {
            componentPanel.add(components[i]);
            if (i != components.length - 1 && !(components[i + 1] instanceof PToolButton) && !(components[i + 1] instanceof PToggleToolButton)) {
                componentPanel.add(Box.createHorizontalStrut(12));
            } else if (i != components.length - 1 && !(components[i] instanceof PToolButton) && !(components[i] instanceof PToggleToolButton)) {
                componentPanel.add(Box.createHorizontalStrut(12));
            }
            ++i;
        }
        this.myComponentPanel.add(componentPanel);
        if (groupCount == 0) {
            this.addComponentPanel();
        }
    }

    public void addComponentGroup(Component component) {
        Component[] components = new Component[]{component};
        this.addComponentGroup(components);
    }

    public void addComponents(Component[] components, int groupIndex) throws IllegalArgumentException {
        int componentCount;
        int groupCount = this.myComponentPanel.getComponentCount();
        int index = groupIndex;
        if (groupIndex != 0) {
            index = 2 * groupIndex;
        }
        if (index < 0 || index > groupCount - 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        PPanel componentPanel = (PPanel)this.myComponentPanel.getComponent(index);
        if (componentPanel.getComponent((componentCount = componentPanel.getComponentCount()) - 1) instanceof PToolButton || componentPanel.getComponent(componentCount - 1) instanceof PToggleToolButton) {
            if (!(components[0] instanceof PToolButton) && !(components[0] instanceof PToggleToolButton)) {
                componentPanel.add(Box.createHorizontalStrut(12));
            }
        } else {
            componentPanel.add(Box.createHorizontalStrut(12));
        }
        int i = 0;
        while (i < components.length) {
            componentPanel.add(components[i]);
            if (i != components.length - 1 && !(components[i + 1] instanceof PToolButton) && !(components[i + 1] instanceof PToggleToolButton)) {
                componentPanel.add(Box.createHorizontalStrut(12));
            } else if (i != components.length - 1 && !(components[i] instanceof PToolButton) && !(components[i] instanceof PToggleToolButton)) {
                componentPanel.add(Box.createHorizontalStrut(12));
            }
            ++i;
        }
    }

    public void addComponent(Component component, int groupIndex) throws IllegalArgumentException {
        Component[] components = new Component[]{component};
        this.addComponents(components, groupIndex);
    }

    public void removeComponentGroup(int groupIndex) throws IllegalArgumentException {
        if (!this.myComponentsAdded) {
            return;
        }
        int groupCount = this.myComponentPanel.getComponentCount();
        int index = groupIndex;
        if (groupIndex != 0) {
            index = 2 * groupIndex;
        }
        if (index < 0 || index > groupCount - 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        this.myComponentPanel.remove(index);
        if (this.myComponentPanel.getComponentCount() == 0) {
            this.removeComponentPanel();
            return;
        }
        if (index == groupCount - 1) {
            this.myComponentPanel.remove(index - 1);
        } else {
            this.myComponentPanel.remove(index);
        }
    }

    public void removeComponent(int componentIndex, int groupIndex) throws IllegalArgumentException {
        if (!this.myComponentsAdded) {
            return;
        }
        int groupCount = this.myComponentPanel.getComponentCount();
        int index = groupIndex;
        if (groupIndex != 0) {
            index = 2 * groupIndex;
        }
        if (index < 0 || index > groupCount - 1) {
            throw new IllegalArgumentException("Invalid index: " + index);
        }
        PPanel componentPanel = (PPanel)this.myComponentPanel.getComponent(index);
        int componentCount = componentPanel.getComponentCount();
        Component[] components = componentPanel.getComponents();
        int fillersCount = 0;
        int i = 0;
        while (i < componentCount) {
            if (components[i] instanceof Box.Filler) {
                ++fillersCount;
            }
            ++i;
        }
        int actualComponentCount = componentCount - fillersCount;
        if (componentIndex < 0 || componentIndex > actualComponentCount - 1) {
            throw new IllegalArgumentException("Invalid index: " + componentIndex);
        }
        int actualComponentIndex = 0;
        actualComponentCount = 0;
        int i2 = 0;
        while (i2 < componentCount) {
            if (!(components[i2] instanceof Box.Filler)) {
                if (actualComponentCount == componentIndex) {
                    actualComponentIndex = i2;
                    break;
                }
                ++actualComponentCount;
            }
            ++i2;
        }
        componentPanel.remove(actualComponentIndex);
        if (componentPanel.getComponentCount() == 0) {
            this.removeComponentGroup(groupIndex);
            return;
        }
        if (actualComponentIndex == 0) {
            if (componentPanel.getComponent(actualComponentIndex) instanceof Box.Filler) {
                componentPanel.remove(actualComponentIndex);
            }
        } else if (actualComponentIndex == componentCount - 1) {
            if (componentPanel.getComponent(actualComponentIndex) instanceof Box.Filler) {
                componentPanel.remove(actualComponentIndex);
            }
        } else if (componentPanel.getComponent(actualComponentIndex) instanceof Box.Filler && componentPanel.getComponent(actualComponentIndex - 1) instanceof Box.Filler) {
            componentPanel.remove(actualComponentIndex);
        }
    }

    public void removeAllGroups() {
        if (!this.myComponentsAdded) {
            return;
        }
        this.myComponentPanel.removeAll();
        this.remove(this.myComponentPanel);
        this.myComponentsAdded = false;
        if (this.myAdditionalInfoAdded) {
            this.remove(this.myAdditionInformationLabel);
            this.addComponent(this.myAdditionInformationLabel, 2, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        } else {
            this.remove(this.myHeadingTextPanel);
            this.addComponent(this.myHeadingTextPanel, 1, 1.0, HEADING_TEXT_LABEL_INSETS);
        }
    }

    public void setProgressBar(JProgressBar progressBar) {
        if (this.myProgressBarAdded) {
            return;
        }
        this.myProgressBar = progressBar;
        Insets insets = new Insets(0, 32, 0, 0);
        int gridx = this.myAdditionalInfoAdded ? (this.myComponentsAdded ? 4 : 3) : (this.myComponentsAdded ? 3 : 2);
        this.addComponent(this.myProgressBar, gridx, 0.0, insets);
        this.myProgressBarAdded = true;
    }

    public JProgressBar getProgressBar() {
        return this.myProgressBar;
    }

    public void removeProgressBar() {
        if (!this.myProgressBarAdded) {
            return;
        }
        this.remove(this.myProgressBar);
        this.myProgressBarAdded = false;
    }

    private void buildUI(Icon headingIcon, String headingText, Action helpButtonAction) {
        GridBagLayout layout = new GridBagLayout();
        this.setLayout(layout);
        JLabel headingIconLabel = new JLabel(new PEmptyIcon());
        this.addComponent(headingIconLabel, 0, 0.0, new Insets(11, 5, 11, 0));
        PLabel headingTextLabel = PLabel.createHeader(headingText);
        this.myStatusTextLabel = PLabel.createSubHeader();
        this.myComponentPanel.setLayout(new FlowLayout(0, 0, 0));
        this.myComponentPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        this.myHeadingTextPanel = new PPanel(new FlowLayout(0, 0, 0));
        this.myHeadingTextPanel.add(headingTextLabel);
        this.myHeadingTextPanel.add(this.myStatusTextLabel);
        this.myHeadingTextPanel.setBorder(BorderFactory.createEmptyBorder(6, 0, 4, 0));
        this.addComponent(this.myHeadingTextPanel, 1, 1.0, HEADING_TEXT_LABEL_INSETS);
        PHelp help = PoseidonRuntime.getRuntime().getService(PHelp.class);
        help.addContextSensitiveHelpAction(this, helpButtonAction);
    }

    private void addComponentPanel() {
        if (this.myAdditionalInfoAdded) {
            this.remove(this.myAdditionInformationLabel);
            this.addComponent(this.myAdditionInformationLabel, 2, 0.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
            this.addComponent(this.myComponentPanel, 3, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        } else {
            this.remove(this.myHeadingTextPanel);
            this.addComponent(this.myHeadingTextPanel, 1, 0.0, HEADING_TEXT_LABEL_INSETS);
            this.addComponent(this.myComponentPanel, 2, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        }
        this.myComponentsAdded = true;
        if (this.myProgressBarAdded) {
            this.remove(this.myProgressBar);
            this.myProgressBarAdded = false;
            this.setProgressBar(this.myProgressBar);
        }
    }

    private void removeComponentPanel() {
        this.remove(this.myComponentPanel);
        this.myComponentsAdded = false;
        if (this.myAdditionalInfoAdded) {
            this.remove(this.myAdditionInformationLabel);
            this.addComponent(this.myAdditionInformationLabel, 2, 1.0, ADDITIONAL_INFO_BUTTON_PANEL_INSETS);
        } else {
            this.remove(this.myHeadingTextPanel);
            this.addComponent(this.myHeadingTextPanel, 1, 1.0, HEADING_TEXT_LABEL_INSETS);
        }
    }

    private void addComponent(JComponent comp, int gridx, double weightx, Insets insets) {
        this.myConstraint.gridx = gridx;
        this.myConstraint.weightx = weightx;
        this.myConstraint.anchor = 17;
        this.myConstraint.insets = insets;
        this.add((Component)comp, this.myConstraint);
    }
}

