/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.common.uifield;

import com.nokia.em.poseidon.gui.common.uifield.UiFieldAdapter;
import com.nokia.widgets.PComboBox;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.text.PTextField;
import com.nokia.widgets.util.ClientPropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemListener;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentListener;

public abstract class UiField<T extends JComponent> {
    protected UiFieldAdapter<?> myUiFieldAdapter;
    PLabel myLabel = PLabel.createSystemText();
    protected T myFieldComponent;
    PLabel myRangeLabel = PLabel.createRangeLabel();
    String myUnitRangePattern = "{0} ({1}...{2})";
    String myRangePattern = "({1}...{2})";
    String myUnit;
    Object myMinimum;
    Object myMaximum;

    public static UiField<JCheckBox> createCheckBox(String name) {
        return new CheckBoxUiField(new JCheckBox(), name);
    }

    public static UiField<JTextField> createTextField(String labelKey, String name, int col, boolean mandatory) {
        PTextField textField = new PTextField(col);
        textField.setMandatoryEntry(mandatory);
        return new TextFieldUiField(labelKey, textField, name);
    }

    public static UiField<PComboBox> createComboBox(String labelKey, String name, Object[] objects) {
        return new ComboBoxUiField(labelKey, new PComboBox(objects), name);
    }

    public UiField() {
    }

    public UiField(String labelName, T component) {
        this(labelName, component, null, null, null, null);
    }

    public UiField(String labelName, T component, String compName) {
        this(labelName, component, compName, null, null, null);
    }

    public UiField(String labelName, T component, String compName, String unit, Object min, Object max) {
        this.myLabel.setName(labelName);
        this.myFieldComponent = component;
        ((Component)this.myFieldComponent).setName(compName);
        this.myLabel.setLabelFor((Component)this.myFieldComponent);
        this.myMinimum = min;
        this.myMaximum = max;
        this.myUnit = unit;
        this.createRangeText();
    }

    public T getField() {
        return this.myFieldComponent;
    }

    public PLabel getLabel() {
        return this.myLabel;
    }

    public PLabel getRangeLabel() {
        return this.myRangeLabel;
    }

    public Object getMinValue() {
        return this.myMinimum;
    }

    public Object getMaxValue() {
        return this.myMaximum;
    }

    public void setMinValue(Object min) {
        if (min != this.myMinimum) {
            this.myMinimum = min;
            this.createRangeText();
        }
    }

    public void setMaxValue(Object max) {
        if (max != this.myMaximum) {
            this.myMaximum = max;
            this.createRangeText();
        }
    }

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public void dispose() {
        this.uninstallListener();
    }

    public abstract void installListener();

    public abstract void uninstallListener();

    public String getValueAsString() {
        Object value = this.getValue();
        return value != null ? value.toString() : "";
    }

    public boolean isRequiredButMissing() {
        if (((Component)this.myFieldComponent).getParent() == null) {
            return false;
        }
        return ClientPropertyUtil.booleanValue(this.myFieldComponent, "requiredButMissing");
    }

    public boolean isInvalidOrMissing() {
        if (((Component)this.myFieldComponent).getParent() == null) {
            return false;
        }
        return this.isRequiredButMissing() || ClientPropertyUtil.booleanValue(this.myFieldComponent, "invalidEntry");
    }

    public void clear() {
    }

    public void setToolTipText(String text) {
        ((JComponent)this.myFieldComponent).setToolTipText(text);
    }

    public void setAdapter(UiFieldAdapter listener) {
        this.myUiFieldAdapter = listener;
        this.installListener();
    }

    public boolean validate(boolean showError) {
        if (this.myUiFieldAdapter != null) {
            return this.myUiFieldAdapter.validate(this, showError);
        }
        return true;
    }

    public void refresh() {
        this.updateModifiedIndicator();
    }

    private void updateModifiedIndicator() {
    }

    public void setVisible(boolean visible) {
        UiField.nullSafeSetVisible(this.myLabel, visible);
        UiField.nullSafeSetVisible(this.myFieldComponent, visible);
        UiField.nullSafeSetVisible(this.myRangeLabel, visible);
    }

    public void setEnabled(boolean enabled) {
        UiField.nullSafeSetEnabled(this.myLabel, enabled);
        UiField.nullSafeSetEnabled(this.myFieldComponent, enabled);
        UiField.nullSafeSetEnabled(this.myRangeLabel, enabled);
    }

    public void requestFocusInWindow() {
        ((JComponent)this.myFieldComponent).requestFocusInWindow();
    }

    public void addLabelToPanel(JPanel container, Object constraints) {
        container.add((Component)this.myLabel, constraints);
    }

    public void addFieldToPanel(JPanel container, Object constraints) {
        container.add((Component)this.myFieldComponent, constraints);
    }

    public void addRangeToPanel(JPanel container, Object constraints) {
        container.add((Component)this.myRangeLabel, constraints);
    }

    public void addUiField(Container container, Object ... constraints) {
        container.add(this.myLabel);
        container.add((Component)this.myFieldComponent, "growx");
        container.add((Component)this.myRangeLabel, "wrap");
    }

    protected <U> U createFieldChangeHandler(Class<U> listenerClass) {
        return (U)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                return null;
            }
        });
    }

    private void createRangeText() {
        String text = "";
        text = this.myUnit != null ? MessageFormat.format(this.myUnitRangePattern, this.myUnit, this.myMinimum, this.myMaximum) : MessageFormat.format(this.myRangePattern, this.myMinimum, this.myMaximum);
        this.myRangeLabel.setText(text);
    }

    private static void nullSafeSetEnabled(Component comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
        }
    }

    private static void nullSafeSetVisible(Component comp, boolean visible) {
        if (comp != null) {
            comp.setVisible(visible);
        }
    }

    public static class CheckBoxUiField
    extends UiField<JCheckBox> {
        private ItemListener myListener;

        public CheckBoxUiField(JCheckBox checkBox, String name) {
            super(null, checkBox, name);
        }

        @Override
        public void installListener() {
            this.myListener = this.createFieldChangeHandler(ItemListener.class);
            ((JCheckBox)this.myFieldComponent).addItemListener(this.myListener);
        }

        @Override
        public void uninstallListener() {
            ((JCheckBox)this.myFieldComponent).removeItemListener(this.myListener);
        }

        @Override
        public Object getValue() {
            return ((JCheckBox)this.myFieldComponent).isSelected();
        }

        @Override
        public void setValue(Object value) {
            ((JCheckBox)this.myFieldComponent).setSelected(Boolean.TRUE.equals(value) || "true".equalsIgnoreCase(value.toString()));
        }
    }

    public static class ComboBoxUiField
    extends UiField<PComboBox> {
        private ItemListener myListener;

        public ComboBoxUiField(String labelKey, PComboBox comboBox, String name) {
            super(null, comboBox, name);
        }

        @Override
        public void installListener() {
            this.myListener = this.createFieldChangeHandler(ItemListener.class);
            ((PComboBox)this.myFieldComponent).addItemListener(this.myListener);
        }

        @Override
        public void uninstallListener() {
            ((PComboBox)this.myFieldComponent).removeItemListener(this.myListener);
        }

        @Override
        public Object getValue() {
            return ((PComboBox)this.myFieldComponent).getSelectedItem();
        }

        @Override
        public void setValue(Object value) {
            ((PComboBox)this.myFieldComponent).setSelectedItem(value);
        }
    }

    public static class SpinnerUiField
    extends UiField<JSpinner> {
        private ChangeListener myListener;

        @Override
        public void installListener() {
            this.myListener = this.createFieldChangeHandler(ChangeListener.class);
            ((JSpinner)this.myFieldComponent).addChangeListener(this.myListener);
        }

        @Override
        public void uninstallListener() {
            ((JSpinner)this.myFieldComponent).removeChangeListener(this.myListener);
        }

        @Override
        public Object getValue() {
            return ((JSpinner)this.myFieldComponent).getValue();
        }

        @Override
        public void setValue(Object value) {
            ((JSpinner)this.myFieldComponent).setValue(value);
        }
    }

    public static class TextFieldUiField
    extends UiField<JTextField> {
        private DocumentListener myListener;

        public TextFieldUiField(String labelKey, PTextField textField, String name) {
            super(labelKey, textField, name);
        }

        @Override
        public void installListener() {
            this.myListener = this.createFieldChangeHandler(DocumentListener.class);
            if (this.myFieldComponent instanceof PTextField) {
                ((PTextField)this.myFieldComponent).addDocumentListener(this.myListener);
            } else {
                ((JTextField)this.myFieldComponent).getDocument().addDocumentListener(this.myListener);
            }
        }

        @Override
        public void uninstallListener() {
            ((JTextField)this.myFieldComponent).getDocument().removeDocumentListener(this.myListener);
        }

        @Override
        public Object getValue() {
            return ((JTextField)this.myFieldComponent).getText();
        }

        @Override
        public void setValue(Object value) {
            ((JTextField)this.myFieldComponent).setText(value != null ? value.toString() : "");
        }
    }
}

