/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.util.PSettings;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;

public class PLicenceComboModel
extends DefaultComboBoxModel {
    protected PSettings mySettings;
    protected int myMaxItems;
    protected String mySettingsKey;
    protected boolean myShowEmptyItem;

    public PLicenceComboModel(PSettings settings, String settingsKey, int maxItems, boolean showEmptyItem) {
        String[] valuesFromSettings;
        this.mySettings = settings;
        this.mySettingsKey = settingsKey;
        this.myMaxItems = maxItems;
        this.myShowEmptyItem = showEmptyItem;
        if (this.myShowEmptyItem) {
            String empty = " ";
            super.insertElementAt(empty, 0);
            this.setSelectedItem(empty);
        }
        String[] stringArray = valuesFromSettings = this.mySettings.getSequence(this.mySettingsKey, new String[0]);
        int n = valuesFromSettings.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            super.addElement(new File(path));
            ++n2;
        }
    }

    protected String[] getValuesToStore() {
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < this.getSize()) {
            Object element = this.getElementAt(i);
            if (element instanceof File) {
                values.add(((File)element).getAbsolutePath());
            }
            ++i;
        }
        return values.toArray(new String[values.size()]);
    }

    @Override
    public void addElement(Object anObject) {
        if (this.myShowEmptyItem) {
            this.insertElementAt(anObject, 1);
        } else {
            this.insertElementAt(anObject, 0);
        }
    }

    @Override
    public void insertElementAt(Object anObject, int index) {
        if (!(anObject instanceof File)) {
            throw new IllegalArgumentException("This ComboBox accepts only Files.");
        }
        boolean selectionRemoved = false;
        int alreadyPresentIndex = this.getIndexOf(anObject);
        if (alreadyPresentIndex != -1) {
            if (anObject.equals(this.getSelectedItem())) {
                selectionRemoved = true;
            }
            super.removeElementAt(alreadyPresentIndex);
        }
        super.insertElementAt(anObject, index);
        if (this.getSize() > this.myMaxItems) {
            if (this.getElementAt(this.getSize() - 1).equals(this.getSelectedItem())) {
                selectionRemoved = true;
            }
            super.removeElementAt(this.getSize() - 1);
        }
        if (selectionRemoved) {
            this.setSelectedItem(anObject);
        }
        this.mySettings.setSequence(this.mySettingsKey, this.getValuesToStore());
    }

    @Override
    public void removeElementAt(int index) {
        if (index != 0 || !this.myShowEmptyItem) {
            super.removeElementAt(index);
            this.mySettings.setSequence(this.mySettingsKey, this.getValuesToStore());
        }
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        this.mySettings.removeSequence(this.mySettingsKey);
        if (this.myShowEmptyItem) {
            super.insertElementAt(" ", 0);
        }
    }
}

