/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.ftp.FtpConnectionInfo;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.frameworks.mvc.ControllerEvent;
import com.nokia.em.poseidon.gui.licence.PLicenceChangeListener;
import com.nokia.em.poseidon.gui.licence.PLicenceOptionsController;
import com.nokia.em.poseidon.gui.licence.PLicenceValidator;
import com.nokia.em.poseidon.gui.licence.PLicenceView;
import com.nokia.em.poseidon.services.help.PHelp;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.services.licence.PLicenceService;
import com.nokia.em.poseidon.services.licence.PLicenceServiceImpl;
import com.nokia.widgets.progress.models.ProgressBarModel;
import java.awt.Window;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;

public class PLicenceController
extends ControllerBase
implements PLicenceChangeListener {
    private PLicenceView myLicenceView;
    private Logger myLogger;
    private ResourceBundle myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    private PLicenceService myService;
    private int myMediatorsCount;
    private int myMediatorsSendLicences;
    private String myUploadPath;
    private String myTargetId = "-";
    private String myElementName;
    private boolean myIsSnapshotMode = true;
    private boolean myIsReadOnlyMode = false;

    public PLicenceController() {
        this.myLogger = Logger.getLogger(this.getClass());
        this.myService = PoseidonRuntime.getRuntime().getService(PLicenceService.class);
        if (this.myService == null) {
            this.myService = new PLicenceServiceImpl();
        }
        this.myLogger.info("Licence Management initialized.");
    }

    protected boolean[] areOperationsSupported(List<PLicence> selectedLicences) {
        return this.myService.areOperationsSupported(selectedLicences);
    }

    public String getTargetId() {
        return this.myTargetId;
    }

    public void setTargetId(String targetId) {
        this.myTargetId = targetId;
    }

    public String getManagedElementName() {
        return this.myElementName;
    }

    public void setManagedElementName(String elementName) {
        this.myElementName = elementName;
    }

    public void initView() {
        if (this.myService != null) {
            this.myLicenceView = new PLicenceView(this);
            this.myLicenceView.showActivateFunctionality(this.myService.isActivateSupported(null));
            this.myLicenceView.showDeactivateFunctionality(this.myService.isDeactivateSupported(null));
            this.myLicenceView.showUploadFunctionality(this.myService.isUploadSupported(null));
            this.myLicenceView.showRemoteServerFunctionality(this.myService.remoteServerVisible());
            this.myLicenceView.pack();
            this.setView(this.myLicenceView);
            this.myService.addLicenceChangeListener(this);
            this.myMediatorsCount = this.myService.getMediatorCount();
            this.myMediatorsSendLicences = 0;
            this.myService.requestLicences();
            this.myLicenceView.setTargetId(this.myTargetId);
            this.myLicenceView.setVisible(true);
        }
    }

    protected boolean downloadLicence(PLicence licence, ProgressBarModel progressModel) {
        return this.myService.downloadLicence(licence, progressModel);
    }

    protected void uploadLicence(String path, List<PLicence> licences, ProgressBarModel progressModel) {
        this.myUploadPath = path;
        this.myService.uploadLicences(licences, progressModel);
        this.myLogger.debug("Licence file uploading started. File(s): " + this.licenceFileNamesToString(licences));
    }

    protected void deleteLicence(List<PLicence> licences, ProgressBarModel progressModel) {
        this.myService.deleteLicence(licences, progressModel);
        this.myLogger.debug("Licence file deleting started. File(s): " + this.licenceFileNamesToString(licences));
    }

    protected void activateLicence(List<PLicence> licences) {
        this.myService.activateLicences(licences);
        this.myLogger.debug("Licence file activating started. File(s): " + this.licenceFileNamesToString(licences));
    }

    protected void deactivateLicence(List<PLicence> licences) {
        this.myService.deactivateLicences(licences);
        this.myLogger.debug("Licence file deactivating started. File(s): " + this.licenceFileNamesToString(licences));
    }

    private String licenceFileNamesToString(List<PLicence> licences) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PLicence lic : licences) {
            stringBuilder.append(String.valueOf(lic.getFileId()) + ", ");
        }
        String names = stringBuilder.toString();
        if (names.length() > 2) {
            return names.substring(0, names.length() - 2);
        }
        return names;
    }

    @Override
    public void removeLicences(String elementType) {
        this.myLicenceView.removeLicences(elementType);
    }

    public void setSnapshotMode(boolean value) {
        this.myIsSnapshotMode = value;
    }

    public boolean isSnapshotMode() {
        return this.myIsSnapshotMode;
    }

    public void setReadOnlyMode(boolean value) {
        this.myIsReadOnlyMode = value;
    }

    public boolean isReadOnlyMode() {
        return this.myIsReadOnlyMode;
    }

    @Override
    public Collection<PLicence> getLicences() {
        return this.myLicenceView.getExistingLicences();
    }

    @Override
    public void deleteCompleted() {
        this.myLogger.debug("Licence file deletion completed.");
        this.myService.notifyLicenceDeleted(this.myLicenceView.getOperatedLicence());
        this.myLicenceView.deleteCompleted();
    }

    @Override
    public void uploadingCompleted(List<PLicence> licences) {
        PLicence uploadedLic = licences.get(0);
        File licenceFile = uploadedLic.getLicenceFile();
        if (licenceFile != null) {
            licenceFile.renameTo(new File(this.myUploadPath));
        }
        this.myLogger.debug("Licence file uploading completed.");
        this.myLicenceView.uploadCompleted(this.myService.isLicenceRemovedInUpload(uploadedLic));
    }

    @Override
    public void downloadingCompleted() {
        this.myLogger.debug("Licence file download completed.");
        this.myService.notifyLicenceDownloaded(this.myLicenceView.getCurrentDownloadableLicence());
        this.myLicenceView.downloadCompleted();
    }

    @Override
    public void activatingCompleted() {
        this.myLogger.debug("Licence file activating completed");
        this.myService.notifyLicenceActivated(this.myLicenceView.getOperatedLicence());
        this.myLicenceView.activateCompleted();
    }

    @Override
    public void deactivatingCompleted() {
        this.myLogger.debug("Licence file deactivating completed");
        this.myService.notifyLicenceDeactivated(this.myLicenceView.getOperatedLicence());
        this.myLicenceView.deactivateCompleted();
    }

    public boolean isLicenceRemovedInUpload(PLicence licence) {
        return this.myService.isLicenceRemovedInUpload(licence);
    }

    @Override
    public void addLicences(List<PLicence> licences) {
        ++this.myMediatorsSendLicences;
        this.myLicenceView.updateLicenceTable(licences);
        if (this.myMediatorsSendLicences >= this.myMediatorsCount) {
            this.myLicenceView.allLicencesGetNotify();
        }
        this.myService.notifyLicencesUpdated(licences);
    }

    @Override
    public void operationFailed(int type, String element, String fileName) {
        this.myLicenceView.operationFailed(type, element, fileName);
        String headLine = "";
        Object[] params = new Object[]{fileName, element};
        switch (type) {
            case 1: {
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Download_HeadLine");
                break;
            }
            case 2: {
                headLine = this.myResourceBundle.getString("PLicenceView.Licence_Exists_HeadLine");
                break;
            }
            case 3: {
                headLine = this.myResourceBundle.getString("PLicenceView.Code_Unknown_HeadLine");
                break;
            }
            case 4: {
                headLine = this.myResourceBundle.getString("PLicenceView.Invalid_Licence_HeadLine");
                break;
            }
            case 5: {
                headLine = this.myResourceBundle.getString("PLicenceView.Another_Element_HeadLine");
                break;
            }
            case 6: {
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Activate_HeadLine");
                break;
            }
            case 7: {
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Deactivate_HeadLine");
                break;
            }
            case 8: {
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Delete_HeadLine");
                break;
            }
            case 9: {
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Upload_HeadLine");
                break;
            }
        }
        this.myLogger.debug(headLine);
    }

    @Override
    public void operationFailed(int type, String title, String headline, Object message) {
        this.myLicenceView.operationFailed(type, title, headline, message);
        this.myLogger.debug(headline);
    }

    protected void licenceViewHelpRequested() {
        String helpId = this.myResourceBundle.getString("PLicenceView.ViewContextSensitiveHelp_Text");
        PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp((Window)((Object)this.getView()), helpId);
    }

    public void openOptionsRequest() {
        try {
            new PLicenceOptionsController(this, this.myLicenceView, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void controllerDestroyed(ControllerEvent event) {
    }

    public void controllerCreated(ControllerEvent event) {
    }

    public void updateTransferInfoRequest(FtpConnectionInfo swTransferInfo) {
        this.myLicenceView.updateTransferInfoRequest(swTransferInfo);
    }

    @Override
    public void addLicenceFileValidator(PLicenceValidator validator) {
        this.myLicenceView.setLicenceFileValidator(validator);
    }
}

