/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.gui.common.file.AccessoryFileChooser;
import com.nokia.em.poseidon.gui.licence.PLicenceDetailsView;
import com.nokia.em.poseidon.gui.licence.PLicenceFileChooserUI;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.util.file.PFileFilter;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.text.TimestampFormatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class PLicenceFileChooser
extends AccessoryFileChooser {
    protected PLicenceDetailsView myLicenceDetailsView;
    private ResourceBundle myResourceBundle;
    protected final JLabel myMessageLabel = new JLabel();
    protected JPanel myLicencePanel;
    protected final DateFormat DATE_FORMAT = TimestampFormatter.getShortFormatter();
    PLicence myCurrentLicence;

    static {
        UIManager.put("LicenceFileChooserUI", PLicenceFileChooserUI.class.getName());
    }

    public PLicenceFileChooser(File currentDirectory, String title) {
        super(currentDirectory);
        this.myLicenceDetailsView = new PLicenceDetailsView();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.setDialogTitle(title);
        this.setInvalidFileDetails();
        this.setFileDetailsPanel();
        this.setAccessory(this.myLicencePanel);
        PFileFilter fileFilter = new PFileFilter("xml", "XML Files (*.xml)");
        this.setFileFilter(fileFilter);
        this.setAcceptAllFileFilterUsed(false);
    }

    private void setInvalidFileDetails() {
        this.myMessageLabel.setForeground(Color.BLACK);
        this.myMessageLabel.setText(this.myResourceBundle.getString("PLicenceView.invalidFile"));
        this.myMessageLabel.setHorizontalAlignment(0);
        this.myMessageLabel.setPreferredSize(new Dimension(285, 245));
        this.myLicencePanel = new JPanel(new BorderLayout());
    }

    private void setFileDetailsPanel() {
        PLabel detailsLabel = new PLabel(this.myResourceBundle.getString("PLicenceView.detailsTitle"));
        detailsLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        this.myLicencePanel.add((Component)detailsLabel, "North");
        this.myLicencePanel.add(new JScrollPane(this.myLicenceDetailsView));
        this.myLicencePanel.setBorder(new EmptyBorder(0, 12, 0, 12));
        this.myLicencePanel.setPreferredSize(new Dimension(350, 250));
    }

    @Override
    public String getUIClassID() {
        return "LicenceFileChooserUI";
    }

    protected void setCurrentLicence(PLicence licence) {
        if (licence == null) {
            throw new IllegalArgumentException("Licence is null.");
        }
        this.myCurrentLicence = licence;
        this.setAccessory(this.myLicencePanel);
        this.myLicenceDetailsView.clear();
        Collection<String> featureNames = this.myCurrentLicence.getFeatureNames();
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.featureName"), featureNames);
        Set<String> features = this.myCurrentLicence.getFeatureCodes();
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.featureCode"), features);
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.fileName"), this.myCurrentLicence.getLicenceFile() != null ? this.myCurrentLicence.getLicenceFile().getName() : "");
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.LicenseCode"), this.myCurrentLicence.getLicenceCode());
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.targetElement"), this.myCurrentLicence.getElementType());
        List<String> targetIds = this.myCurrentLicence.getElementCodes();
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.targetId"), targetIds);
        Calendar startTime = this.myCurrentLicence.getStartTime();
        String startDate = null;
        if (startTime != null) {
            startDate = this.DATE_FORMAT.format(startTime.getTime());
        }
        Calendar endTime = this.myCurrentLicence.getEndTime();
        String endDate = null;
        if (endTime != null) {
            endDate = this.DATE_FORMAT.format(endTime.getTime());
        }
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.startTime"), startDate);
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.endTime"), endDate);
        long capacity = this.myCurrentLicence.getCapacity();
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.capacity"), capacity < 0L ? this.myResourceBundle.getString("NotApplicable_Text") : String.valueOf(capacity));
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.customerName"), this.myCurrentLicence.getCustomerName());
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.customerId"), this.myCurrentLicence.getCustomerId());
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.orderId"), this.myCurrentLicence.getOrderId());
        this.myLicenceDetailsView.addData(this.myResourceBundle.getString("PLicenceView.serialNumber"), this.myCurrentLicence.getSerialNumber());
        this.revalidate();
        this.repaint();
    }

    protected void showInvalidFileMessage() {
        this.myCurrentLicence = null;
        this.myLicencePanel.removeAll();
        this.myLicenceDetailsView.clear();
        this.myLicenceDetailsView.add(this.myMessageLabel);
        this.setFileDetailsPanel();
        this.setAccessory(this.myLicencePanel);
        this.revalidate();
        this.repaint();
    }
}

