/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.gui.common.file.FileChooserBase;
import com.nokia.em.poseidon.gui.licence.PLicenceFileChooser;
import com.nokia.em.poseidon.gui.licence.PLicenceValidationMessage;
import com.nokia.em.poseidon.gui.licence.PLicenceValidator;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.services.licence.PLicenceParser;
import com.nokia.widgets.balloon.Balloon;
import com.nokia.widgets.labels.PStaticLabel;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PLicenceModifiedOpen
extends PLicenceFileChooser
implements PropertyChangeListener {
    private PLicenceValidator myLicenceValidator;
    private static FileChooserBase.ComponentFilter APPROVEBUTTON_FILTER_LICENCE = new FileChooserBase.ComponentFilter(){

        @Override
        public boolean accept(Component comp) {
            if (comp instanceof AbstractButton) {
                String buttonText = ((AbstractButton)comp).getText();
                return buttonText != null && buttonText.equals(UIManager.getString((Object)"FileChooser.openButtonText", null));
            }
            return false;
        }
    };
    private static FileChooserBase.ComponentFilter FILENAMEFIELD_FILTER = new FileChooserBase.ComponentFilter(){

        @Override
        public boolean accept(Component comp) {
            return comp instanceof JTextField && !(comp.getParent() instanceof PStaticLabel);
        }
    };

    public PLicenceModifiedOpen(File currentDirectory, String title) {
        super(currentDirectory, title);
        this.myApproveButton = (JComponent)this.searchComponents(APPROVEBUTTON_FILTER_LICENCE);
        this.addPropertyChangeListener(this);
    }

    public void setLicenceValidator(PLicenceValidator validator) {
        this.myLicenceValidator = validator;
    }

    public PLicence open(Component parent) {
        int type = this.showOpenDialog(parent);
        if (type == 0) {
            return this.myCurrentLicence;
        }
        return null;
    }

    @Override
    public void approveSelection() {
        PLicenceValidationMessage message = null;
        if (this.myLicenceValidator != null && (message = this.myLicenceValidator.validateLicence(this.getSelectedFile())) != null) {
            this.showBalloonForInvalidFileName(message);
        } else {
            super.approveSelection();
        }
    }

    public final Component searchComponents(FileChooserBase.ComponentFilter filter) {
        Component component = null;
        Component[] componentArray = this.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component comp = componentArray[n2];
            component = this.searchComponent(comp, filter);
            if (component != null) {
                return component;
            }
            ++n2;
        }
        return component;
    }

    private Component searchComponent(Component component, FileChooserBase.ComponentFilter filter) {
        Component result = null;
        if (filter.accept(component)) {
            result = component;
        } else if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component comp = componentArray[n2];
                result = this.searchComponent(comp, filter);
                if (result != null) {
                    return result;
                }
                ++n2;
            }
        }
        return result;
    }

    protected void showBalloonForInvalidFileName(PLicenceValidationMessage message) {
        if (this.myBalloon != null) {
            this.myBalloon.close();
        }
        this.myBalloon = new Balloon((JComponent)this.searchComponents(FILENAMEFIELD_FILTER), SwingUtilities.getWindowAncestor(this), message.getMessage(), message.getHeadLine(), 0, 0);
        this.myBalloon.showBalloon();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isShowing()) {
            return;
        }
        String prop = evt.getPropertyName();
        if ("SelectedFileChangedProperty".equals(prop)) {
            File newFile;
            if (this.myBalloon != null) {
                this.myBalloon.close();
                this.myBalloon = null;
            }
            if ((newFile = (File)evt.getNewValue()) == null) {
                this.setApproveButtonEnabled(true);
                return;
            }
            this.showLicenseDetails(newFile);
        } else if ("ApproveButtonTextChangedProperty".equals(prop)) {
            this.myApproveButton = (JComponent)this.searchComponents(APPROVEBUTTON_FILTER_LICENCE);
        }
    }

    @Override
    protected JDialog createDialog(Component parent) throws HeadlessException {
        JDialog dialog = super.createDialog(parent);
        File selectedFile = this.getSelectedFile();
        if (selectedFile == null) {
            this.setApproveButtonEnabled(false);
        }
        if (this.checkOpenFile(selectedFile)) {
            this.showLicenseDetails(selectedFile);
        }
        return dialog;
    }

    private void showLicenseDetails(File file) {
        try {
            PLicence licence = PLicenceParser.parse(file);
            if (licence.getSerialNumber() == null) {
                this.showInvalidFileMessage();
                this.setApproveButtonEnabled(false);
                return;
            }
            this.setCurrentLicence(licence);
            this.setApproveButtonEnabled(true);
        }
        catch (Exception exc) {
            this.showInvalidFileMessage();
            this.setApproveButtonEnabled(false);
        }
    }
}

