/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.licence.PLicenceOptionsController;
import com.nokia.em.poseidon.gui.licence.PLicenceView;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.text.PTextField;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class PLicenceOptionsView
extends JDialogViewBase {
    private PLicenceOptionsController myLicenceOptionsController;
    private ResourceBundle myResourceBundle;
    private JCheckBox myRemoteServerCheckBox = new JCheckBox();
    private JButton myOkButton = new JButton();
    private JButton myCancelButton = new JButton();
    private PHelpButton myHelpButton;
    private PTextField myHostField = new PTextField();
    private JPasswordField myPasswordField = new JPasswordField();
    private PTextField myPathField = new PTextField();
    private PTextField myUserField = new PTextField();
    private PLabel myUserLabel = new PLabel();
    private PLabel myPasswordLabel = new PLabel();
    private PLabel myHostLabel = new PLabel();

    public PLicenceOptionsView(PLicenceOptionsController parent, PLicenceView parentView) {
        super((Controller)parent, parentView);
        this.myLicenceOptionsController = parent;
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.setResizable(true);
        this.setTitle(this.myResourceBundle.getString("PLicenceView.Options_Text"));
        this.buildGui();
        this.updateGuiState();
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myResourceBundle);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.setModal(true);
        this.pack();
        this.restoreSettings();
    }

    public void add(View view, Object constraint) {
    }

    private void buildGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.myRemoteServerCheckBox.setName("PLicenceView.UserRemote");
        this.myRemoteServerCheckBox.setIconTextGap(6);
        this.myRemoteServerCheckBox.setBorderPainted(false);
        this.myRemoteServerCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PLicenceOptionsView.this.remoteServerCheckBoxActionPerformed();
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        jPanel.add((Component)this.myRemoteServerCheckBox, gridBagConstraints);
        PLabel confLabel = new PLabel();
        confLabel.setName("PLicenceView.FTP_Server");
        confLabel.setLabelType(ClientProperties.LABEL_TITLE);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 24, 0, 0);
        this.myHostLabel = new PLabel();
        this.myHostLabel.setName("PLicenceView.FTP_Server_Host");
        this.myHostLabel.setLabelFor(this.myHostField);
        this.myHostLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 33, 0, 0);
        jPanel.add((Component)this.myHostLabel, gridBagConstraints);
        this.myUserLabel = new PLabel();
        this.myUserLabel.setName("PLicenceView.FTP_Server_Username");
        this.myUserLabel.setLabelFor(this.myUserField);
        this.myUserLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 33, 0, 0);
        jPanel.add((Component)this.myUserLabel, gridBagConstraints);
        this.myPasswordLabel = new PLabel();
        this.myPasswordLabel.setName("PLicenceView.FTP_Server_Password");
        this.myPasswordLabel.setLabelFor(this.myPasswordField);
        this.myPasswordLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 33, 12, 0);
        jPanel.add((Component)this.myPasswordLabel, gridBagConstraints);
        Dimension textDimension = new Dimension(100, 20);
        this.myHostField.setName("PLicenceOptionsView.FtpServerHostField");
        this.myHostField.setText("");
        this.myHostField.setMinimumSize(textDimension);
        this.myHostField.setPreferredSize(textDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        jPanel.add((Component)this.myHostField, gridBagConstraints);
        this.myUserField.setName("PLicenceOptionsView.UsernameField");
        this.myUserField.setText("");
        this.myUserField.setPreferredSize(textDimension);
        this.myUserField.setMinimumSize(textDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 12, 0, 12);
        jPanel.add((Component)this.myUserField, gridBagConstraints);
        this.myPasswordField.setName("PLicenceOptionsView.PasswordField");
        this.myPasswordField.setText("");
        this.myPasswordField.setPreferredSize(textDimension);
        this.myPasswordField.setMinimumSize(textDimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(6, 12, 12, 12);
        jPanel.add((Component)this.myPasswordField, gridBagConstraints);
        JPanel emptyArea = new JPanel();
        emptyArea.setPreferredSize(new Dimension(0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)emptyArea, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.addButtonsToPanel(), gridBagConstraints);
        this.getContentPane().add(jPanel);
    }

    private void remoteServerCheckBoxActionPerformed() {
        this.updateGuiState();
    }

    private JPanel addButtonsToPanel() {
        JPanel buttonPanel = new JPanel(new RowAlignLayout());
        this.myOkButton.setName("OkAction");
        this.myOkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                PLicenceOptionsView.this.storeSettings();
                PLicenceOptionsView.this.myLicenceOptionsController.saveChangesRequest();
            }
        });
        buttonPanel.add(this.myOkButton);
        this.myCancelButton.setName("CancelAction");
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                PLicenceOptionsView.this.storeSettings();
                PLicenceOptionsView.this.myLicenceOptionsController.cancelChangesRequest();
            }
        });
        buttonPanel.add(this.myCancelButton);
        this.myHelpButton = new PHelpButton();
        this.myHelpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionevent) {
                PLicenceOptionsView.this.myLicenceOptionsController.openHelpRequest();
            }
        });
        buttonPanel.add((Component)this.myHelpButton, "West");
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        this.getRootPane().setDefaultButton(this.myOkButton);
        this.setModal(true);
        return buttonPanel;
    }

    protected void closeDialog() {
        this.myLicenceOptionsController.cancelChangesRequest();
    }

    protected void helpRequest() {
        this.myLicenceOptionsController.openHelpRequest();
    }

    public void setUseExternal(boolean useExt) {
        this.myRemoteServerCheckBox.setSelected(useExt);
    }

    public boolean getUseExternal() {
        return this.myRemoteServerCheckBox.isSelected();
    }

    public void setFtpHost(String host) {
        this.myHostField.setText(host);
    }

    public String getFtpHost() {
        return this.myHostField.getText();
    }

    public void setFtpUsername(String name) {
        this.myUserField.setText(name);
    }

    public String getFtpUsername() {
        return this.myUserField.getText();
    }

    public char[] getFtpPassword() {
        char[] psw = this.myPasswordField.getPassword();
        return psw;
    }

    public void updateGuiState() {
        boolean remoteServer = this.myRemoteServerCheckBox.isSelected();
        this.myHostLabel.setEnabled(remoteServer);
        this.myPasswordLabel.setEnabled(remoteServer);
        this.myUserLabel.setEnabled(remoteServer);
        this.myHostField.setEnabled(remoteServer);
        this.myPasswordField.setEnabled(remoteServer);
        this.myPathField.setEnabled(remoteServer);
        this.myUserField.setEnabled(remoteServer);
    }
}

