/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.widgets.text.TimestampFormatter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class PLicenceTableModel
extends AbstractTableModel
implements TableColumnModelListener {
    protected static final int FEATURE_NAME_COLUMN_INDEX = 0;
    protected static final int FILE_ID_COLUMN_INDEX = 1;
    protected static final int ELEMENT_COLUMN_INDEX = 2;
    protected static final int END_TIME_COLUMN_INDEX = 3;
    protected static final int CAPACITY_COLUMN_INDEX = 4;
    protected static final int ACTIVITY_COLUMN_INDEX = 5;
    protected static final int FEATURE_STATUS_COLUMN_INDEX = 6;
    protected String[] myColumnTitles;
    protected List<PLicence> myEntries = new ArrayList<PLicence>();
    protected int myColumnsCount;
    private ResourceBundle myResourceBundle;
    DateFormat myDateFormat;

    public PLicenceTableModel(String[] columnTitles) {
        this.myColumnTitles = columnTitles;
        this.myColumnsCount = this.myColumnTitles.length;
        this.myDateFormat = TimestampFormatter.getShortFormatter();
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
    }

    @Override
    public int getColumnCount() {
        return this.myColumnsCount;
    }

    @Override
    public int getRowCount() {
        return this.myEntries.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (row < 0 || row >= this.myEntries.size() || column < 0 || column >= this.myColumnTitles.length) {
            return "";
        }
        PLicence licenceInRow = this.myEntries.get(row);
        if (licenceInRow == null) {
            return "";
        }
        switch (column) {
            case 0: {
                Set<String> codes = licenceInRow.getFeatureCodes();
                Iterator<String> iter = codes.iterator();
                String featureCode = null;
                int i = 0;
                StringBuilder features = new StringBuilder();
                while (iter.hasNext()) {
                    ++i;
                    featureCode = iter.next();
                    features.append(String.valueOf(licenceInRow.getFeatureName(featureCode)) + ", ");
                }
                String featureNames = features.toString();
                if (i > 1) {
                    return featureNames.substring(0, featureNames.length() - 2);
                }
                return licenceInRow.getFeatureName(featureCode) == null ? "" : licenceInRow.getFeatureName(featureCode);
            }
            case 1: {
                return licenceInRow.getFileId() == null ? "" : licenceInRow.getFileId();
            }
            case 2: {
                return licenceInRow.getElementType() == null ? "" : licenceInRow.getElementType();
            }
            case 3: {
                return licenceInRow.getEndTime();
            }
            case 4: {
                return licenceInRow.getCapacity() == -1L ? "N/A" : Long.valueOf(licenceInRow.getCapacity());
            }
            case 5: {
                if (licenceInRow.getStatus() == null) {
                    return "";
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.ACTIVE)) {
                    return this.myResourceBundle.getString("Common.Active_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.INACTIVE)) {
                    return this.myResourceBundle.getString("PLicenceView.Inactive_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.EXPIRED)) {
                    return this.myResourceBundle.getString("PLicenceView.Expired_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_VALID)) {
                    return this.myResourceBundle.getString("PLicenceView.Valid_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_DOWNLOADED)) {
                    return this.myResourceBundle.getString("PLicenceView.Unknown_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_DELETED)) {
                    return this.myResourceBundle.getString("PLicenceView.Unknown_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_KEEP)) {
                    return this.myResourceBundle.getString("PLicenceView.Keep_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_EXPIRED)) {
                    return this.myResourceBundle.getString("PLicenceView.Expired_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_NOTSTARTED)) {
                    return this.myResourceBundle.getString("PLicenceView.NotStarted_Text");
                }
                if (licenceInRow.getStatus().equals((Object)PLicence.LICENCE_STATUS.NEWSTATE_UNKNOWN)) {
                    return this.myResourceBundle.getString("PLicenceView.Unknown_Text");
                }
                return licenceInRow.getStatus();
            }
            case 6: {
                Set<String> codes = licenceInRow.getFeatureStatusCodes();
                Iterator<String> iter = codes.iterator();
                String featureCode = null;
                int i = 0;
                StringBuilder features = new StringBuilder();
                while (iter.hasNext()) {
                    ++i;
                    featureCode = iter.next();
                    features.append(String.valueOf(licenceInRow.getFeatureStatus(featureCode)) + ", ");
                }
                String featureStatus = features.toString();
                if (i > 1) {
                    return featureStatus.substring(0, featureStatus.length() - 2);
                }
                return licenceInRow.getFeatureStatus(featureCode) == null ? "" : licenceInRow.getFeatureStatus(featureCode);
            }
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public Class getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Object.class;
            }
            case 1: {
                return Object.class;
            }
            case 2: {
                return Object.class;
            }
            case 3: {
                return Calendar.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Object.class;
            }
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.myColumnTitles.length) {
            return "";
        }
        return this.myColumnTitles[columnIndex];
    }

    protected void setContents(List<PLicence> licences) {
        this.myEntries.clear();
        if (licences == null) {
            return;
        }
        this.myEntries.addAll(licences);
        this.fireTableChanged(new TableModelEvent(this));
    }

    protected PLicence getLicence(int row) {
        if (row < 0 || row >= this.getRowCount()) {
            return null;
        }
        return this.myEntries.get(row);
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent e) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent e) {
    }
}

