/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.licence;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.comm.ftp.FtpClient;
import com.nokia.em.poseidon.comm.ftp.FtpConnectionInfo;
import com.nokia.em.poseidon.comm.ftp.FtpException;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.i18n.localizer.Localizer;
import com.nokia.em.poseidon.frameworks.i18n.localizer.LocalizerRegistry;
import com.nokia.em.poseidon.frameworks.i18n.localizer.swing.SwingHierarchyIterator;
import com.nokia.em.poseidon.frameworks.mvc.Controller;
import com.nokia.em.poseidon.frameworks.mvc.View;
import com.nokia.em.poseidon.frameworks.mvc.swing.JDialogViewBase;
import com.nokia.em.poseidon.gui.common.CloseConfirmationMessage;
import com.nokia.em.poseidon.gui.common.file.FileComboBox;
import com.nokia.em.poseidon.gui.common.file.FileComboBoxModel;
import com.nokia.em.poseidon.gui.common.file.FileComboBoxRenderer;
import com.nokia.em.poseidon.gui.licence.PLicenceController;
import com.nokia.em.poseidon.gui.licence.PLicenceDetailsView;
import com.nokia.em.poseidon.gui.licence.PLicenceModifiedOpen;
import com.nokia.em.poseidon.gui.licence.PLicenceModifiedSave;
import com.nokia.em.poseidon.gui.licence.PLicenceOptionsController;
import com.nokia.em.poseidon.gui.licence.PLicenceTableModel;
import com.nokia.em.poseidon.gui.licence.PLicenceValidator;
import com.nokia.em.poseidon.services.licence.PLicence;
import com.nokia.em.poseidon.services.licence.PLicenceParser;
import com.nokia.em.poseidon.services.ui.UserInterface;
import com.nokia.em.poseidon.util.PSettings;
import com.nokia.em.poseidon.util.file.PFileUtils;
import com.nokia.widgets.ClientProperties;
import com.nokia.widgets.PPanel;
import com.nokia.widgets.buttons.PHelpButton;
import com.nokia.widgets.hyperlink.Hyperlink;
import com.nokia.widgets.labels.PLabel;
import com.nokia.widgets.layout.PHorizontalLayout;
import com.nokia.widgets.layout.PVerticalLayout;
import com.nokia.widgets.layout.RowAlignLayout;
import com.nokia.widgets.progress.ProgressController;
import com.nokia.widgets.progress.ProgressFactory;
import com.nokia.widgets.progress.models.ProgressBarModel;
import com.nokia.widgets.table.PTable;
import com.nokia.widgets.table.PTableCellRenderer;
import com.nokia.widgets.table.PTableModelSorter;
import com.nokia.widgets.text.TimestampFormatter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.log4j.Logger;

public class PLicenceView
extends JDialogViewBase
implements ActionListener,
FocusListener,
ChangeListener {
    private static int FEATURE_COLUMN_WIDTH = 180;
    private static int FILE_ID_COLUMN_WIDTH = 100;
    private static int ELEMENT_COLUMN_WIDTH = 60;
    private static int END_TIME_COLUMN_WIDTH = 120;
    private static int CAPACITY_COLUMN_WIDTH = 120;
    private static int ACTIVITY_COLUMN_WIDTH = 90;
    private static int FEATURE_STATUS_COLUMN_WIDTH = 90;
    private static final String SERVER_ACTION = "PLicenceView.ServerAction";
    private static final String ACTIVATE_ACTION = "PLicenceView.ActivateAction";
    private static final String DEACTIVATE_ACTION = "PLicenceView.DeactivateAction";
    private static final String DELETE_ACTION = "PLicenceView.DeleteAction";
    private static final String CLOSE_ACTION = "CloseAction";
    private static final String SETTINGS_KEY_SAVING_FILE = "poseidon.licenceview.savinglicence";
    private static final String mySettingsKey = "LicenceManagement";
    private final PLicenceController myLicenceController;
    private PLicenceTableModel myLicenceTableModel;
    private PTableModelSorter mySortedLicenceModel;
    private PTable myLicenceTable;
    private JButton myActivateButton;
    private JButton myDeactivateButton;
    private JButton myDeleteButton;
    private JButton myUploadButton;
    private FileComboBox myFileSelectionCombo;
    private JButton myDownloadButton;
    private JButton myServerButton;
    private JButton myCloseButton;
    private PHelpButton myHelpButton;
    private PLabel myLicenceFileSourceLabel;
    private final ResourceBundle myResourceBundle;
    private JTabbedPane myDetailsTabbedPane;
    private PLicence myDownloadableLicence;
    private PLicenceDetailsView myExistingLicencePanel;
    private PLicenceDetailsView myBrowsedLicencePanel;
    private ProgressController myProgressController;
    private ProgressBarModel myProgressModel;
    private final List<PLicence> mySelectedLicences = new ArrayList<PLicence>();
    private final Map<String, PLicence> myExistingLicences = new HashMap<String, PLicence>();
    private PLicence mySelectedLicence;
    private final List<PLicence> myLicencesInTable = new ArrayList<PLicence>();
    private final String myElementName;
    private FtpConnectionInfo myFtpTransferInfo = new FtpConnectionInfo();
    private final GridBagConstraints myConstraints;
    private final List<PLicence> myOperatedLicences = new ArrayList<PLicence>();
    private int mySelectedRow = -1;
    private int myOperationOngoing = 0;
    private File myLastSelectedFile = null;
    protected PSettings mySettings;
    private final JLabel myTargetId = PLabel.createValueText("");
    private final Logger myLogger;
    private final DateFormat myDateFormat;
    private PLicenceValidator myLicenceFileValidator;
    private CloseConfirmationMessage myCloseMessage = PoseidonRuntime.getRuntime().getObject(CloseConfirmationMessage.class);

    public PLicenceView(PLicenceController controller) {
        super((Controller)controller, PoseidonRuntime.getRuntime().getService(UserInterface.class).getFrame());
        this.myResourceBundle = I18n.getI18n().getBundle(this.getClass());
        this.myLogger = Logger.getLogger(this.getClass());
        this.myLicenceController = controller;
        this.mySettings = PSettings.getInstance();
        this.myElementName = this.myLicenceController.getManagedElementName() != null ? this.myLicenceController.getManagedElementName() : (String)PoseidonRuntime.getRuntime().getRuntimeProperty("elementName");
        this.myDateFormat = TimestampFormatter.getShortFormatter();
        this.myConstraints = new GridBagConstraints();
        this.buildUI();
        this.restoreSettings();
        this.initListeners();
        this.myLicenceTable.repaint();
    }

    public String getTargetId() {
        return this.myTargetId.getText();
    }

    public void setTargetId(String targetId) {
        this.myTargetId.setText(targetId);
    }

    public void add(View view, Object constraint) {
    }

    @Override
    protected void handleWindowClosing() {
        switch (this.myOperationOngoing) {
            case 0: {
                super.handleWindowClosing();
                break;
            }
            case 3: {
                if (!this.myCloseMessage.closeAndContinueRequested(this, this.myResourceBundle.getString("PLicenceView.LicenceView_Text"), this.myResourceBundle.getString("PlicenceView.Delete_Action_Text"))) break;
                super.handleWindowClosing();
                break;
            }
            case 4: 
            case 5: {
                super.handleWindowClosing();
                break;
            }
            default: {
                if (!this.closeConfirmationMessage()) break;
                super.handleWindowClosing();
            }
        }
    }

    protected void showUploadFunctionality(boolean show) {
        this.myUploadButton.setVisible(show);
    }

    protected void showActivateFunctionality(boolean show) {
        this.myActivateButton.setVisible(show);
    }

    protected void showDeactivateFunctionality(boolean show) {
        this.myDeactivateButton.setVisible(show);
    }

    protected void showRemoteServerFunctionality(boolean show) {
        this.myServerButton.setVisible(show);
        this.myLicenceFileSourceLabel.setVisible(show);
    }

    protected void closeRoutine() {
        this.removeListeners();
        this.storeSettings();
    }

    private void buildUI() {
        GridBagConstraints constraints = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        constraints.gridheight = -1;
        constraints.gridwidth = 0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.createPanelArea(), constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.createButtonPanel(), constraints);
        this.setTitle(this.myResourceBundle.getString("PLicenceView.LicenceView_Text"));
        this.setMinimumSize(new Dimension(950, 625));
        this.pack();
        Localizer localizer = LocalizerRegistry.lookup("swing");
        localizer.setResourceBundle(this.myResourceBundle);
        localizer.localizeObjectHierarchy(new SwingHierarchyIterator(this));
        this.setModal(true);
    }

    private void initListeners() {
        this.myFileSelectionCombo.addActionListener(this);
        this.myActivateButton.addActionListener(this);
        this.myDeactivateButton.addActionListener(this);
        this.myDeleteButton.addActionListener(this);
        this.myUploadButton.addActionListener(this);
        this.myDownloadButton.addActionListener(this);
        this.myServerButton.addActionListener(this);
        this.myCloseButton.addActionListener(this);
        this.myHelpButton.addActionListener(this);
        this.myLicenceTable.addFocusListener(this);
        this.myFileSelectionCombo.addFocusListener(this);
        this.myDetailsTabbedPane.addFocusListener(this);
        this.myDetailsTabbedPane.addChangeListener(this);
    }

    private void removeListeners() {
        this.myFileSelectionCombo.removeActionListener(this);
        this.myActivateButton.removeActionListener(this);
        this.myDeactivateButton.removeActionListener(this);
        this.myDeleteButton.removeActionListener(this);
        this.myUploadButton.removeActionListener(this);
        this.myDownloadButton.removeActionListener(this);
        this.myServerButton.removeActionListener(this);
        this.myCloseButton.removeActionListener(this);
        this.myHelpButton.removeActionListener(this);
        this.myLicenceTable.removeFocusListener(this);
        this.myFileSelectionCombo.removeFocusListener(this);
        this.myDetailsTabbedPane.removeFocusListener(this);
        this.myDetailsTabbedPane.removeChangeListener(this);
    }

    private JScrollPane createLicenceTable() {
        String[] columnTitles = new String[]{this.myResourceBundle.getString("PLicenceView.FeatureName_Text"), this.myResourceBundle.getString("PLicenceView.FileId_Text"), this.myResourceBundle.getString("PLicenceView.Element_Text"), this.myResourceBundle.getString("PLicenceView.EndTime_Text"), this.myResourceBundle.getString("PLicenceView.Capacity_Text"), this.myResourceBundle.getString("PLicenceView.Activity_Text"), this.myResourceBundle.getString("PLicenceView.Feature_State_Text")};
        this.myLicenceTableModel = new PLicenceTableModel(columnTitles);
        this.mySortedLicenceModel = new PTableModelSorter(this.myLicenceTableModel);
        this.mySortedLicenceModel.sort(true, 0);
        this.myLicenceTable = new PTable(this.mySortedLicenceModel);
        this.myLicenceTable.setBackground(this.getBackground());
        this.myLicenceTable.setSelectionMode(0);
        this.myLicenceTable.setRowSelectionAllowed(true);
        this.myLicenceTable.getColumnModel().getColumn(3).setCellRenderer(new LicenceTableCellRenderer());
        this.myLicenceTable.setEmptyText(this.myResourceBundle.getString("PLicenceView.EmptyTable_Text"));
        TableColumn column = null;
        int columnCount = this.mySortedLicenceModel.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            column = this.myLicenceTable.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    column.setPreferredWidth(FEATURE_COLUMN_WIDTH);
                    break;
                }
                case 1: {
                    column.setPreferredWidth(FILE_ID_COLUMN_WIDTH);
                    break;
                }
                case 2: {
                    column.setPreferredWidth(ELEMENT_COLUMN_WIDTH);
                    break;
                }
                case 3: {
                    column.setPreferredWidth(END_TIME_COLUMN_WIDTH);
                    break;
                }
                case 4: {
                    column.setPreferredWidth(CAPACITY_COLUMN_WIDTH);
                    break;
                }
                case 5: {
                    column.setPreferredWidth(ACTIVITY_COLUMN_WIDTH);
                    break;
                }
                case 6: {
                    column.setPreferredWidth(FEATURE_STATUS_COLUMN_WIDTH);
                    break;
                }
            }
            ++i;
        }
        this.myLicenceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int selectedRow = PLicenceView.this.myLicenceTable.getSelectedRow();
                if (selectedRow > -1) {
                    PLicence selLic = PLicenceView.this.myLicenceTableModel.getLicence(PLicenceView.this.mySortedLicenceModel.getOriginalIndex(selectedRow));
                    if (selLic != null) {
                        PLicenceView.this.mySelectedLicence = (PLicence)PLicenceView.this.myExistingLicences.get(selLic.getFileId());
                        if (PLicenceView.this.mySelectedLicence != null) {
                            PLicenceView.this.updateDetailsView();
                        }
                    }
                    PLicenceView.this.mySelectedLicences.clear();
                    int[] selectedRows = PLicenceView.this.myLicenceTable.getSelectedRows();
                    int i = 0;
                    while (i < selectedRows.length) {
                        PLicence lic = PLicenceView.this.myLicenceTableModel.getLicence(PLicenceView.this.mySortedLicenceModel.getOriginalIndex(selectedRows[i]));
                        PLicenceView.this.mySelectedLicences.add((PLicence)PLicenceView.this.myExistingLicences.get(lic.getFileId()));
                        ++i;
                    }
                    PLicenceView.this.areOperationsSupported();
                } else {
                    PLicenceView.this.mySelectedLicences.clear();
                    PLicenceView.this.mySelectedLicence = null;
                    PLicenceView.this.updateDetailsView();
                    PLicenceView.this.myLicenceTable.repaint();
                    PLicenceView.this.areOperationsSupported();
                }
            }
        });
        JTableHeader tableHeader = this.myLicenceTable.getTableHeader();
        tableHeader.setReorderingAllowed(false);
        JScrollPane tableScrollPane = new JScrollPane(this.myLicenceTable);
        tableScrollPane.setColumnHeaderView(tableHeader);
        tableScrollPane.setMinimumSize(new Dimension(FEATURE_COLUMN_WIDTH + FILE_ID_COLUMN_WIDTH + ELEMENT_COLUMN_WIDTH + END_TIME_COLUMN_WIDTH + CAPACITY_COLUMN_WIDTH + ACTIVITY_COLUMN_WIDTH + 3, 150));
        tableScrollPane.setPreferredSize(new Dimension(FEATURE_COLUMN_WIDTH + FILE_ID_COLUMN_WIDTH + ELEMENT_COLUMN_WIDTH + END_TIME_COLUMN_WIDTH + CAPACITY_COLUMN_WIDTH + ACTIVITY_COLUMN_WIDTH + 20, 180));
        return tableScrollPane;
    }

    private GridBagConstraints createConstraints(int gridx, int gridy, int gridwidth, int gridheight, double weightx, double weighty, int anchor, int fill, Insets insets) {
        this.myConstraints.gridx = gridx;
        this.myConstraints.gridy = gridy;
        this.myConstraints.gridwidth = gridwidth;
        this.myConstraints.gridheight = gridheight;
        this.myConstraints.weightx = weightx;
        this.myConstraints.weighty = weighty;
        this.myConstraints.anchor = anchor;
        this.myConstraints.fill = fill;
        this.myConstraints.insets = insets;
        return this.myConstraints;
    }

    private String restoreFileName() {
        String fileName = PoseidonRuntime.getRuntime().getUserHome();
        return this.mySettings.get(SETTINGS_KEY_SAVING_FILE, fileName);
    }

    private void storeFileName(String fileName) {
        this.mySettings.set(SETTINGS_KEY_SAVING_FILE, fileName);
    }

    private JPanel createPanelArea() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        Object[] elementName = new Object[]{this.myElementName};
        PLabel licenceTableTitleLabel = PLabel.createTitle(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.TableTitle_Text"), elementName));
        mainPanel.add((Component)licenceTableTitleLabel, this.createConstraints(0, 0, 2, 1, 0.0, 0.0, 16, 0, new Insets(12, 22, 0, 0)));
        JPanel panel = new JPanel(new PHorizontalLayout(2, 6, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 12, 20, 0));
        PLabel targetIdLabel = new PLabel(this.myResourceBundle.getString("PLicenceView.TargetId_Text"));
        targetIdLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        panel.add(targetIdLabel);
        panel.add(this.myTargetId);
        mainPanel.add((Component)panel, this.createConstraints(2, 0, 0, 1, 0.0, 0.0, 12, 0, new Insets(20, 12, 0, 22)));
        mainPanel.add((Component)this.createLicenceTable(), this.createConstraints(0, 1, 4, 1, 1.0, 1.0, 18, 1, new Insets(6, 22, 6, 22)));
        JPanel tableButtonPanel = new JPanel(new PHorizontalLayout(3, 12, 0, 0));
        this.myActivateButton = new JButton();
        this.myActivateButton.setName(ACTIVATE_ACTION);
        this.myActivateButton.setToolTipText(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.ActivateAction_ToolTip"), elementName));
        this.myActivateButton.setEnabled(false);
        this.myDeactivateButton = new JButton();
        this.myDeactivateButton.setName(DEACTIVATE_ACTION);
        this.myDeactivateButton.setToolTipText(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.DeactivateAction_ToolTip"), elementName));
        this.myDeactivateButton.setEnabled(false);
        this.myDeleteButton = new JButton();
        this.myDeleteButton.setName(DELETE_ACTION);
        this.myDeleteButton.setToolTipText(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.DeleteAction_ToolTip"), elementName));
        this.myDeleteButton.setEnabled(false);
        this.myUploadButton = new JButton(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.UploadAction_Text"), elementName));
        this.myUploadButton.setName("PLicenceView.UploadButton");
        this.myUploadButton.setMnemonic(this.myResourceBundle.getString("PLicenceView.UploadAction_Mnemonic").charAt(0));
        this.myUploadButton.setToolTipText(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.UploadAction_ToolTip"), elementName));
        this.myUploadButton.setEnabled(false);
        tableButtonPanel.add(this.myActivateButton);
        tableButtonPanel.add(this.myDeactivateButton);
        tableButtonPanel.add(this.myDeleteButton);
        tableButtonPanel.add(this.myUploadButton);
        mainPanel.add((Component)tableButtonPanel, this.createConstraints(0, 2, 4, 1, 0.0, 0.0, 21, 1, new Insets(0, 22, 0, 12)));
        PLabel downloadLabel = new PLabel(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.DownloadLabel_Text"), elementName));
        downloadLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        downloadLabel.setLabelType(ClientProperties.LABEL_TITLE);
        mainPanel.add((Component)downloadLabel, this.createConstraints(0, 3, 3, 1, 0.0, 0.0, 18, 0, new Insets(12, 22, 0, 0)));
        this.myFileSelectionCombo = new FileComboBox("LicenceManagement_LicenceFile");
        FileComboBoxRenderer comboRenderer = new FileComboBoxRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderedComponent = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderedComponent instanceof JLabel) {
                    JLabel renderedLabel = (JLabel)renderedComponent;
                    if ("Browse...".equals(value)) {
                        renderedLabel.setToolTipText(PLicenceView.this.myResourceBundle.getString("PLicenceView.BrowseAction_ToolTip"));
                    }
                }
                return renderedComponent;
            }
        };
        comboRenderer.setSelectionType(FileComboBox.SELECTION_TYPE.FILE_SELECTION);
        this.myFileSelectionCombo.setRenderer(comboRenderer);
        this.myFileSelectionCombo.setSelectionType(FileComboBox.SELECTION_TYPE.FILE_SELECTION);
        PLicenceModifiedOpen openDialog = new PLicenceModifiedOpen(new File(this.restoreFileName()), this.myResourceBundle.getString("PLicenceView.openTitle"));
        ((FileComboBoxModel)this.myFileSelectionCombo.getModel()).setShowEmptyItem(false);
        this.myFileSelectionCombo.setFileChooser(openDialog);
        this.myFileSelectionCombo.setToolTipText(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.LicenceFileDropDown_ToolTip"), elementName));
        this.myFileSelectionCombo.setPrototypeDisplayValue("VALUE_FIT_TO_COMBO");
        mainPanel.add((Component)this.myFileSelectionCombo, this.createConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(6, 22, 0, 0)));
        JPanel downloadButtonPanel = new JPanel(new PVerticalLayout(3, 12, 0, 0));
        this.myDownloadButton = new JButton(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.DownloadAction_Text"), elementName));
        this.getRootPane().setDefaultButton(this.myDownloadButton);
        this.myDownloadButton.setName("PLicenceView.DownloadButton");
        this.myDownloadButton.setMnemonic(this.myResourceBundle.getString("PLicenceView.DownloadAction_Mnemonic").charAt(0));
        this.myDownloadButton.setToolTipText(MessageFormat.format(this.myResourceBundle.getString("PLicenceView.DownloadAction_ToolTip"), elementName));
        this.myDownloadButton.setEnabled(false);
        this.myServerButton = new JButton();
        this.myServerButton.setName(SERVER_ACTION);
        this.myServerButton.setToolTipText(this.myResourceBundle.getString("PLicenceView.ServerAction_ToolTip"));
        downloadButtonPanel.add(this.myDownloadButton);
        downloadButtonPanel.add(this.myServerButton);
        mainPanel.add((Component)downloadButtonPanel, this.createConstraints(1, 4, 1, 3, 0.0, 0.0, 18, 0, new Insets(6, 12, 0, 0)));
        this.myLicenceFileSourceLabel = new PLabel();
        if (this.myFtpTransferInfo.myHost != null) {
            this.myLicenceFileSourceLabel.setText(this.myResourceBundle.getString("PLicenceView.RemoteSource_Text"));
        } else {
            this.myLicenceFileSourceLabel.setText(this.myResourceBundle.getString("PLicenceView.LocalSource_Text"));
        }
        mainPanel.add((Component)this.myLicenceFileSourceLabel, this.createConstraints(0, 6, 1, 1, 0.0, 0.0, 16, 0, new Insets(12, 12, 4, 0)));
        this.myProgressModel = new ProgressBarModel();
        this.myProgressModel.setEstimatedDurationVisible(false);
        this.myProgressModel.setActionButtonVisible(false);
        this.myProgressModel.setIndeterminated(true);
        this.myProgressModel.setProperty("animation", true);
        this.myProgressModel.setProperty("indeterminated", true);
        this.myProgressModel.setProgressState(2);
        this.myProgressController = ProgressFactory.createProgressBarControl(this.myProgressModel);
        mainPanel.add((Component)this.myProgressController.getView(), this.createConstraints(0, 7, 2, 1, 0.0, 0.0, 16, 2, new Insets(12, 22, 20, 12)));
        this.myDetailsTabbedPane = new JTabbedPane();
        this.myExistingLicencePanel = new PLicenceDetailsView();
        this.myExistingLicencePanel.setOpaque(false);
        this.myBrowsedLicencePanel = new PLicenceDetailsView();
        this.myBrowsedLicencePanel.setOpaque(false);
        JScrollPane existingLicenceScrollPane = new JScrollPane(this.myExistingLicencePanel);
        JScrollPane browsedLicenceScrollPane = new JScrollPane(this.myBrowsedLicencePanel);
        this.myDetailsTabbedPane.add(this.myResourceBundle.getString("PLicence.existingTabbedPane_Text"), existingLicenceScrollPane);
        this.myDetailsTabbedPane.add(this.myResourceBundle.getString("PLicence.browsedTabbedPane_Text"), browsedLicenceScrollPane);
        this.myDetailsTabbedPane.setMnemonicAt(0, 69);
        this.myDetailsTabbedPane.setMnemonicAt(1, 82);
        this.myDetailsTabbedPane.setMinimumSize(new Dimension(350, 300));
        this.myDetailsTabbedPane.setPreferredSize(new Dimension(350, 300));
        mainPanel.add((Component)this.myDetailsTabbedPane, this.createConstraints(2, 4, 0, 4, 1.0, 1.0, 18, 1, new Insets(6, 12, 20, 22)));
        PLabel detailsLabel = new PLabel();
        detailsLabel.setText(this.myResourceBundle.getString("PLicenceView.DetailsLabel_Text"));
        detailsLabel.setLabelType(ClientProperties.LABEL_SYSTEM_TEXT);
        detailsLabel.setLabelType(ClientProperties.LABEL_TITLE);
        mainPanel.add((Component)detailsLabel, this.createConstraints(3, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(12, 12, 0, 0)));
        return mainPanel;
    }

    private JPanel createButtonPanel() {
        PPanel buttonPanel = new PPanel(new RowAlignLayout());
        this.myCloseButton = new JButton();
        this.myCloseButton.setName(CLOSE_ACTION);
        this.getRootPane().setDefaultButton(this.myCloseButton);
        this.myHelpButton = new PHelpButton();
        JButton[] centerButtons = new JButton[1];
        JButton[] rightButtons = new JButton[1];
        centerButtons[0] = this.myCloseButton;
        rightButtons[0] = this.myCloseButton;
        buttonPanel.add(this.myCloseButton);
        buttonPanel.add((Component)this.myHelpButton, "West");
        buttonPanel.putClientProperty("panelType", ClientProperties.PANEL_BUTTONAREA_BACKGROUND);
        buttonPanel.setVisibleUpperEdge(true);
        return buttonPanel;
    }

    private void areOperationsSupported() {
        if (this.myOperationOngoing != 0) {
            return;
        }
        if (this.mySelectedLicence == null) {
            this.enableTableButtons(false);
            this.enableDownloadButtons(true);
            return;
        }
        boolean[] operationSupport = this.myLicenceController.areOperationsSupported(this.mySelectedLicences);
        if (this.mySelectedLicence.getStatus() == null) {
            this.myActivateButton.setEnabled(operationSupport[0]);
        } else if (!this.mySelectedLicence.getStatus().equals((Object)PLicence.LICENCE_STATUS.ACTIVE) && operationSupport[0]) {
            this.myActivateButton.setEnabled(true);
        } else {
            this.myActivateButton.setEnabled(false);
        }
        if (this.mySelectedLicence.getStatus() == null) {
            this.myDeactivateButton.setEnabled(operationSupport[1]);
        } else if (!this.mySelectedLicence.getStatus().equals((Object)PLicence.LICENCE_STATUS.INACTIVE) && !this.mySelectedLicence.getStatus().equals((Object)PLicence.LICENCE_STATUS.EXPIRED) && operationSupport[1]) {
            this.myDeactivateButton.setEnabled(true);
        } else {
            this.myDeactivateButton.setEnabled(false);
        }
        this.myDeleteButton.setEnabled(operationSupport[2]);
        this.myUploadButton.setEnabled(operationSupport[3]);
        this.enableDownloadButtons(true);
    }

    protected int deleteConfirmationMessage() {
        ArrayList<String> features = new ArrayList<String>();
        for (PLicence lic : this.mySelectedLicences) {
            features.addAll(lic.getFeatureNames());
        }
        String message = this.myResourceBundle.getString("PLicenceView.Delete_Confirmation2");
        String primerMessage = this.myResourceBundle.getString("PLicenceView.Delete_Confirmation1");
        String hyperlinkText = this.myResourceBundle.getString("PLicenceView.Delete_Hyperlink");
        String columnName = this.myResourceBundle.getString("PLicenceView.Delete_TableHeader");
        String title = this.myResourceBundle.getString("PLicenceView.Delete_Confirmation_Title");
        String detailsPanelTitle = this.myResourceBundle.getString("PLicenceView.Delete_Details_Title");
        SelectionHolder selectionHolder = new SelectionHolder();
        Object[] options = new Object[]{this.createOKButton("PLicenceView.DeleteAction_Text", "PLicenceView.DeleteAction_Mnemonic", selectionHolder), this.myResourceBundle.getString("CancelAction_Text")};
        JComponent detailsPanel = this.createDetailsPanel(features, columnName);
        PPanel confirmationPanel = this.createConfirmationPanel(message, primerMessage, hyperlinkText, detailsPanel, detailsPanelTitle);
        this.showCustomizableConfirmationMessage(confirmationPanel, title, options, options[1], 0, 3);
        return selectionHolder.getSelection();
    }

    protected boolean closeConfirmationMessage() {
        ArrayList<String> features = new ArrayList<String>();
        for (PLicence lic : this.mySelectedLicences) {
            features.addAll(lic.getFeatureNames());
        }
        String operation = this.myOperationOngoing == 1 ? this.myResourceBundle.getString("PLicenceView.Close_Confirmation_downloading") : this.myResourceBundle.getString("PLicenceView.Close_Confirmation_uploading");
        return this.myCloseMessage.closeAndContinueRequested(this, this.myResourceBundle.getString("PLicenceView.LicenceView_Text"), operation);
    }

    protected int uploadConfirmationMessage() {
        ArrayList<String> features = new ArrayList<String>();
        for (PLicence lic : this.mySelectedLicences) {
            features.addAll(lic.getFeatureNames());
        }
        Object[] messageArgs = new Object[]{this.myElementName};
        String message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Upload_Confirmation"), messageArgs);
        String title = this.myResourceBundle.getString("PLicenceView.LicenceView_Text");
        String headLine = this.myResourceBundle.getString("PLicenceView.Upload_Confirmation_HeadLine");
        SelectionHolder selectionHolder = new SelectionHolder();
        Object[] options = new Object[]{this.createOKButton("PLicenceView.Upload_Text", "PLicenceView.Upload_Mnemonic", selectionHolder), this.myResourceBundle.getString("CancelAction_Text")};
        this.showConfirmationMessage(message, headLine, title, options, null, 0, 2);
        return selectionHolder.getSelection();
    }

    protected int activationConfirmationMessage() {
        Object[] options = new Object[2];
        Object[] messageArgs = new Object[]{this.myElementName};
        String message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Activate_Confirmation"), messageArgs);
        String title = this.myResourceBundle.getString("PLicenceView.LicenceView_Text");
        String headLine = this.myResourceBundle.getString("PLicenceView.Activate_Confirmation_HeadLine");
        SelectionHolder selHolder = new SelectionHolder();
        options[0] = this.createOKButton("PLicenceView.ActivateAction_Text", "PLicenceView.ActivateAction_Mnemonic", selHolder);
        options[1] = this.myResourceBundle.getString("CancelAction_Text");
        this.showConfirmationMessage(message, headLine, title, options, options[0], 0, 1);
        return selHolder.getSelection();
    }

    protected int deactivationConfiramtionMessage() {
        Object[] options = new Object[2];
        Object[] messageArgs = new Object[]{this.myElementName};
        String message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Deactivate_Confirmation"), messageArgs);
        String title = this.myResourceBundle.getString("PLicenceView.LicenceView_Text");
        String headLine = this.myResourceBundle.getString("PLicenceView.Deactivate_Confirmation_HeadLine");
        SelectionHolder selectionHolder = new SelectionHolder();
        options[0] = this.createOKButton("PLicenceView.DeactivateAction_Text", "PLicenceView.DeactivateAction_Mnemonic", selectionHolder);
        options[1] = this.myResourceBundle.getString("CancelAction_Text");
        this.showConfirmationMessage(message, headLine, title, options, null, 0, 2);
        return selectionHolder.getSelection();
    }

    protected int showConfirmationMessage(String message, String headLine, String title, Object[] options, Object defaultButton, int optionsType, int messageType) {
        String[] text = new String[]{headLine, message};
        int response = JOptionPane.showOptionDialog(this, text, title, optionsType, messageType, null, options, defaultButton);
        return response;
    }

    protected int showCustomizableConfirmationMessage(Object message, String title, Object[] options, Object defaultButton, int optionsType, int messageType) {
        int response = JOptionPane.showOptionDialog(this, message, title, optionsType, messageType, null, options, defaultButton);
        return response;
    }

    private JComponent createDetailsPanel(List<String> tableContents, String columnName) {
        PTable featuresTable = new PTable();
        DefaultTableModel model = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        PTableModelSorter featuresTableSorter = new PTableModelSorter(model);
        featuresTable.setModel(featuresTableSorter);
        model.addColumn(columnName);
        for (String content : tableContents) {
            model.addRow(new String[]{content});
        }
        featuresTableSorter.sort(1, 0);
        JScrollPane scrollPane = new JScrollPane(featuresTable);
        scrollPane.setPreferredSize(new Dimension(400, 220));
        scrollPane.setVerticalScrollBarPolicy(20);
        return scrollPane;
    }

    protected PPanel createConfirmationPanel(String message, String primerMessage, String hyperlinkText, final Object detailsPanel, final String detailsPanelTitle) {
        PPanel p = new PPanel();
        final PLicenceView view = this;
        Hyperlink detailsButton = new Hyperlink(hyperlinkText);
        detailsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(view, detailsPanel, detailsPanelTitle, -1);
            }
        });
        p.setLayout((LayoutManager)new MigLayout("insets 0"));
        p.add((Component)PLabel.createLabel(primerMessage), "wrap");
        p.add((Component)detailsButton, "wrap");
        p.add(PLabel.createLabel(message));
        return p;
    }

    protected void operationFailed(int type, String title, String headLine, Object msg) {
        Object[] options = new Object[1];
        Object[] message = new Object[]{headLine, msg};
        options[0] = this.myResourceBundle.getString("CloseAction_Text");
        if (!this.myLicenceController.isSnapshotMode() && !this.myLicenceController.isReadOnlyMode() && this.myProgressController != null) {
            this.myProgressController.fail();
        }
        this.myProgressModel.setElapsedTime(0);
        this.myCloseMessage.operationFinished(this);
        if (type == 999) {
            JOptionPane.showOptionDialog(this, message, title, -1, 1, null, options, options[0]);
        } else {
            JOptionPane.showOptionDialog(this, message, title, -1, type, null, options, options[0]);
        }
        this.myOperationOngoing = 0;
        if (!this.mySelectedLicences.isEmpty()) {
            this.areOperationsSupported();
        }
        this.enableDownloadButtons(true);
        this.myCloseButton.setEnabled(true);
        this.myOperatedLicences.clear();
    }

    protected void operationFailed(int type, String element, String fileName) {
        String message = "";
        String headLine = "";
        String title = "";
        int messageType = 1;
        Object[] params = new Object[]{fileName, element};
        switch (type) {
            case 1: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Cannot_Download"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Download_HeadLine");
                messageType = 0;
                break;
            }
            case 2: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Licence_Exists"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Licence_Exists_HeadLine");
                break;
            }
            case 3: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Code_Unknown"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Code_Unknown_HeadLine");
                messageType = 1;
                break;
            }
            case 4: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Invalid_Licence"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Invalid_Licence_HeadLine");
                break;
            }
            case 5: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Another_Element"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Another_Element_HeadLine");
                break;
            }
            case 6: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Cannot_Activate"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Activate_HeadLine");
                messageType = 0;
                break;
            }
            case 7: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Cannot_Deactivate"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Deactivate_HeadLine");
                messageType = 0;
                break;
            }
            case 8: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Cannot_Delete"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Delete_HeadLine");
                messageType = 0;
                this.myCloseMessage.operationFinished(this);
                break;
            }
            case 9: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Cannot_Upload"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Upload_HeadLine");
                messageType = 0;
                break;
            }
            case 10: {
                message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Swdl_Ongoing"), params);
                headLine = this.myResourceBundle.getString("PLicenceView.Cannot_Download_HeadLine");
                messageType = 0;
                break;
            }
        }
        title = this.myResourceBundle.getString("PLicenceView.LicenceView_Text");
        Object[] options = new Object[]{this.myResourceBundle.getString("CloseAction_Text")};
        String[] text = new String[]{headLine, message};
        if (this.myProgressController != null) {
            this.myProgressController.fail();
        }
        this.myCloseMessage.operationFinished(this);
        JOptionPane.showOptionDialog(this, text, title, -1, messageType, null, options, options[0]);
        this.myOperationOngoing = 0;
        if (!this.mySelectedLicences.isEmpty()) {
            this.areOperationsSupported();
        }
        this.enableDownloadButtons(true);
        this.myCloseButton.setEnabled(true);
        this.myOperatedLicences.clear();
    }

    protected void updateDetailsView() {
        Calendar endTime;
        Calendar startTime;
        List<String> targetIds;
        Set<String> features;
        Collection<String> featureNames;
        DateFormat format = TimestampFormatter.getShortFormatter();
        String startDate = null;
        String endDate = null;
        String downloadDate = null;
        if (this.myDownloadableLicence != null) {
            this.myBrowsedLicencePanel.clear();
            featureNames = this.myDownloadableLicence.getFeatureNames();
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.featureName"), featureNames);
            features = this.myDownloadableLicence.getFeatureCodes();
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.featureCode"), features);
            if (this.myDownloadableLicence.getLicenceFile() != null) {
                this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.fileName"), this.myDownloadableLicence.getLicenceFile().getName());
            }
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.LicenseCode"), this.myDownloadableLicence.getLicenceCode());
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.targetElement"), this.myDownloadableLicence.getElementType());
            targetIds = this.myDownloadableLicence.getElementCodes();
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.targetId"), targetIds);
            startTime = this.myDownloadableLicence.getStartTime();
            startDate = startTime != null ? format.format(startTime.getTime()) : "";
            endTime = this.myDownloadableLicence.getEndTime();
            endDate = endTime != null ? format.format(endTime.getTime()) : "";
            long capacity = this.myDownloadableLicence.getCapacity();
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.startTime"), startDate);
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.endTime"), endDate);
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.capacity"), capacity == -1L ? this.myResourceBundle.getString("NotApplicable_Text") : String.valueOf(capacity));
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.customerName"), this.myDownloadableLicence.getCustomerName());
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.customerId"), this.myDownloadableLicence.getCustomerId());
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.orderId"), this.myDownloadableLicence.getOrderId());
            this.myBrowsedLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.serialNumber"), this.myDownloadableLicence.getSerialNumber());
        } else {
            this.myBrowsedLicencePanel.clear();
        }
        if (this.mySelectedLicence != null) {
            this.myExistingLicencePanel.clear();
            featureNames = this.mySelectedLicence.getFeatureNames();
            this.myExistingLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.featureName"), featureNames);
            features = this.mySelectedLicence.getFeatureCodes();
            this.myExistingLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.featureCode"), features);
            if (this.mySelectedLicence.getLicenceFile() != null) {
                this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.fileName"), this.mySelectedLicence.getLicenceFile().getName());
            }
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.targetElement"), this.mySelectedLicence.getElementType());
            targetIds = this.mySelectedLicence.getElementCodes();
            if (targetIds != null && !targetIds.contains("parameterNotSupported") || targetIds == null) {
                this.myExistingLicencePanel.addData(this.myResourceBundle.getString("PLicenceView.targetId"), targetIds);
            }
            startDate = (startTime = this.mySelectedLicence.getStartTime()) != null ? format.format(startTime.getTime()) : "";
            endTime = this.mySelectedLicence.getEndTime();
            endDate = endTime != null ? format.format(endTime.getTime()) : "";
            Calendar downloadTime = this.mySelectedLicence.getDownloadTime();
            downloadDate = downloadTime != null ? format.format(downloadTime.getTime()) : "";
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.startTime"), startDate);
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.endTime"), endDate);
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.downloadTime"), downloadDate);
            long capacity = this.mySelectedLicence.getCapacity();
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.capacity"), capacity < 0L ? this.myResourceBundle.getString("NotApplicable_Text") : String.valueOf(capacity));
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.customerName"), this.mySelectedLicence.getCustomerName());
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.customerId"), this.mySelectedLicence.getCustomerId());
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.orderId"), this.mySelectedLicence.getOrderId());
            this.updateExistingLicencePanel(this.myResourceBundle.getString("PLicenceView.serialNumber"), this.mySelectedLicence.getSerialNumber());
        } else {
            this.myExistingLicencePanel.clear();
        }
    }

    private void updateExistingLicencePanel(String label, String value) {
        if (value != null && !value.equals("parameterNotSupported") || value == null) {
            this.myExistingLicencePanel.addData(label, value);
        }
    }

    protected void allLicencesGetNotify() {
        if (this.myExistingLicences.isEmpty()) {
            return;
        }
        if (this.myLicenceTable.getRowCount() > 0 && this.mySelectedRow == -1) {
            this.myLicenceTable.setRowSelectionInterval(0, 0);
        } else if (this.mySelectedRow >= 0 && this.mySelectedRow <= this.myLicenceTable.getRowCount() - 1) {
            this.myLicenceTable.setRowSelectionInterval(this.mySelectedRow, this.mySelectedRow);
        }
    }

    public void updateLicenceTable(List<PLicence> licences) {
        this.mySelectedRow = this.myLicenceTable.getSelectedRow();
        if (licences == null || licences.isEmpty() || this.myExistingLicences == null) {
            return;
        }
        for (PLicence licence : licences) {
            if (this.myExistingLicences.containsKey(licence.getFileId())) continue;
            this.myExistingLicences.put(licence.getFileId(), licence);
            this.addLicenceToTable(licence);
        }
        this.myLicenceTableModel.setContents(this.myLicencesInTable);
        this.repaint();
    }

    public void removeLicences(String elementType) {
        ArrayList<PLicence> savedLicences = new ArrayList<PLicence>();
        ArrayList<String> removableLicFileIds = new ArrayList<String>();
        for (String fileIdKey : this.myExistingLicences.keySet()) {
            PLicence item = this.myExistingLicences.get(fileIdKey);
            if (item.getElementType().equals(elementType)) {
                removableLicFileIds.add(fileIdKey);
                continue;
            }
            savedLicences.add(item);
        }
        for (String removed : removableLicFileIds) {
            this.myExistingLicences.remove(removed);
        }
        this.myLicencesInTable.clear();
        for (PLicence lic : savedLicences) {
            this.addLicenceToTable(lic);
        }
    }

    public void removeLicences(List<PLicence> licences) {
        for (PLicence lic : licences) {
            this.myExistingLicences.remove(lic.getFileId());
        }
        Collection<PLicence> savedLicences = this.myExistingLicences.values();
        this.myLicencesInTable.clear();
        for (PLicence lic : savedLicences) {
            this.addLicenceToTable(lic);
        }
    }

    public void setLicenceFileValidator(PLicenceValidator validator) {
        this.myLicenceFileValidator = validator;
        ((PLicenceModifiedOpen)this.myFileSelectionCombo.getFileChooser()).setLicenceValidator(this.myLicenceFileValidator);
    }

    protected Collection<PLicence> getExistingLicences() {
        return this.myExistingLicences.values();
    }

    private void addLicenceToTable(PLicence licence) {
        for (String featCode : licence.getFeatureCodes()) {
            this.myLicencesInTable.add(PLicenceView.createLicenceToTable(licence, featCode));
        }
        this.myLicenceTableModel.setContents(this.myLicencesInTable);
        this.repaint();
    }

    protected void downloadCompleted() {
        ArrayList<PLicence> downloadLicList = new ArrayList<PLicence>();
        downloadLicList.add(this.myDownloadableLicence);
        this.updateLicenceTable(downloadLicList);
        this.myOperationOngoing = 0;
        this.areOperationsSupported();
        this.enableDownloadButtons(true);
        this.myCloseButton.setEnabled(true);
        this.myProgressController.stop();
        this.myCloseMessage.operationFinished(this);
        this.repaint();
    }

    protected PLicence getCurrentDownloadableLicence() {
        return this.myDownloadableLicence;
    }

    protected void activateCompleted() {
        this.myExistingLicences.get(this.myOperatedLicences.get(0).getFileId()).setStatus(PLicence.LICENCE_STATUS.ACTIVE);
        for (PLicence item : this.myLicencesInTable) {
            if (!item.getFileId().equals(this.myOperatedLicences.get(0).getFileId())) continue;
            item.setStatus(PLicence.LICENCE_STATUS.ACTIVE);
        }
        this.myOperationOngoing = 0;
        this.areOperationsSupported();
        this.myLicenceTable.repaint();
        this.myOperatedLicences.clear();
    }

    protected void deactivateCompleted() {
        this.myExistingLicences.get(this.myOperatedLicences.get(0).getFileId()).setStatus(PLicence.LICENCE_STATUS.INACTIVE);
        for (PLicence item : this.myLicencesInTable) {
            if (!item.getFileId().equals(this.myOperatedLicences.get(0).getFileId())) continue;
            item.setStatus(PLicence.LICENCE_STATUS.INACTIVE);
        }
        this.myOperationOngoing = 0;
        this.areOperationsSupported();
        this.myLicenceTable.repaint();
        this.myOperatedLicences.clear();
    }

    protected PLicence getOperatedLicence() {
        return this.myOperatedLicences.get(0);
    }

    protected String getManagedElementName() {
        return this.myElementName;
    }

    protected void uploadCompleted(boolean licRemoved) {
        if (licRemoved) {
            this.removeLicences(this.myOperatedLicences);
            this.mySelectedLicences.clear();
            this.mySelectedLicence = null;
        }
        this.myLicenceTable.repaint();
        this.updateDetailsView();
        this.myOperationOngoing = 0;
        this.areOperationsSupported();
        this.myProgressController.stop();
        this.myOperatedLicences.clear();
        this.myCloseMessage.operationFinished(this);
    }

    protected void deleteCompleted() {
        this.removeLicences(this.myOperatedLicences);
        this.mySelectedLicences.clear();
        this.mySelectedLicence = null;
        this.updateDetailsView();
        if (this.myExistingLicences.isEmpty()) {
            this.myLicenceTableModel.setContents(this.myLicencesInTable);
        }
        this.myLicenceTable.repaint();
        this.myOperationOngoing = 0;
        this.areOperationsSupported();
        this.myProgressController.stop();
        this.myOperatedLicences.clear();
        this.myCloseButton.setEnabled(true);
        this.myCloseMessage.operationFinished(this);
    }

    private void enableTableButtons(boolean enable) {
        this.myActivateButton.setEnabled(enable);
        this.myDeactivateButton.setEnabled(enable);
        this.myDeleteButton.setEnabled(enable);
        this.myUploadButton.setEnabled(enable);
    }

    private PLicence parseLicence() {
        Object selectedFile = this.myFileSelectionCombo.getSelectedItem();
        boolean isFileExisting = PFileUtils.isFileExisting(selectedFile);
        PLicence parsedLic = null;
        if (selectedFile != null && selectedFile.equals(this.myLastSelectedFile) && this.myFtpTransferInfo.myHost == null && isFileExisting) {
            return this.myDownloadableLicence;
        }
        this.myLastSelectedFile = null;
        if (this.myFtpTransferInfo.myHost != null) {
            FtpClient ftpClient = new FtpClient();
            try {
                ftpClient.connect(this.myFtpTransferInfo.myHost, 21);
                ftpClient.login(this.myFtpTransferInfo.myUsername, new String(this.myFtpTransferInfo.myPassword));
                String path = String.valueOf(System.getProperty("user.home")) + System.getProperty("file.separator") + "tempLicence.xml";
                ftpClient.getFile(((File)selectedFile).getName(), path);
                ftpClient.disconnect();
            }
            catch (FtpException pe) {
                Object[] params = new Object[2];
                params[0] = this.myFtpTransferInfo.myHost;
                String message = this.myResourceBundle.getString("PLicenceView.FTP_Connect_Failed");
                String headLine = this.myResourceBundle.getString("PLicenceView.FTP_Connect_Failed_Headline");
                String title = this.myResourceBundle.getString("PLicenceView.LicenceView_Text");
                this.operationFailed(1, title, headLine, message);
                try {
                    ftpClient.disconnect();
                }
                catch (FtpException ex) {
                    this.myLogger.error("FTP client disconnection failed.");
                }
            }
        }
        if (selectedFile instanceof File) {
            try {
                parsedLic = PLicenceParser.parse((File)selectedFile);
                this.myLastSelectedFile = (File)selectedFile;
            }
            catch (Exception exception) {
                this.operationFailed(1, this.myResourceBundle.getString("PLicenceView.LicenceView_Text"), this.myResourceBundle.getString("PLicenceView.Cannot_Open_HeadLine"), this.myResourceBundle.getString("PLicenceView.Cannot_Open"));
                this.myFileSelectionCombo.setSelectedItem(null);
                this.myFileSelectionCombo.removeItem(selectedFile);
            }
        }
        return parsedLic;
    }

    private void enableDownloadButtons(boolean enable) {
        this.myDownloadButton.setEnabled(enable);
        this.myServerButton.setEnabled(enable);
        this.myFileSelectionCombo.setEnabled(enable);
        if (this.myDownloadableLicence == null && this.myFtpTransferInfo.myHost == null) {
            this.myDownloadButton.setEnabled(false);
        }
    }

    public static PLicence createLicenceToTable(PLicence licence, String featureCode) {
        HashMap<String, String> featureMap = new HashMap<String, String>();
        featureMap.put(featureCode, licence.getFeatureName(featureCode));
        HashMap<String, String> statusMap = new HashMap<String, String>();
        statusMap.put(featureCode, licence.getFeatureStatus(featureCode));
        PLicence copiedLicence = new PLicence();
        copiedLicence.setCapacity(licence.getCapacity());
        copiedLicence.setCustomerId(licence.getCustomerId());
        copiedLicence.setCustomerName(licence.getCustomerName());
        copiedLicence.setDownloadTime(licence.getDownloadTime());
        copiedLicence.setElementCodes(licence.getElementCodes());
        copiedLicence.setElementType(licence.getElementType());
        copiedLicence.setEndTime(licence.getEndTime());
        copiedLicence.setFileId(licence.getFileId());
        copiedLicence.setFeatureData(featureMap);
        copiedLicence.setLicenceName(licence.getLicenceName());
        copiedLicence.setLicenceCode(licence.getLicenceCode());
        copiedLicence.setLicenceFile(licence.getLicenceFile());
        copiedLicence.setOrderId(licence.getOrderId());
        copiedLicence.setSerialNumber(licence.getSerialNumber());
        copiedLicence.setStartTime(licence.getStartTime());
        copiedLicence.setStatus(licence.getStatus());
        copiedLicence.setFeatureStatusData(statusMap);
        return copiedLicence;
    }

    public void updateUI() {
        this.repaint();
    }

    protected void helpRequest() {
        this.myLicenceController.licenceViewHelpRequested();
    }

    private void downloadButtonPressed() {
        PLicence parsedLic;
        if (!this.myLicenceController.isSnapshotMode()) {
            this.enableTableButtons(false);
            this.enableDownloadButtons(false);
            this.myCloseButton.setEnabled(false);
        }
        boolean parseFlag = true;
        if (this.myFtpTransferInfo.myHost == null && this.myDownloadableLicence != null) {
            parseFlag = false;
            if (!this.myLicenceController.isSnapshotMode() && !this.myLicenceController.isReadOnlyMode()) {
                this.myProgressController.start();
                this.myProgressModel.setProgressText(String.valueOf(this.myResourceBundle.getString("PLicenceView.DownloadingFile")) + " " + this.myElementName);
                this.myOperationOngoing = 1;
            }
            this.downloadLicence(this.myDownloadableLicence, this.myProgressModel);
        }
        if (parseFlag && (parsedLic = this.parseLicence()) != null && parsedLic.getElementType() != null && parsedLic.getLicenceFile() != null) {
            this.myDownloadableLicence = parsedLic;
            if (!this.myLicenceController.isSnapshotMode() && !this.myLicenceController.isReadOnlyMode()) {
                this.myProgressController.start();
                this.myProgressModel.setProgressText(String.valueOf(this.myResourceBundle.getString("PLicenceView.DownloadingFile")) + " " + this.myElementName);
                this.myOperationOngoing = 1;
            }
            this.downloadLicence(this.myDownloadableLicence, this.myProgressModel);
        }
    }

    private void downloadLicence(PLicence licence, ProgressBarModel progressModel) {
        if (this.myLicenceController.downloadLicence(licence, progressModel)) {
            this.myLogger.debug("Licence file downloading started. File: " + licence.getFileId());
        } else {
            Object[] params = new Object[]{licence.getFileId(), this.getManagedElementName()};
            String message = MessageFormat.format(this.myResourceBundle.getString("PLicenceView.Another_Element"), params);
            String headLine = this.myResourceBundle.getString("PLicenceView.Another_Element_HeadLine");
            String title = this.myResourceBundle.getString("PLicenceView.LicenceView_Text");
            this.operationFailed(999, title, headLine, message);
            this.myLogger.debug(String.valueOf(headLine) + " " + message);
            this.myProgressModel.setProperty("progresstext", "");
        }
    }

    private void uploadButtonPressed() {
        PLicenceModifiedSave saveDialog = new PLicenceModifiedSave(new File(this.restoreFileName()), this.myResourceBundle.getString("PLicenceView.saveTitle"));
        saveDialog.setSettingsKey(this.myResourceBundle.getString("PLicenceView.saveTitle"));
        File saveFile = saveDialog.chooseSavingPath(this, this.mySelectedLicence);
        if (saveFile != null) {
            saveDialog.saveSettings();
            this.storeFileName(saveDialog.getSelectedFile().getPath());
            this.myOperatedLicences.add(this.mySelectedLicence);
            String uploadPath = saveFile.getAbsolutePath();
            if (!this.myLicenceController.isSnapshotMode()) {
                this.enableTableButtons(false);
                this.enableDownloadButtons(false);
                this.myProgressController.start(true);
                this.myOperationOngoing = 2;
                this.myProgressController.start();
                this.myProgressModel.setProgressText(String.valueOf(this.myResourceBundle.getString("PLicenceView.UploadingFile")) + " " + this.myElementName);
            }
            this.myLicenceController.uploadLicence(uploadPath, this.mySelectedLicences, this.myProgressModel);
        }
    }

    private void serverButtonPressed() {
        try {
            new PLicenceOptionsController(this.myLicenceController, this, this.myFtpTransferInfo);
            if (this.myFtpTransferInfo.myHost != null) {
                this.myLicenceFileSourceLabel.setText(this.myResourceBundle.getString("PLicenceView.RemoteSource_Text"));
                this.myFileSelectionCombo.setEditable(true);
            } else {
                this.myLicenceFileSourceLabel.setText(this.myResourceBundle.getString("PLicenceView.LocalSource_Text"));
                this.myFileSelectionCombo.setEditable(false);
            }
        }
        catch (Exception ex1) {
            ex1.printStackTrace();
        }
        this.enableDownloadButtons(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.myDownloadButton)) {
            this.downloadButtonPressed();
        } else if (event.getSource().equals(this.myUploadButton)) {
            if (this.myLicenceController.isLicenceRemovedInUpload(this.mySelectedLicence) && this.uploadConfirmationMessage() != 0) {
                return;
            }
            this.uploadButtonPressed();
        } else if (event.getSource().equals(this.myCloseButton)) {
            this.closeRoutine();
            this.myLicenceController.destroy();
        } else if (event.getSource().equals(this.myActivateButton)) {
            this.myOperatedLicences.add(this.mySelectedLicence);
            this.enableTableButtons(false);
            this.enableDownloadButtons(false);
            this.myOperationOngoing = 4;
            this.myLicenceController.activateLicence(this.mySelectedLicences);
        } else if (event.getSource().equals(this.myDeactivateButton)) {
            if (this.deactivationConfiramtionMessage() == 0) {
                this.myOperatedLicences.add(this.mySelectedLicence);
                this.enableTableButtons(false);
                this.enableDownloadButtons(false);
                this.myOperationOngoing = 5;
                this.myLicenceController.deactivateLicence(this.mySelectedLicences);
            }
        } else if (event.getSource().equals(this.myServerButton)) {
            this.serverButtonPressed();
        } else if (event.getSource().equals(this.myDeleteButton)) {
            int option = this.deleteConfirmationMessage();
            if (option == 0) {
                if (!this.myLicenceController.isSnapshotMode() && !this.myLicenceController.isReadOnlyMode()) {
                    this.enableTableButtons(false);
                    this.enableDownloadButtons(false);
                    this.myOperatedLicences.add(this.mySelectedLicence);
                    this.myOperationOngoing = 3;
                    this.myProgressController.start();
                    this.myProgressModel.setProgressText(String.valueOf(this.myResourceBundle.getString("PLicenceView.DeletingFile")) + " " + this.myElementName);
                }
                this.myCloseButton.setEnabled(false);
                this.myLicenceController.deleteLicence(this.mySelectedLicences, this.myProgressModel);
            }
        } else if (event.getSource().equals(this.myHelpButton)) {
            this.helpRequest();
        } else if (event.getSource().equals(this.myFileSelectionCombo)) {
            this.myProgressModel.setProgressText("");
            this.myProgressModel.setProgressState(2);
            this.myProgressModel.setElapsedTime(0);
            if (this.myFtpTransferInfo.myHost == null) {
                this.myDownloadableLicence = this.parseLicence();
                this.myDownloadButton.setEnabled(this.myDownloadableLicence != null);
            }
            this.updateDetailsView();
            this.myDetailsTabbedPane.setSelectedIndex(1);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (e.getSource().equals(this.myLicenceTable)) {
            this.myDetailsTabbedPane.setSelectedIndex(0);
        } else if (e.getSource().equals(this.myFileSelectionCombo)) {
            if (this.myFtpTransferInfo.myHost != null) {
                this.myFileSelectionCombo.setEditable(true);
            } else {
                this.myFileSelectionCombo.setEditable(false);
                PLicence parsedLic = this.parseLicence();
                if (parsedLic != null) {
                    this.myDownloadableLicence = parsedLic;
                    this.myDownloadButton.setEnabled(true);
                } else if (this.myFtpTransferInfo.myHost != null || parsedLic == null) {
                    this.myDownloadableLicence = null;
                }
            }
            this.enableDownloadButtons(true);
            this.updateDetailsView();
            this.myDetailsTabbedPane.setSelectedIndex(1);
        } else if (e.getSource().equals(this.myDetailsTabbedPane)) {
            this.updateDetailsView();
        }
    }

    public void updateTransferInfoRequest(FtpConnectionInfo swTransferInfo) {
        this.myFtpTransferInfo = swTransferInfo;
    }

    private JButton createOKButton(String textKey, String mnemonicKey, final SelectionHolder response) {
        JButton deleteButton = new JButton(this.myResourceBundle.getString(textKey));
        deleteButton.setMnemonic(this.myResourceBundle.getMnemonic(mnemonicKey));
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                response.setSelection(0);
                Window window = SwingUtilities.getWindowAncestor((Component)e.getSource());
                if (window != null) {
                    window.dispose();
                }
            }
        });
        return deleteButton;
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource().equals(this.myLicenceTable) && this.myLicenceTable.getSelectedRowCount() < 0) {
            this.mySelectedLicences.clear();
            this.myExistingLicencePanel.clear();
            this.myExistingLicencePanel.repaint();
            this.enableTableButtons(false);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.myDetailsTabbedPane)) {
            PLicence parsedLic;
            if (this.myFtpTransferInfo.myHost != null && (parsedLic = this.parseLicence()) != null) {
                this.myDownloadableLicence = parsedLic;
            }
            this.updateDetailsView();
        }
    }

    private class LicenceTableCellRenderer
    extends PTableCellRenderer {
        private LicenceTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                label.setText("");
            } else if (value instanceof Calendar) {
                label.setText(PLicenceView.this.myDateFormat.format(((Calendar)value).getTime()));
            }
            return label;
        }
    }

    private static class SelectionHolder {
        private int mySelection = 2;

        private SelectionHolder() {
        }

        public void setSelection(int value) {
            this.mySelection = value;
        }

        public int getSelection() {
            return this.mySelection;
        }
    }
}

