/*
 * Decompiled with CFR 0.152.
 */
package com.nokia.em.poseidon.gui.print;

import com.nokia.em.poseidon.PoseidonRuntime;
import com.nokia.em.poseidon.frameworks.event.EventProcessor;
import com.nokia.em.poseidon.frameworks.i18n.I18n;
import com.nokia.em.poseidon.frameworks.i18n.ResourceBundle;
import com.nokia.em.poseidon.frameworks.mvc.ControllerBase;
import com.nokia.em.poseidon.frameworks.print.PPrintableDoc;
import com.nokia.em.poseidon.gui.common.events.DialogCloseEvent;
import com.nokia.em.poseidon.gui.print.PPrintDialog;
import com.nokia.em.poseidon.services.help.PHelp;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.attribute.HashDocAttributeSet;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.swing.Action;
import org.apache.log4j.Logger;

public class PPrintControl
extends ControllerBase
implements EventProcessor {
    private PPrintDialog myPrintDialog;
    private PrintService myDefaultPrintService;
    private PrintService[] myPrintServices;
    private PPrintableDoc myPrintableDoc;
    private HashPrintRequestAttributeSet myPrintReqAttrSet;
    private Map myProperties;
    private ResourceBundle myBundle = I18n.getI18n().getBundle(this.getClass());

    public PPrintControl(PPrintableDoc printableDoc, Map properties) {
        PoseidonRuntime.getRuntime().addObject(this);
        this.myPrintableDoc = printableDoc;
        this.myProperties = properties;
        DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
        this.myPrintReqAttrSet = new HashPrintRequestAttributeSet();
        this.myDefaultPrintService = PrintServiceLookup.lookupDefaultPrintService();
        this.myPrintServices = PrintServiceLookup.lookupPrintServices(flavor, this.myPrintReqAttrSet);
        this.myPrintDialog = properties != null && properties.containsKey("parentfame") ? new PPrintDialog(this, (Frame)properties.get("parentfame")) : (properties != null && properties.containsKey("parentdialog") ? new PPrintDialog(this, (Dialog)properties.get("parentdialog")) : new PPrintDialog(this));
        this.repaginate();
        this.myPrintDialog.updateMediaSelections();
        this.myPrintDialog.setVisible(true);
    }

    @Override
    public PPrintDialog getView() {
        return this.myPrintDialog;
    }

    public Object getProperty(String key) {
        return this.myProperties.get(key);
    }

    public void setProperty(String key, Object value) {
        this.myProperties.put(key, value);
    }

    public boolean isDefined(String key) {
        return this.myProperties.containsKey(key);
    }

    public Map getProperties() {
        return this.myProperties;
    }

    public void startPrinting(PrintService printService) {
        final DocPrintJob printJob = printService.createPrintJob();
        final SimpleDoc printDoc = new SimpleDoc(this.myPrintableDoc, DocFlavor.SERVICE_FORMATTED.PRINTABLE, new HashDocAttributeSet());
        Thread printThread = new Thread(){

            @Override
            public void run() {
                try {
                    Logger.getLogger(this.getClass()).debug("Start printing document.");
                    printJob.print(printDoc, PPrintControl.this.createPrintRequestAttributeSet());
                }
                catch (PrintException e) {
                    Logger.getLogger(this.getClass()).error("Exception thrown when printing document", e);
                }
            }
        };
        printThread.start();
    }

    @Override
    public void destroy() {
        PoseidonRuntime.getRuntime().removeObject(this);
        if (this.myPrintDialog != null) {
            this.myPrintDialog.dispose();
        }
    }

    public PrintService getDefaultPrintService() {
        return this.myDefaultPrintService;
    }

    public PrintService[] getPrintServices() {
        return this.myPrintServices;
    }

    public PrintService getPrintService(int index) {
        if (index < this.myPrintServices.length && index > -1) {
            return this.myPrintServices[index];
        }
        return null;
    }

    public void helpRequested() {
        if (this.isDefined("helpaction")) {
            Action helpAction = (Action)this.getProperty("helpaction");
            helpAction.actionPerformed(null);
        } else {
            PoseidonRuntime.getRuntime().getService(PHelp.class).showHelp(this.getView(), "Poseidon_Print");
        }
    }

    public String getLocation(PrintService printService) {
        PrinterLocation location = printService.getAttribute(PrinterLocation.class);
        return location != null ? location.getName() : this.myBundle.getString("PPrintDialog.printServiceLocationNotAvailable_Text");
    }

    public String getStatus(PrintService printService) {
        PrinterIsAcceptingJobs state = printService.getAttribute(PrinterIsAcceptingJobs.class);
        return state == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS ? this.myBundle.getString("PPrintDialog.printServiceNotAcceptingJob_Text") : this.myBundle.getString("PPrintDialog.printServiceAcceptingJob_Text");
    }

    public String getMakeAndModel(PrintService printService) {
        PrinterMakeAndModel makeAndModel = printService.getAttribute(PrinterMakeAndModel.class);
        return makeAndModel != null ? makeAndModel.getName() : this.myBundle.getString("PPrintDialog.printServiceTypeNotAvailable_Text");
    }

    public Media[] getAvailableSources(PrintService printService) {
        return this.getAvailableMediaForType(printService, MediaTray.class);
    }

    public Media[] getAvailableSizes(PrintService printService) {
        return this.getAvailableMediaForType(printService, MediaSizeName.class);
    }

    public Media getDefaultSize(PrintService printService) {
        return (Media)printService.getDefaultAttributeValue(Media.class);
    }

    public void repaginate() {
        PageFormat pFormat = this.createPageFormat();
        this.myPrintDialog.setPageCount(this.myPrintableDoc.getPrintablePageCount(pFormat));
    }

    private PrintRequestAttributeSet createPrintRequestAttributeSet() {
        HashPrintRequestAttributeSet praset = new HashPrintRequestAttributeSet();
        MediaSizeName size = this.myPrintDialog.getSelectedMediaSize();
        Media source = this.myPrintDialog.getSelectedMediaSource();
        MediaSize mediaSize = null;
        if (!this.myPrintDialog.isAutomaticSourceSelected() && source != null) {
            praset.add(source);
        } else {
            praset.add(size != null ? size : MediaSizeName.ISO_A4);
        }
        praset.add(new Copies(this.myPrintDialog.getNumberOfCopies()));
        if (this.myPrintDialog.isRangePages() && this.myPrintDialog.getPrintPagesFrom() <= this.myPrintDialog.getPrintPagesTo()) {
            praset.add(new PageRanges(this.myPrintDialog.getPrintPagesFrom(), this.myPrintDialog.getPrintPagesTo()));
        }
        praset.add(this.myPrintDialog.isPortraitSelected() ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE);
        mediaSize = size != null ? MediaSize.getMediaSizeForName(size) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        praset.add(this.createPrintableArea(mediaSize));
        return praset;
    }

    private MediaPrintableArea createPrintableArea(MediaSize mediaSize) {
        float[] maxSize = mediaSize.getSize(25400);
        float x = (float)this.myPrintDialog.getLeftMargin();
        float y = (float)this.myPrintDialog.getTopMargin();
        float width = maxSize[0] - (float)this.myPrintDialog.getRightMargin() - x;
        float height = maxSize[1] - (float)this.myPrintDialog.getBottomMargin() - y;
        if (width <= 0.0f) {
            width = 0.1f;
        }
        if (height <= 0.0f) {
            height = 0.1f;
        }
        MediaPrintableArea area = new MediaPrintableArea(x, y, width, height, 25400);
        return area;
    }

    private PageFormat createPageFormat() {
        PageFormat pFormat = new PageFormat();
        Paper paper = new Paper();
        MediaSizeName size = this.myPrintDialog.getSelectedMediaSize();
        MediaSize mediaSize = null;
        pFormat.setOrientation(this.myPrintDialog.isLandscapeSelected() ? 0 : 1);
        mediaSize = size != null ? MediaSize.getMediaSizeForName(size) : MediaSize.getMediaSizeForName(MediaSizeName.ISO_A4);
        int unit = 25400;
        float[] maxSize = mediaSize.getSize(unit);
        double x = this.myPrintDialog.getLeftMargin();
        double y = this.myPrintDialog.getTopMargin();
        double width = (double)maxSize[0] - this.myPrintDialog.getRightMargin() - x;
        double height = (double)maxSize[1] - this.myPrintDialog.getBottomMargin() - y;
        if (width <= 0.0) {
            width = 0.1;
        }
        if (height <= 0.0) {
            height = 0.1;
        }
        paper.setSize(maxSize[0], maxSize[1]);
        paper.setImageableArea(x, y, width, height);
        pFormat.setPaper(paper);
        return pFormat;
    }

    private Media[] getAvailableMediaForType(PrintService printService, Class mediaClass) {
        ArrayList<Media> result = new ArrayList<Media>();
        if (printService != null) {
            DocFlavor.SERVICE_FORMATTED flavor = DocFlavor.SERVICE_FORMATTED.PRINTABLE;
            Media[] mediaTypes = (Media[])printService.getSupportedAttributeValues(Media.class, flavor, null);
            int mt = 0;
            while (mediaTypes != null && mt < mediaTypes.length) {
                Media mediaType = mediaTypes[mt];
                if (mediaClass.isAssignableFrom(mediaType.getClass())) {
                    result.add(mediaType);
                }
                ++mt;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result.toArray(new Media[result.size()]);
    }

    @Override
    public void processEvent(EventObject event) {
        if (event instanceof DialogCloseEvent) {
            this.destroy();
        }
    }
}

